/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.spi.conditions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.scripting.ScriptExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionContextHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConditionContextHelper.class);
    private static final Map<Character, String> FOLD_MAPPING = new HashMap<Character, String>();

    private static void loadMappingFile() throws IOException {
        block15: {
            try (InputStream is = ConditionContextHelper.class.getClassLoader().getResourceAsStream("mapping-FoldToASCII.txt");){
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                block12: while (true) {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        String[] parts;
                        if (line.trim().isEmpty() || line.startsWith("#") || !line.contains("=>") || (parts = line.split("=>")).length != 2) continue;
                        String unicodeStr = parts[0].trim();
                        String asciiStr = parts[1].trim();
                        if (!unicodeStr.startsWith("\"\\u") || !unicodeStr.endsWith("\"")) continue;
                        String hexCode = unicodeStr.substring(3, unicodeStr.length() - 1);
                        try {
                            char unicodeChar = (char)Integer.parseInt(hexCode, 16);
                            if (!asciiStr.startsWith("\"") || !asciiStr.endsWith("\"")) continue block12;
                            String asciiValue = asciiStr.substring(1, asciiStr.length() - 1);
                            FOLD_MAPPING.put(Character.valueOf(unicodeChar), asciiValue);
                            continue block12;
                        }
                        catch (NumberFormatException e) {
                            LOGGER.warn("Format de code Unicode invalide: {}", (Object)hexCode);
                        }
                    }
                    break block15;
                    {
                        continue block12;
                        break;
                    }
                    break;
                }
                finally {
                    reader.close();
                }
            }
        }
    }

    public static Condition getContextualCondition(Condition condition, Map<String, Object> context, ScriptExecutor scriptExecutor) {
        if (!ConditionContextHelper.hasContextualParameter(condition.getParameterValues())) {
            return condition;
        }
        Map values = (Map)ConditionContextHelper.parseParameter(context, condition.getParameterValues(), scriptExecutor);
        if (values == null) {
            return null;
        }
        Condition n = new Condition(condition.getConditionType());
        n.setParameterValues(values);
        return n;
    }

    private static Object parseParameter(Map<String, Object> context, Object value, ScriptExecutor scriptExecutor) {
        if (value instanceof String) {
            if (((String)value).startsWith("parameter::") || ((String)value).startsWith("script::")) {
                String s = (String)value;
                if (s.startsWith("parameter::")) {
                    return context.get(StringUtils.substringAfter((String)s, (String)"parameter::"));
                }
                if (s.startsWith("script::")) {
                    String script = StringUtils.substringAfter((String)s, (String)"script::");
                    return scriptExecutor.execute(script, context);
                }
            }
        } else {
            if (value instanceof Map) {
                HashMap<String, Object> values = new HashMap<String, Object>();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    Object parameter = ConditionContextHelper.parseParameter(context, entry.getValue(), scriptExecutor);
                    if (parameter == null) {
                        return null;
                    }
                    values.put((String)entry.getKey(), parameter);
                }
                return values;
            }
            if (value instanceof List) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (Object o : (List)value) {
                    Object parameter = ConditionContextHelper.parseParameter(context, o, scriptExecutor);
                    if (parameter == null) continue;
                    values.add(parameter);
                }
                return values;
            }
        }
        return value;
    }

    private static boolean hasContextualParameter(Object value) {
        block4: {
            block5: {
                block3: {
                    if (!(value instanceof String)) break block3;
                    if (((String)value).startsWith("parameter::") || ((String)value).startsWith("script::")) {
                        return true;
                    }
                    break block4;
                }
                if (!(value instanceof Map)) break block5;
                for (Object o : ((Map)value).values()) {
                    if (!ConditionContextHelper.hasContextualParameter(o)) continue;
                    return true;
                }
                break block4;
            }
            if (!(value instanceof List)) break block4;
            for (Object o : (List)value) {
                if (!ConditionContextHelper.hasContextualParameter(o)) continue;
                return true;
            }
        }
        return false;
    }

    public static String forceFoldToASCII(Object object) {
        if (object != null) {
            return ConditionContextHelper.foldToASCII(object.toString());
        }
        return null;
    }

    public static Collection<String> forceFoldToASCII(Collection<?> collection) {
        if (collection != null) {
            return collection.stream().map(ConditionContextHelper::forceFoldToASCII).collect(Collectors.toList());
        }
        return null;
    }

    public static String[] foldToASCII(String[] s) {
        if (s != null) {
            for (int i = 0; i < s.length; ++i) {
                s[i] = ConditionContextHelper.foldToASCII(s[i]);
            }
        }
        return s;
    }

    public static String foldToASCII(String s) {
        if (s == null) {
            return null;
        }
        s = s.toLowerCase();
        StringBuilder result = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            String mapped = FOLD_MAPPING.get(Character.valueOf(c));
            if (mapped != null) {
                result.append(mapped);
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static <T> Collection<T> foldToASCII(Collection<T> s) {
        if (s != null) {
            return s.stream().map(o -> {
                if (o instanceof String) {
                    return ConditionContextHelper.foldToASCII((String)o);
                }
                return o;
            }).collect(Collectors.toCollection(ArrayList::new));
        }
        return null;
    }

    static {
        try {
            ConditionContextHelper.loadMappingFile();
        }
        catch (IOException e) {
            LOGGER.error("Erreur lors du chargement du fichier de mapping", (Throwable)e);
        }
    }
}

