/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.string;

import org.apache.wicket.request.Response;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.string.Strings;

public final class CssUtils {
    public static final String INLINE_OPEN_TAG_START = "<style type=\"text/css\"";
    public static final String INLINE_OPEN_TAG = "<style type=\"text/css\">\n";
    public static final String INLINE_CLOSE_TAG = "</style>\n";

    private CssUtils() {
    }

    public static void writeCss(Response response, CharSequence text, String id) {
        CssUtils.writeOpenTag(response, id);
        response.write(text);
        CssUtils.writeCloseTag(response);
    }

    public static void writeOpenTag(Response response, String id) {
        response.write((CharSequence)INLINE_OPEN_TAG_START);
        if (id != null) {
            response.write((CharSequence)(" id=\"" + id + "\""));
        }
        response.write((CharSequence)">\n");
    }

    public static void writeCloseTag(Response response) {
        response.write((CharSequence)INLINE_CLOSE_TAG);
    }

    public static void writeLinkUrl(Response response, CharSequence url, CharSequence media, String markupId) {
        CssUtils.writeLinkUrl(response, url, media, markupId, null);
    }

    public static void writeLinkUrl(Response response, CharSequence url, CharSequence media, String markupId, String rel) {
        response.write((CharSequence)"<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        response.write(Strings.escapeMarkup((CharSequence)url));
        response.write((CharSequence)"\"");
        if (!Strings.isEmpty((CharSequence)media)) {
            response.write((CharSequence)" media=\"");
            response.write(Strings.escapeMarkup((CharSequence)media));
            response.write((CharSequence)"\"");
        }
        if (!Strings.isEmpty((CharSequence)markupId)) {
            response.write((CharSequence)" id=\"");
            response.write(Strings.escapeMarkup((CharSequence)markupId));
            response.write((CharSequence)"\"");
        }
        if (!Strings.isEmpty((CharSequence)rel)) {
            response.write((CharSequence)" rel=\"");
            response.write(Strings.escapeMarkup((CharSequence)rel));
            response.write((CharSequence)"\"");
        }
        response.write((CharSequence)" />");
    }

    public static String key(Class<?> scope, String facet) {
        return Classes.simpleName(scope) + ".CSS." + facet;
    }
}

