/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test.svg;

import java.io.File;
import org.apache.batik.test.svg.SVGRenderingAccuracyTest;

public abstract class PreconfiguredRenderingTest
extends SVGRenderingAccuracyTest {
    public static final String PNG_EXTENSION = ".png";
    public static final String SVG_EXTENSION = ".svg";
    public static final String SVGZ_EXTENSION = ".svgz";
    public static final char PATH_SEPARATOR = '/';
    public static final String[] DEFAULT_VARIATION_PLATFORMS = new String[]{"java6-linux", "java5-osx"};

    public void setId(String id) {
        super.setId(id);
        this.setFile(id);
    }

    public void setFile(String id) {
        String[] variationURLs;
        String svgFile = id;
        String[] dirNfile = this.breakSVGFile(svgFile);
        this.setConfig(this.buildSVGURL(dirNfile[0], dirNfile[1], dirNfile[2]), this.buildRefImgURL(dirNfile[0], dirNfile[1]));
        for (String variationURL : variationURLs = this.buildVariationURLs(dirNfile[0], dirNfile[1])) {
            this.addVariationURL(variationURL);
        }
        this.setSaveVariation(new File(this.buildSaveVariationFile(dirNfile[0], dirNfile[1])));
        this.setCandidateReference(new File(this.buildCandidateReferenceFile(dirNfile[0], dirNfile[1])));
    }

    @Override
    public String getName() {
        return this.getId();
    }

    protected String buildSVGURL(String svgDir, String svgFile, String svgExt) {
        return this.getSVGURLPrefix() + svgDir + svgFile + svgExt;
    }

    protected abstract String getSVGURLPrefix();

    protected String buildRefImgURL(String svgDir, String svgFile) {
        return this.getRefImagePrefix() + svgDir + this.getRefImageSuffix() + svgFile + PNG_EXTENSION;
    }

    protected abstract String getRefImagePrefix();

    protected abstract String getRefImageSuffix();

    public String[] buildVariationURLs(String svgDir, String svgFile) {
        String[] platforms = this.getVariationPlatforms();
        String[] urls = new String[platforms.length + 1];
        urls[0] = this.getVariationPrefix() + svgDir + this.getVariationSuffix() + svgFile + PNG_EXTENSION;
        for (int i = 0; i < platforms.length; ++i) {
            urls[i + 1] = this.getVariationPrefix() + svgDir + this.getVariationSuffix() + svgFile + '_' + platforms[i] + PNG_EXTENSION;
        }
        return urls;
    }

    protected abstract String getVariationPrefix();

    protected abstract String getVariationSuffix();

    protected abstract String[] getVariationPlatforms();

    public String buildSaveVariationFile(String svgDir, String svgFile) {
        return this.getSaveVariationPrefix() + svgDir + this.getSaveVariationSuffix() + svgFile + PNG_EXTENSION;
    }

    protected abstract String getSaveVariationPrefix();

    protected abstract String getSaveVariationSuffix();

    public String buildCandidateReferenceFile(String svgDir, String svgFile) {
        return this.getCandidateReferencePrefix() + svgDir + this.getCandidateReferenceSuffix() + svgFile + PNG_EXTENSION;
    }

    protected abstract String getCandidateReferencePrefix();

    protected abstract String getCandidateReferenceSuffix();

    protected String[] breakSVGFile(String svgFile) {
        if (svgFile == null) {
            throw new IllegalArgumentException(svgFile);
        }
        String[] ret = new String[3];
        if (svgFile.endsWith(SVG_EXTENSION)) {
            ret[2] = SVG_EXTENSION;
        } else if (svgFile.endsWith(SVGZ_EXTENSION)) {
            ret[2] = SVGZ_EXTENSION;
        } else {
            throw new IllegalArgumentException(svgFile);
        }
        svgFile = svgFile.substring(0, svgFile.length() - ret[2].length());
        int fileNameStart = svgFile.lastIndexOf(47);
        String svgDir = "";
        if (fileNameStart != -1) {
            if (svgFile.length() < fileNameStart + 2) {
                throw new IllegalArgumentException(svgFile);
            }
            svgDir = svgFile.substring(0, fileNameStart + 1);
            svgFile = svgFile.substring(fileNameStart + 1);
        }
        ret[0] = svgDir;
        ret[1] = svgFile;
        return ret;
    }
}

