/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.failure.mappers;

import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.tasks.testing.failure.TestFailureMapper;
import org.gradle.api.internal.tasks.testing.failure.ThrowableToTestFailureMapper;
import org.gradle.api.tasks.testing.TestFailure;
import org.jspecify.annotations.Nullable;

public class OpenTestAssertionFailedMapper
extends TestFailureMapper {
    @Override
    protected List<String> getSupportedClassNames() {
        return Collections.singletonList("org.opentest4j.AssertionFailedError");
    }

    @Override
    public TestFailure map(Throwable throwable, ThrowableToTestFailureMapper rootMapper) throws Exception {
        Object expectedValue = OpenTestAssertionFailedMapper.invokeMethod(OpenTestAssertionFailedMapper.invokeMethod(throwable, "getExpected"), "getValue");
        Object actualValue = OpenTestAssertionFailedMapper.invokeMethod(OpenTestAssertionFailedMapper.invokeMethod(throwable, "getActual"), "getValue");
        if (OpenTestAssertionFailedMapper.isFileInfo(expectedValue) || OpenTestAssertionFailedMapper.isFileInfo(actualValue)) {
            return OpenTestAssertionFailedMapper.mapFileInfoComparisonFailure(throwable, expectedValue, actualValue);
        }
        return OpenTestAssertionFailedMapper.mapStringBasedComparisonFailure(throwable, expectedValue, actualValue);
    }

    private static TestFailure mapFileInfoComparisonFailure(Throwable throwable, @Nullable Object expected, @Nullable Object actual) throws Exception {
        String expectedPath = OpenTestAssertionFailedMapper.getFilePathOrString(expected);
        byte[] expectedContent = OpenTestAssertionFailedMapper.getContentsOrNull(expected);
        String actualPath = OpenTestAssertionFailedMapper.getFilePathOrString(actual);
        byte[] actualContent = OpenTestAssertionFailedMapper.getContentsOrNull(actual);
        return TestFailure.fromFileComparisonFailure((Throwable)throwable, (String)expectedPath, (String)actualPath, (byte[])expectedContent, (byte[])actualContent, null);
    }

    private static TestFailure mapStringBasedComparisonFailure(Throwable throwable, @Nullable Object expected, @Nullable Object actual) throws Exception {
        String actualString = OpenTestAssertionFailedMapper.getFilePathOrString(actual);
        String expectedString = OpenTestAssertionFailedMapper.getFilePathOrString(expected);
        return TestFailure.fromTestAssertionFailure((Throwable)throwable, (String)expectedString, (String)actualString);
    }

    private static boolean isFileInfo(@Nullable Object value) {
        return value != null && OpenTestAssertionFailedMapper.isAssignableFrom("org.opentest4j.FileInfo", value.getClass());
    }

    private static boolean isAssignableFrom(String className, @Nullable Class<?> aClass) {
        if (aClass == null) {
            return false;
        }
        if (className.equals(aClass.getName())) {
            return true;
        }
        return OpenTestAssertionFailedMapper.isAssignableFrom(className, aClass.getSuperclass());
    }

    private static @Nullable String getFilePathOrString(@Nullable Object value) throws Exception {
        if (value == null) {
            return null;
        }
        if (OpenTestAssertionFailedMapper.isFileInfo(value)) {
            return OpenTestAssertionFailedMapper.invokeMethod(value, "getPath", String.class);
        }
        return value.toString();
    }

    private static byte @Nullable [] getContentsOrNull(@Nullable Object value) throws Exception {
        if (OpenTestAssertionFailedMapper.isFileInfo(value)) {
            return OpenTestAssertionFailedMapper.invokeMethod(value, "getContents", byte[].class);
        }
        return null;
    }
}

