/*******************************************************************************
 * Copyright 2015 Intel Corporation.
 *
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them is governed by
 * the express license under which they were provided to you ('License'). Unless the License provides otherwise,
 * you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
 * documents without Intel's prior written permission.
 * This software and the related documents are provided as is, with no express or implied warranties, other than
 * those that are expressly stated in the License.
 *******************************************************************************/

/*
//   Description:
//       Intel(R) Integrated Performance Primitives (Intel(R) IPP) Resize Functions Wrappers for Threading Layer redefinitions:
//       functions with _L API call their _LT versions
//
//   Content:
//
//
//
*/

#if defined(IPP_ENABLED_THREADING_LAYER_REDEFINITIONS)
  #error \
      "This file is not intended to be compiled with -DIPP_ENABLED_THREADING_LAYER_REDEFINITIONS option. Use this option in your application instead."
#endif

#include "owndefs_tl.h"
#include "ippi_tl.h"

/* //////////////////////////////////////////////////////////// */

IPPFUN(IppStatus, ippiFilterBilateralInit_LT_Proxy,
       (IppiFilterBilateralType filter, IppiSizeL dstRoiSize, IppSizeL kernelWidthHeight, IppDataType dataType, int numChannels,
        IppiDistanceMethodType distMethod, Ipp64f valSquareSigma, Ipp64f posSquareSigma, IppiFilterBilateralSpec *pSpec))
{
    return ippiFilterBilateralInit_LT(filter, dstRoiSize, kernelWidthHeight, dataType, numChannels, distMethod, valSquareSigma, posSquareSigma,
                                      (IppiFilterBilateralSpec_LT *)pSpec);
}

#define ippiFilterBilateralC_LT_Proxy(type, depth, chan)                                                                       \
    IPPFUN(IppStatus, ippiFilterBilateral_##depth##_C##chan##R_LT_Proxy,                                                       \
           (const type *pSrc, IppSizeL srcStep, type *pDst, IppSizeL dstStep, IppiSizeL dstRoiSize, IppiBorderType borderType, \
            const type pBorderValue[chan], const IppiFilterBilateralSpec *pSpec, Ipp8u *pBuffer))                              \
    {                                                                                                                          \
        return ippiFilterBilateral_##depth##_C##chan##R_LT(pSrc, srcStep, pDst, dstStep, dstRoiSize, borderType, pBorderValue, \
                                                           (IppiFilterBilateralSpec_LT *)pSpec, pBuffer);                      \
    }

ippiFilterBilateralC_LT_Proxy(Ipp8u, 8u, 1);
ippiFilterBilateralC_LT_Proxy(Ipp8u, 8u, 3);
ippiFilterBilateralC_LT_Proxy(Ipp32f, 32f, 1);
ippiFilterBilateralC_LT_Proxy(Ipp32f, 32f, 3);
ippiFilterBilateralC_LT_Proxy(Ipp64f, 64f, 1);
ippiFilterBilateralC_LT_Proxy(Ipp64f, 64f, 3);

#define ippiFilterBilateralP3_LT_Proxy(type, depth)                                                                                        \
    IPPFUN(IppStatus, ippiFilterBilateral_##depth##_P3R_LT_Proxy,                                                                          \
           (const type *pSrc[3], IppSizeL srcStep[3], type *pDst[3], IppSizeL dstStep[3], IppiSizeL dstRoiSize, IppiBorderType borderType, \
            const type pBorderValue[3], const IppiFilterBilateralSpec *pSpec, Ipp8u *pBuffer))                                             \
    {                                                                                                                                      \
        return ippiFilterBilateral_##depth##_P3R_LT(pSrc, srcStep, pDst, dstStep, dstRoiSize, borderType, pBorderValue,                    \
                                                    (IppiFilterBilateralSpec_LT *)pSpec, pBuffer);                                         \
    }

ippiFilterBilateralP3_LT_Proxy(Ipp8u, 8u);
ippiFilterBilateralP3_LT_Proxy(Ipp32f, 32f);
ippiFilterBilateralP3_LT_Proxy(Ipp64f, 64f);

/* //////////////////////////////////////////////////////////// */
