<?xml version='1.0' encoding='utf-8'?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet exclude-result-prefixes="msxsl" syntax="norules" version="1.0" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:exsl="http://exslt.org/common" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output indent="yes" method="xml" />
    <xsl:template match="/">
        <bag>
            <vectorQuery id="GETopDown_small" xmlns:blob="http://www.intel.com/2009/BagSchema#blob" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:byte="http://www.w3.org/2001/XMLSchema#byte" xmlns:double="http://www.w3.org/2001/XMLSchema#double" xmlns:float="http://www.w3.org/2001/XMLSchema#float" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:long="http://www.w3.org/2001/XMLSchema#long" xmlns:null="http://www.intel.com/2009/BagSchema#null" xmlns:short="http://www.w3.org/2001/XMLSchema#short" xmlns:unsignedByte="http://www.w3.org/2001/XMLSchema#unsignedByte" xmlns:unsignedInt="http://www.w3.org/2001/XMLSchema#unsignedInt" xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong" xmlns:unsignedShort="http://www.w3.org/2001/XMLSchema#unsignedShort">
                <derivedQuery id="RetiredPipelineSlotsGroup">
                    <queryInherit>/RetiredPipelineSlots_small</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="RetiredPipelineSlotsGroupExpanded">
                            <derivedQuery id="ArithGroup">
                                <queryInherit>/Arith_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="ArithGroupExpanded">
                                        <queryRef>/Non-Div_small</queryRef>
                                        <queryRef>/FPDIV_small</queryRef>
                                        <queryRef>/IDIV_small</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="MemGroup">
                                <queryInherit>/Mem_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="MemGroupExpanded">
                                        <queryRef>/Loads_small</queryRef>
                                        <queryRef>/Stores_small</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="FrontendBoundPipelineSlotsGroup">
                    <queryInherit>/FrontendBoundPipelineSlots_small</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="FrontendBoundPipelineSlotsGroupExpanded">
                            <derivedQuery id="IFetch_LatencyGroup">
                                <queryInherit>/IFetch_Latency_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="IFetch_LatencyGroupExpanded">
                                        <queryRef>/ICacheMisses_small</queryRef>
                                        <queryRef>/ITLBOverhead_small</queryRef>
                                        <queryRef>/BACLEARS_small</queryRef>
                                        <queryRef>/BranchResteers_small</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="IFetch_BandwidthGroup">
                                <queryInherit>/IFetch_Bandwidth_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="IFetch_BandwidthGroupExpanded">
                                        <queryRef>/FEBandwidthCisc_small</queryRef>
                                        <queryRef>/FEBandwidthDecode_small</queryRef>
                                        <queryRef>/PreDecodeWrong_small</queryRef>
                                        <queryRef>/FEOther_small</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="CancelledPipelineSlotsGroup">
                    <queryInherit>/CancelledPipelineSlots_small</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="CancelledPipelineSlotsGroupExpanded">
                            <derivedQuery id="BranchMispredictGroup">
                                <queryInherit>/BranchMispredict_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="BranchMispredictGroupExpanded">
                                        <queryRef>/LSD_Mispredict_small</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="MachineClearsGroup">
                                <queryInherit>/MachineClears_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="MachineClearsGroupExpanded">
                                        <queryRef>/Ucode_Assist_small</queryRef>
                                        <queryRef>/Machine_Restart_small</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="BackendBoundGroup">
                    <queryInherit>/BackendBound_small</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="BackendBoundGroupExpanded">
                            <derivedQuery id="Mem_Sub_Sys_BoundGroup">
                                <queryInherit>/Mem_Sub_Sys_Bound_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="Mem_Sub_Sys_BoundGroupExpanded">
                                        <queryRef>/L2Bound_small</queryRef>
                                        <derivedQuery id="L2MissGroup">
                                            <queryInherit>/L2Miss_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="L2MissGroupExpanded">
                                                    <derivedQuery id="L3BoundGroup">
                                                        <queryInherit>/L3Bound_small</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="L3BoundGroupExpanded">
                                                                <queryRef>/L3_Hit_Bound_small</queryRef>
                                                                <queryRef>/FWD_Bound_small</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/MemBound_small</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="CoreBoundGroup">
                                <queryInherit>/CoreBound_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="CoreBoundGroupExpanded">
                                        <derivedQuery id="Serializing_OperationGroup">
                                            <queryInherit>/Serializing_Operation_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="Serializing_OperationGroupExpanded">
                                                    <queryRef>/Pause_small</queryRef>
                                                    <queryRef>/Tpause_small</queryRef>
                                                    <queryRef>/Fence_small</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>/L1Bound_small</queryRef>
                                        <queryRef>/RB_Bound_small</queryRef>
                                        <queryRef>/StoresBound_small</queryRef>
                                        <derivedQuery id="Execution_BoundGroup">
                                            <queryInherit>/Execution_Bound_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="Execution_BoundGroupExpanded">
                                                    <derivedQuery id="Floating_Point_BoundGroup">
                                                        <queryInherit>/Floating_Point_Bound_small</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="Floating_Point_BoundGroupExpanded">
                                                                <queryRef>/FP_Port0_small</queryRef>
                                                                <queryRef>/FP_Port1_small</queryRef>
                                                                <queryRef>/FP_Port2_small</queryRef>
                                                                <queryRef>/FP_Port3_small</queryRef>
                                                                <queryRef>/FP_STD_small</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <derivedQuery id="Integer_BoundGroup">
                                                        <queryInherit>/Integer_Bound_small</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="Integer_BoundGroupExpanded">
                                                                <queryRef>/Int_Load_Port_small</queryRef>
                                                                <queryRef>/Int_STA_Port_small</queryRef>
                                                                <queryRef>/Int_STD_JMP_Port_small</queryRef>
                                                                <queryRef>/Int_Port0_small</queryRef>
                                                                <queryRef>/Int_Port1_small</queryRef>
                                                                <queryRef>/Int_Port2_small</queryRef>
                                                                <queryRef>/Int_Port3_small</queryRef>
                                                                <queryRef>/Int_Secondary_Ports_small</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="Allocation_BoundGroup">
                                            <queryInherit>/Allocation_Bound_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="Allocation_BoundGroupExpanded">
                                                    <queryRef>/BEAllocRestriction_small</queryRef>
                                                    <queryRef>/LSD_Entry_small</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery displayName="%InfoMetrics" id="InfoMetricsGroup">
                    <description>%InfoMetricsDescriptionAll</description>
                    <valueEval>""</valueEval>
                    <displayAttributes>
                        <boolean:expand>true</boolean:expand>
                        <boolean:allowCollapse>false</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="InfoMetricsExpanded">
                            <queryRef>/StoresBound_Info_small</queryRef>
                            <queryRef>/LoadBound_Info_small</queryRef>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
            </vectorQuery>
            <queryLibrary>
                <derivedQuery displayName="%RetiredPipelineSlots" id="RetiredPipelineSlots_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%RetiredPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/TOPDOWN_RETIRING_ALIAS_small") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%RetiredPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/RetiredPipelineSlots_small") >0.75 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $FALSE ) ]]></minIsBetterEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Arith" id="Arith_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%ArithDescriptionAll</description>
                    <helpKeyword>configs.arith_arithdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/RetiredPipelineSlots_small") - query("/Mem_small") ) if ( query("/RetiredPipelineSlots_small") - query("/Mem_small") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%ArithIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Arith_small") >0.60 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/RetiredPipelineSlots_small") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.60 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_small") - query("/Mem_small") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Non-Div" id="Non-Div_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Non-DivDescriptionAll</description>
                    <helpKeyword>configs.non_div_non_divdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Arith_small") - ( query("/FPDIV_small") + query("/IDIV_small") ) ) ]]></valueEval>
                    <issueText>%Non-DivIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Non-Div_small") >0.60 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Arith_small") >0.60 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/RetiredPipelineSlots_small") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.60 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_small") - query("/Mem_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.IDIV]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FPDIV" id="FPDIV_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FPDIVDescriptionAll</description>
                    <helpKeyword>configs.fpdiv_fpdivdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%FPDIVIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FPDIV_small") >0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Arith_small") >0.60 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/RetiredPipelineSlots_small") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%IDIV" id="IDIV_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%IDIVDescriptionAll</description>
                    <helpKeyword>configs.idiv_idivdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_RETIRED.IDIV]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%IDIVIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/IDIV_small") >0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Arith_small") >0.60 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/RetiredPipelineSlots_small") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.IDIV]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem" id="Mem_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MemDescriptionAll</description>
                    <helpKeyword>configs.mem_memdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_UOPS_RETIRED.ALL]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%MemIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Mem_small") >0.30 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/RetiredPipelineSlots_small") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.30 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Loads" id="Loads_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%LoadsDescriptionAll</description>
                    <helpKeyword>configs.loads_loadsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_UOPS_RETIRED.ALL_LOADS]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%LoadsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Loads_small") >0.30 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Mem_small") >0.30 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/RetiredPipelineSlots_small") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.30 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL_LOADS]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Stores" id="Stores_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%StoresDescriptionAll</description>
                    <helpKeyword>configs.stores_storesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_UOPS_RETIRED.ALL_STORES]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%StoresIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Stores_small") >0.30 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Mem_small") >0.30 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/RetiredPipelineSlots_small") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.30 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL_STORES]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FrontendBoundPipelineSlots" id="FrontendBoundPipelineSlots_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FrontendBoundPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.frontendboundpipelineslots_frontendboundpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/TOPDOWN_FE_ALIAS_small") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%FrontendBoundPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%IFetch_Latency" id="IFetch_Latency_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%IFetch_LatencyDescriptionAll</description>
                    <helpKeyword>configs.ifetch_latency_ifetch_latencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_LATENCY]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%IFetch_LatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/IFetch_Latency_small") >0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_LATENCY]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ICacheMisses" id="ICacheMisses_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%ICacheMissesDescriptionAll</description>
                    <helpKeyword>configs.icachemisses_icachemissesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.ICACHE]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%ICacheMissesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/ICacheMisses_small") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/IFetch_Latency_small") >0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ICACHE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ITLBOverhead" id="ITLBOverhead_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%ITLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.itlboverhead_itlboverheaddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.ITLB_MISS]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%ITLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/ITLBOverhead_small") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/IFetch_Latency_small") >0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ITLB_MISS]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BACLEARS" id="BACLEARS_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BACLEARSDescriptionAll</description>
                    <helpKeyword>configs.baclears_baclearsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_DETECT]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%BACLEARSIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/BACLEARS_small") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/IFetch_Latency_small") >0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_DETECT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchResteers" id="BranchResteers_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BranchResteersDescriptionAll</description>
                    <helpKeyword>configs.branchresteers_branchresteersdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_RESTEER]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%BranchResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/BranchResteers_small") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/IFetch_Latency_small") >0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_RESTEER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%IFetch_Bandwidth" id="IFetch_Bandwidth_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%IFetch_BandwidthDescriptionAll</description>
                    <helpKeyword>configs.ifetch_bandwidth_ifetch_bandwidthdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/FrontendBoundPipelineSlots_small") - query("/IFetch_Latency_small") ) if ( query("/FrontendBoundPipelineSlots_small") - query("/IFetch_Latency_small") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%IFetch_BandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/IFetch_Bandwidth_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_LATENCY]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/FrontendBoundPipelineSlots_small") - query("/IFetch_Latency_small") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthCisc" id="FEBandwidthCisc_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthCiscDescriptionAll</description>
                    <helpKeyword>configs.febandwidthcisc_febandwidthciscdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.CISC]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%FEBandwidthCiscIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FEBandwidthCisc_small") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/IFetch_Bandwidth_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.CISC]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthDecode" id="FEBandwidthDecode_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthDecodeDescriptionAll</description>
                    <helpKeyword>configs.febandwidthdecode_febandwidthdecodedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.DECODE]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%FEBandwidthDecodeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FEBandwidthDecode_small") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/IFetch_Bandwidth_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.DECODE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%PreDecodeWrong" id="PreDecodeWrong_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%PreDecodeWrongDescriptionAll</description>
                    <helpKeyword>configs.predecodewrong_predecodewrongdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.PREDECODE]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%PreDecodeWrongIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/PreDecodeWrong_small") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/IFetch_Bandwidth_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.PREDECODE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEOther" id="FEOther_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEOtherDescriptionAll</description>
                    <helpKeyword>configs.feother_feotherdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.OTHER]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%FEOtherIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FEOther_small") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/IFetch_Bandwidth_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots_small") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.OTHER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CancelledPipelineSlots" id="CancelledPipelineSlots_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%CancelledPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.cancelledpipelineslots_cancelledpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/TOPDOWN_BAD_SPECULATION_ALIAS_small") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%CancelledPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/CancelledPipelineSlots_small") >0.15 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchMispredict" id="BranchMispredict_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BranchMispredictDescriptionAll</description>
                    <helpKeyword>configs.branchmispredict_branchmispredictdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MISPREDICT]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%BranchMispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/BranchMispredict_small") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/CancelledPipelineSlots_small") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MISPREDICT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LSD_Mispredict" id="LSD_Mispredict_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%LSD_MispredictDescriptionAll</description>
                    <helpKeyword>configs.lsd_mispredict_lsd_mispredictdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.LSD_MISPREDICT]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%LSD_MispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/LSD_Mispredict_small") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/BranchMispredict_small") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/CancelledPipelineSlots_small") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.LSD_MISPREDICT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClearsNuke" id="MachineClears_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MachineClearsNukeDescriptionAll</description>
                    <helpKeyword>configs.machineclears_machineclearsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/CancelledPipelineSlots_small") - query("/BranchMispredict_small") ) if ( query("/CancelledPipelineSlots_small") - query("/BranchMispredict_small") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%MachineClearsNukeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MachineClears_small") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/CancelledPipelineSlots_small") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MISPREDICT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots_small") - query("/BranchMispredict_small") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Ucode_Assist" id="Ucode_Assist_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Ucode_AssistDescriptionAll</description>
                    <helpKeyword>configs.ucode_assist_ucode_assistdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%Ucode_AssistIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Ucode_Assist_small") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MachineClears_small") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/CancelledPipelineSlots_small") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Machine_Restart" id="Machine_Restart_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Machine_RestartDescriptionAll</description>
                    <helpKeyword>configs.machine_restart_machine_restartdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.FASTNUKE]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%Machine_RestartIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Machine_Restart_small") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MachineClears_small") >0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/CancelledPipelineSlots_small") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.FASTNUKE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBound" id="BackendBound_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BackendBoundDescriptionAll</description>
                    <helpKeyword>configs.backendbound_backendbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/TOPDOWN_BE_BOUND_ALIAS_small") / query("/SLOTS_small") ) ]]></valueEval>
                    <issueText>%BackendBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/BackendBound_small") >0.10 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Sub_Sys_Bound" id="Mem_Sub_Sys_Bound_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Mem_Sub_Sys_BoundDescriptionAll</description>
                    <helpKeyword>configs.mem_sub_sys_bound_mem_sub_sys_bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") / query("/DerivedClockticks_small") < query("/BackendBound_small") ? query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") / query("/DerivedClockticks_small") : query("/BackendBound_small") ) ) ]]></valueEval>
                    <issueText>%Mem_Sub_Sys_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Mem_Sub_Sys_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L2Bound" id="L2Bound_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L2BoundDescriptionAll</description>
                    <helpKeyword>configs.l2bound_l2bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_Sub_Sys_Bound_small") * query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) ]]></valueEval>
                    <issueText>%L2BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L2Bound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Mem_Sub_Sys_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L2Miss" id="L2Miss_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L2MissDescriptionAll</description>
                    <helpKeyword>configs.l2miss_l2missdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_Sub_Sys_Bound_small") * query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_MISS]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) ]]></valueEval>
                    <issueText>%L2MissIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L2Miss_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Mem_Sub_Sys_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_MISS]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Bound" id="L3Bound_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L3BoundDescriptionAll</description>
                    <helpKeyword>configs.l3bound_l3bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/L3_Hit_Bound_small") + query("/FWD_Bound_small") ) ]]></valueEval>
                    <issueText>%L3BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L3Bound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/L2Miss_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Mem_Sub_Sys_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS_OTHERMOD]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L3_Hit_Bound" id="L3_Hit_Bound_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L3_Hit_BoundDescriptionAll</description>
                    <helpKeyword>configs.l3_hit_bound_l3_hit_bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_Sub_Sys_Bound_small") * query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) ]]></valueEval>
                    <issueText>%L3_Hit_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L3_Hit_Bound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/L3Bound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/L2Miss_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Mem_Sub_Sys_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FWD_Bound" id="FWD_Bound_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%FWD_BoundDescriptionAll</description>
                    <helpKeyword>configs.fwd_bound_fwd_bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_Sub_Sys_Bound_small") * query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS_OTHERMOD]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) ]]></valueEval>
                    <issueText>%FWD_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FWD_Bound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/L3Bound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/L2Miss_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Mem_Sub_Sys_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS_OTHERMOD]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MemBound" id="MemBound_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%MemBoundDescriptionAll</description>
                    <helpKeyword>configs.membound_membounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_Sub_Sys_Bound_small") * ( query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[E-Core]") - query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS_OTHERMOD]/PMUCoreType[E-Core]") ) / query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) ]]></valueEval>
                    <issueText>%MemBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MemBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/L2Miss_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Mem_Sub_Sys_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS_OTHERMOD]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CoreBound" id="CoreBound_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%CoreBoundDescriptionAll</description>
                    <helpKeyword>configs.corebound_corebounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) if ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%CoreBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Serializing_Operation" id="Serializing_Operation_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Serializing_OperationDescriptionAll</description>
                    <helpKeyword>configs.serializing_operation_serializing_operationdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") / query("/SLOTS_small") < query("/CoreBound_small") ? query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") / query("/SLOTS_small") : query("/CoreBound_small") ) ) ]]></valueEval>
                    <issueText>%Serializing_OperationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Serializing_Operation_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Pause" id="Pause_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%PauseDescriptionAll</description>
                    <helpKeyword>configs.pause_pausedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Serializing_Operation_small") * query("/PMUEventCount/PMUEventType[SERIALIZATION.NON_C01_MS_SCB]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) ]]></valueEval>
                    <issueText>%PauseIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Pause_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Serializing_Operation_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[SERIALIZATION.NON_C01_MS_SCB]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Tpause" id="Tpause_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%TpauseDescriptionAll</description>
                    <helpKeyword>configs.tpause_tpausedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Serializing_Operation_small") * query("/PMUEventCount/PMUEventType[SERIALIZATION.C01_MS_SCB]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) ]]></valueEval>
                    <issueText>%TpauseIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Tpause_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Serializing_Operation_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[SERIALIZATION.C01_MS_SCB]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Fence" id="Fence_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FenceDescriptionAll</description>
                    <helpKeyword>configs.fence_fencedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Serializing_Operation_small") * query("/PMUEventCount/PMUEventType[SERIALIZATION.IQ_JEU_SCB]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) ]]></valueEval>
                    <issueText>%FenceIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Fence_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Serializing_Operation_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[SERIALIZATION.IQ_JEU_SCB]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L1Bound" id="L1Bound_small">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L1BoundDescriptionAll</description>
                    <helpKeyword>configs.l1bound_l1bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Core_Bound_Nonexec_small") * ( query("/PMUEventCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") * query("/Pipeline_Width_small") / query("/Core_Bound_Nonexec_Slots_small") ) ) ]]></valueEval>
                    <issueText>%L1BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L1Bound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") >= 10 )  ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") >= 10 ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%RB_Bound" id="RB_Bound_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%RB_BoundDescriptionAll</description>
                    <helpKeyword>configs.rb_bound_rb_bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Core_Bound_Nonexec_small") * ( query("/PMUEventCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") * query("/Pipeline_Width_small") / query("/Core_Bound_Nonexec_Slots_small") ) ) ]]></valueEval>
                    <issueText>%RB_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/RB_Bound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") >= 10 )  ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") >= 10 ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="StoresBound_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%StoresBoundDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Core_Bound_Nonexec_small") * ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") * ( query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) / query("/Core_Bound_Nonexec_Slots_small") ) ]]></valueEval>
                    <issueText>%StoresBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/StoresBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") >= 10 ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Execution_Bound" id="Execution_Bound_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Execution_BoundDescriptionAll</description>
                    <helpKeyword>configs.execution_bound_execution_bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/CoreBound_small") - query("/Serializing_Operation_small") - query("/Core_Bound_Nonexec_small") ) ]]></valueEval>
                    <issueText>%Execution_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Execution_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Floating_Point_Bound" id="Floating_Point_Bound_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Floating_Point_BoundDescriptionAll</description>
                    <helpKeyword>configs.floating_point_bound_floating_point_bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Execution_Bound_small") * ( query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") / ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") + query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") ) ) ) ]]></valueEval>
                    <issueText>%Floating_Point_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Floating_Point_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Execution_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Port0" id="FP_Port0_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FP_Port0DescriptionAll</description>
                    <helpKeyword>configs.fp_port0_fp_port0descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Floating_Point_Bound_small") * ( query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P0]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%FP_Port0IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Port0_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Floating_Point_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P0]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Port1" id="FP_Port1_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FP_Port1DescriptionAll</description>
                    <helpKeyword>configs.fp_port1_fp_port1descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Floating_Point_Bound_small") * ( query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P1]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%FP_Port1IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Port1_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Floating_Point_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P1]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Port2" id="FP_Port2_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FP_Port2DescriptionAll</description>
                    <helpKeyword>configs.fp_port2_fp_port2descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Floating_Point_Bound_small") * ( query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P2]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%FP_Port2IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Port2_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Floating_Point_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P2]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Port3" id="FP_Port3_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FP_Port3DescriptionAll</description>
                    <helpKeyword>configs.fp_port3_fp_port3descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Floating_Point_Bound_small") * ( query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P3]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%FP_Port3IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Port3_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Floating_Point_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P3]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_STD" id="FP_STD_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FP_STDDescriptionAll</description>
                    <helpKeyword>configs.fp_std_fp_stddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Floating_Point_Bound_small") * ( query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.STD]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%FP_STDIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_STD_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Floating_Point_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.STD]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Integer_Bound" id="Integer_Bound_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Integer_BoundDescriptionAll</description>
                    <helpKeyword>configs.integer_bound_integer_bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Execution_Bound_small") * ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") / ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") + query("/PMUEventCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") ) ) ) ]]></valueEval>
                    <issueText>%Integer_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Integer_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Execution_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Load_Port" id="Int_Load_Port_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Int_Load_PortDescriptionAll</description>
                    <helpKeyword>configs.int_load_port_int_load_portdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Integer_Bound_small") * ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.LD]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%Int_Load_PortIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_Load_Port_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Integer_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.LD]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_STA_Port" id="Int_STA_Port_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Int_STA_PortDescriptionAll</description>
                    <helpKeyword>configs.int_sta_port_int_sta_portdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Integer_Bound_small") * ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.STA]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%Int_STA_PortIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_STA_Port_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Integer_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.STA]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_STD_JMP_Port" id="Int_STD_JMP_Port_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Int_STD_JMP_PortDescriptionAll</description>
                    <helpKeyword>configs.int_std_jmp_port_int_std_jmp_portdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Integer_Bound_small") * ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.STD_JMP]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%Int_STD_JMP_PortIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_STD_JMP_Port_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Integer_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.STD_JMP]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Port0" id="Int_Port0_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Int_Port0DescriptionAll</description>
                    <helpKeyword>configs.int_port0_int_port0descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Integer_Bound_small") * ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.P0]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%Int_Port0IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_Port0_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Integer_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.P0]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Port1" id="Int_Port1_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Int_Port1DescriptionAll</description>
                    <helpKeyword>configs.int_port1_int_port1descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Integer_Bound_small") * ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.P1]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%Int_Port1IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_Port1_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Integer_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.P1]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Port2" id="Int_Port2_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Int_Port2DescriptionAll</description>
                    <helpKeyword>configs.int_port2_int_port2descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Integer_Bound_small") * ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.P2]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%Int_Port2IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_Port2_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Integer_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.P2]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Port3" id="Int_Port3_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Int_Port3DescriptionAll</description>
                    <helpKeyword>configs.int_port3_int_port3descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Integer_Bound_small") * ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.P3]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%Int_Port3IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_Port3_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Integer_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.P3]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Secondary_Ports" id="Int_Secondary_Ports_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Int_Secondary_PortsDescriptionAll</description>
                    <helpKeyword>configs.int_secondary_ports_int_secondary_portsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Integer_Bound_small") * ( query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.2ND]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <issueText>%Int_Secondary_PortsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Int_Secondary_Ports_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Integer_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/Execution_Bound_small") >0.20 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.2ND]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Allocation_Bound" id="Allocation_Bound_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Allocation_BoundDescriptionAll</description>
                    <helpKeyword>configs.allocation_bound_allocation_bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Core_Bound_Nonexec_small") * ( ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") + query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) / query("/Core_Bound_Nonexec_Slots_small") ) ) ]]></valueEval>
                    <issueText>%Allocation_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/Allocation_Bound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") >= 10 ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") >= 10 ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BEAllocRestriction" id="BEAllocRestriction_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BEAllocRestrictionDescriptionAll</description>
                    <helpKeyword>configs.beallocrestriction_beallocrestrictiondescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Core_Bound_Nonexec_small") * ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") / query("/Core_Bound_Nonexec_Slots_small") ) ) ]]></valueEval>
                    <issueText>%BEAllocRestrictionIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/BEAllocRestriction_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Allocation_Bound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") >= 10 ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") >= 10 ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LSD_Entry" id="LSD_Entry_small">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%LSD_EntryDescriptionAll</description>
                    <helpKeyword>configs.lsd_entry_lsd_entrydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Core_Bound_Nonexec_small") * ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") / query("/Core_Bound_Nonexec_Slots_small") ) ) ]]></valueEval>
                    <issueText>%LSD_EntryIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/LSD_Entry_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/Allocation_Bound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/CoreBound_small") >0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound_small") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") >= 10 ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") >= 10 ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%SLOTS" id="SLOTS_small">
                    <description>%SLOTSDescriptionAll</description>
                    <helpKeyword>configs.slots_slotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Pipeline_Width_small") * query("/DerivedClockticks_small") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Instructions" id="Instructions_small">
                    <description>%InstructionsDescriptionAll</description>
                    <helpKeyword>configs.instructions_instructionsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/DerivedInstructionsRetired_small") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.ANY]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FLOPc" id="FLOPc_small">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%FLOPcDescriptionAll</description>
                    <helpKeyword>configs.flopc_flopcdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FLOP_Count_small") / query("/DerivedClockticks_small") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[FP_FLOPS_RETIRED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%IpFLOP" id="IpFLOP_small">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%IpFLOPDescriptionAll</description>
                    <helpKeyword>configs.ipflop_ipflopdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Instructions_small") / query("/FLOP_Count_small") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.ANY]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_FLOPS_RETIRED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%IpArith" id="IpArith_small">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%IpArithDescriptionAll</description>
                    <helpKeyword>configs.iparith_iparithdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Instructions_small") / query("/PMUEventCount/PMUEventType[FP_INST_RETIRED.ALL]/PMUCoreType[E-Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.ANY]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_INST_RETIRED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%IpArith_Scalar_SP" id="IpArith_Scalar_SP_small">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%IpArith_Scalar_SPDescriptionAll</description>
                    <helpKeyword>configs.iparith_scalar_sp_iparith_scalar_spdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Instructions_small") / query("/PMUEventCount/PMUEventType[FP_INST_RETIRED.32B_SP]/PMUCoreType[E-Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.ANY]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_INST_RETIRED.32B_SP]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%IpArith_Scalar_DP" id="IpArith_Scalar_DP_small">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%IpArith_Scalar_DPDescriptionAll</description>
                    <helpKeyword>configs.iparith_scalar_dp_iparith_scalar_dpdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Instructions_small") / query("/PMUEventCount/PMUEventType[FP_INST_RETIRED.64B_DP]/PMUCoreType[E-Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.ANY]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_INST_RETIRED.64B_DP]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%IpArith_AVX128" id="IpArith_AVX128_small">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%IpArith_AVX128DescriptionAll</description>
                    <helpKeyword>configs.iparith_avx128_iparith_avx128descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Instructions_small") / ( query("/PMUEventCount/PMUEventType[FP_INST_RETIRED.128B_DP]/PMUCoreType[E-Core]") + query("/PMUEventCount/PMUEventType[FP_INST_RETIRED.128B_SP]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.ANY]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[FP_INST_RETIRED.128B_DP]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_INST_RETIRED.128B_SP]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%IpArith_AVX256" id="IpArith_AVX256_small">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%IpArith_AVX256DescriptionAll</description>
                    <helpKeyword>configs.iparith_avx256_iparith_avx256descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Instructions_small") / ( query("/PMUEventCount/PMUEventType[FP_INST_RETIRED.256B_DP]/PMUCoreType[E-Core]") + query("/PMUEventCount/PMUEventType[FP_INST_RETIRED.256B_SP]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.ANY]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[FP_INST_RETIRED.256B_DP]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_INST_RETIRED.256B_SP]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="StoresBound_Info_small">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%StoresBound_InfoDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) * ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") / query("/SLOTS_small") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LoadBound" id="LoadBound_Info_small">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%LoadBound_InfoDescriptionAll</description>
                    <helpKeyword>configs.loadbound_loadbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") + query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) / query("/DerivedClockticks_small") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%GFLOPs" id="GFLOPs_small">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%GFLOPsDescriptionAll</description>
                    <helpKeyword>configs.gflops_gflopsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FLOP_Count_small") / ( query("/Time_small") * 1000000000 ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[FP_FLOPS_RETIRED.ALL]/PMUCoreType[E-Core]") >= 10 )  ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Time" id="Time_small">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%TimeDescriptionAll</description>
                    <helpKeyword>configs.time_timedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/DurationTimeInMilliSeconds_small") / 1000 ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  1000 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Pipeline_Width" id="Pipeline_Width_small">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Pipeline_WidthDescriptionAll</description>
                    <helpKeyword>configs.pipeline_width_pipeline_widthdescriptionall</helpKeyword>
                    <valueEval>8</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%DurationTimeInMilliSeconds" id="DurationTimeInMilliSeconds_small">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%DurationTimeInMilliSecondsDescriptionAll</description>
                    <helpKeyword>configs.durationtimeinmilliseconds_durationtimeinmillisecondsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( (query("/GlobalElapsedTimeQueryAll") * 1000) ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%FLOP_Count" id="FLOP_Count_small">
                    <description>%FLOP_CountDescriptionAll</description>
                    <helpKeyword>configs.flop_count_flop_countdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[FP_FLOPS_RETIRED.ALL]/PMUCoreType[E-Core]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[FP_FLOPS_RETIRED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Core_Bound_Nonexec" id="Core_Bound_Nonexec_small">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Core_Bound_NonexecDescriptionAll</description>
                    <helpKeyword>configs.core_bound_nonexec_core_bound_nonexecdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/CoreBound_small") - query("/Serializing_Operation_small") < query("/Core_Bound_Nonexec_Slots_small") / query("/SLOTS_small") ? query("/CoreBound_small") - query("/Serializing_Operation_small") : query("/Core_Bound_Nonexec_Slots_small") / query("/SLOTS_small") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Core_Bound_Nonexec_Slots" id="Core_Bound_Nonexec_Slots_small">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Core_Bound_Nonexec_SlotsDescriptionAll</description>
                    <helpKeyword>configs.core_bound_nonexec_slots_core_bound_nonexec_slotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") + query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") + ( ( query("/PMUEventCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") + query("/PMUEventCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) * query("/Pipeline_Width_small") ) + ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") * ( query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") / query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") >= 10 ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%TOPDOWN_FE_ALIAS" id="TOPDOWN_FE_ALIAS_small">
                    <description>%TOPDOWN_FE_ALIASDescriptionAll</description>
                    <helpKeyword>configs.topdown_fe_alias_topdown_fe_aliasdescriptionall</helpKeyword>
                    <xsl:choose>
                        <xsl:when test="$isFixedTMASupported">
                            <valueEval>
                                <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) ]]></valueEval>
                        </xsl:when>
                        <xsl:otherwise>
                            <valueEval>
                                <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ]]></valueEval>
                        </xsl:otherwise>
                    </xsl:choose>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%TOPDOWN_BAD_SPECULATION_ALIAS" id="TOPDOWN_BAD_SPECULATION_ALIAS_small">
                    <description>%TOPDOWN_BAD_SPECULATION_ALIASDescriptionAll</description>
                    <helpKeyword>configs.topdown_bad_speculation_alias_topdown_bad_speculation_aliasdescriptionall</helpKeyword>
                    <xsl:choose>
                        <xsl:when test="$isFixedTMASupported">
                            <valueEval>
                                <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ]]></valueEval>
                        </xsl:when>
                        <xsl:otherwise>
                            <valueEval>
                                <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL_P]/PMUCoreType[E-Core]") ) ]]></valueEval>
                        </xsl:otherwise>
                    </xsl:choose>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%TOPDOWN_BE_BOUND_ALIAS" id="TOPDOWN_BE_BOUND_ALIAS_small">
                    <description>%TOPDOWN_BE_BOUND_ALIASDescriptionAll</description>
                    <helpKeyword>configs.topdown_be_bound_alias_topdown_be_bound_aliasdescriptionall</helpKeyword>
                    <xsl:choose>
                        <xsl:when test="$isFixedTMASupported">
                            <valueEval>
                                <![CDATA[ ( query("/SLOTS_small") - ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") + query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") + query("/PMUEventCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ]]></valueEval>
                        </xsl:when>
                        <xsl:otherwise>
                            <valueEval>
                                <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ]]></valueEval>
                        </xsl:otherwise>
                    </xsl:choose>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%TOPDOWN_RETIRING_ALIAS" id="TOPDOWN_RETIRING_ALIAS_small">
                    <description>%TOPDOWN_RETIRING_ALIASDescriptionAll</description>
                    <helpKeyword>configs.topdown_retiring_alias_topdown_retiring_aliasdescriptionall</helpKeyword>
                    <xsl:choose>
                        <xsl:when test="$isFixedTMASupported">
                            <valueEval>
                                <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ]]></valueEval>
                        </xsl:when>
                        <xsl:otherwise>
                            <valueEval>
                                <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_RETIRING.ALL_P]/PMUCoreType[E-Core]") ) ]]></valueEval>
                        </xsl:otherwise>
                    </xsl:choose>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
            </queryLibrary>
            <vectorQuery id="locatorGETopDown_small" xmlns:blob="http://www.intel.com/2009/BagSchema#blob" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:byte="http://www.w3.org/2001/XMLSchema#byte" xmlns:double="http://www.w3.org/2001/XMLSchema#double" xmlns:float="http://www.w3.org/2001/XMLSchema#float" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:long="http://www.w3.org/2001/XMLSchema#long" xmlns:null="http://www.intel.com/2009/BagSchema#null" xmlns:short="http://www.w3.org/2001/XMLSchema#short" xmlns:unsignedByte="http://www.w3.org/2001/XMLSchema#unsignedByte" xmlns:unsignedInt="http://www.w3.org/2001/XMLSchema#unsignedInt" xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong" xmlns:unsignedShort="http://www.w3.org/2001/XMLSchema#unsignedShort">
                <derivedQuery displayName="Locators" id="LocatorsGridSection">
                    <valueEval>0</valueEval>
                    <valueType>double</valueType>
                    <displayAttributes>
                        <boolean:expand>true</boolean:expand>
                        <boolean:allowCollapse>false</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="LocatorsGridGroup">
                            <derivedQuery id="locatorRetiredPipelineSlotsGroup">
                                <queryInherit>/locatorRetiredPipelineSlots_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorRetiredPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorArithGroup">
                                            <queryInherit>/locatorArith_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorArithGroupExpanded">
                                                    <queryRef>/locatorNon-Div_small</queryRef>
                                                    <queryRef>/locatorFPDIV_small</queryRef>
                                                    <queryRef>/locatorIDIV_small</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorMemGroup">
                                            <queryInherit>/locatorMem_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorMemGroupExpanded">
                                                    <queryRef>/locatorLoads_small</queryRef>
                                                    <queryRef>/locatorStores_small</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorFrontendBoundPipelineSlotsGroup">
                                <queryInherit>/locatorFrontendBoundPipelineSlots_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorFrontendBoundPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorIFetch_LatencyGroup">
                                            <queryInherit>/locatorIFetch_Latency_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorIFetch_LatencyGroupExpanded">
                                                    <queryRef>/locatorICacheMisses_small</queryRef>
                                                    <queryRef>/locatorITLBOverhead_small</queryRef>
                                                    <queryRef>/locatorBACLEARS_small</queryRef>
                                                    <queryRef>/locatorBranchResteers_small</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorIFetch_BandwidthGroup">
                                            <queryInherit>/locatorIFetch_Bandwidth_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorIFetch_BandwidthGroupExpanded">
                                                    <queryRef>/locatorFEBandwidthCisc_small</queryRef>
                                                    <queryRef>/locatorFEBandwidthDecode_small</queryRef>
                                                    <queryRef>/locatorPreDecodeWrong_small</queryRef>
                                                    <queryRef>/locatorFEOther_small</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorCancelledPipelineSlotsGroup">
                                <queryInherit>/locatorCancelledPipelineSlots_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorCancelledPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorBranchMispredictGroup">
                                            <queryInherit>/locatorBranchMispredict_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorBranchMispredictGroupExpanded">
                                                    <queryRef>/locatorLSD_Mispredict_small</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorMachineClearsGroup">
                                            <queryInherit>/locatorMachineClears_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorMachineClearsGroupExpanded">
                                                    <queryRef>/locatorUcode_Assist_small</queryRef>
                                                    <queryRef>/locatorMachine_Restart_small</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorBackendBoundGroup">
                                <queryInherit>/locatorBackendBound_small</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorBackendBoundGroupExpanded">
                                        <derivedQuery id="locatorMem_Sub_Sys_BoundGroup">
                                            <queryInherit>/locatorMem_Sub_Sys_Bound_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorMem_Sub_Sys_BoundGroupExpanded">
                                                    <queryRef>/locatorL2Bound_small</queryRef>
                                                    <derivedQuery id="locatorL2MissGroup">
                                                        <queryInherit>/locatorL2Miss_small</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorL2MissGroupExpanded">
                                                                <derivedQuery id="locatorL3BoundGroup">
                                                                    <queryInherit>/locatorL3Bound_small</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorL3BoundGroupExpanded">
                                                                            <queryRef>/locatorL3_Hit_Bound_small</queryRef>
                                                                            <queryRef>/locatorFWD_Bound_small</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                                <queryRef>/locatorMemBound_small</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorCoreBoundGroup">
                                            <queryInherit>/locatorCoreBound_small</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorCoreBoundGroupExpanded">
                                                    <derivedQuery id="locatorSerializing_OperationGroup">
                                                        <queryInherit>/locatorSerializing_Operation_small</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorSerializing_OperationGroupExpanded">
                                                                <queryRef>/locatorPause_small</queryRef>
                                                                <queryRef>/locatorTpause_small</queryRef>
                                                                <queryRef>/locatorFence_small</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorL1Bound_small</queryRef>
                                                    <queryRef>/locatorRB_Bound_small</queryRef>
                                                    <queryRef>/locatorStoresBound_small</queryRef>
                                                    <derivedQuery id="locatorExecution_BoundGroup">
                                                        <queryInherit>/locatorExecution_Bound_small</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorExecution_BoundGroupExpanded">
                                                                <derivedQuery id="locatorFloating_Point_BoundGroup">
                                                                    <queryInherit>/locatorFloating_Point_Bound_small</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorFloating_Point_BoundGroupExpanded">
                                                                            <queryRef>/locatorFP_Port0_small</queryRef>
                                                                            <queryRef>/locatorFP_Port1_small</queryRef>
                                                                            <queryRef>/locatorFP_Port2_small</queryRef>
                                                                            <queryRef>/locatorFP_Port3_small</queryRef>
                                                                            <queryRef>/locatorFP_STD_small</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                                <derivedQuery id="locatorInteger_BoundGroup">
                                                                    <queryInherit>/locatorInteger_Bound_small</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorInteger_BoundGroupExpanded">
                                                                            <queryRef>/locatorInt_Load_Port_small</queryRef>
                                                                            <queryRef>/locatorInt_STA_Port_small</queryRef>
                                                                            <queryRef>/locatorInt_STD_JMP_Port_small</queryRef>
                                                                            <queryRef>/locatorInt_Port0_small</queryRef>
                                                                            <queryRef>/locatorInt_Port1_small</queryRef>
                                                                            <queryRef>/locatorInt_Port2_small</queryRef>
                                                                            <queryRef>/locatorInt_Port3_small</queryRef>
                                                                            <queryRef>/locatorInt_Secondary_Ports_small</queryRef>
                                                                        </vectorQuery>
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <derivedQuery id="locatorAllocation_BoundGroup">
                                                        <queryInherit>/locatorAllocation_Bound_small</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorAllocation_BoundGroupExpanded">
                                                                <queryRef>/locatorBEAllocRestriction_small</queryRef>
                                                                <queryRef>/locatorLSD_Entry_small</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
            </vectorQuery>
            <locatorqueryLibrary>
                <derivedQuery displayName="%RetiredPipelineSlots" id="locatorRetiredPipelineSlots_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%RetiredPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/RetiredPipelineSlots_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%RetiredPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorRetiredPipelineSlots") >0.75 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Arith" id="locatorArith_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ArithDescriptionAll</description>
                    <helpKeyword>configs.arith_arithdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_small") - query("/Mem_small") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Arith_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%ArithIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorArith") >0.60 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Non-Div" id="locatorNon-Div_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Non-DivDescriptionAll</description>
                    <helpKeyword>configs.non_div_non_divdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/RetiredPipelineSlots_small") - query("/Mem_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.IDIV]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Non-Div_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%Non-DivIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorNon-Div") >0.60 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FPDIV" id="locatorFPDIV_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FPDIVDescriptionAll</description>
                    <helpKeyword>configs.fpdiv_fpdivdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FPDIV_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%FPDIVIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFPDIV") >0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%IDIV" id="locatorIDIV_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%IDIVDescriptionAll</description>
                    <helpKeyword>configs.idiv_idivdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.IDIV]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/IDIV_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%IDIVIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorIDIV") >0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem" id="locatorMem_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MemDescriptionAll</description>
                    <helpKeyword>configs.mem_memdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Mem_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%MemIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMem") >0.30 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Loads" id="locatorLoads_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LoadsDescriptionAll</description>
                    <helpKeyword>configs.loads_loadsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL_LOADS]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Loads_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%LoadsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLoads") >0.30 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Stores" id="locatorStores_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%StoresDescriptionAll</description>
                    <helpKeyword>configs.stores_storesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL_STORES]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Stores_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%StoresIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStores") >0.30 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FrontendBoundPipelineSlots" id="locatorFrontendBoundPipelineSlots_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FrontendBoundPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.frontendboundpipelineslots_frontendboundpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FrontendBoundPipelineSlots_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%FrontendBoundPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFrontendBoundPipelineSlots") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%IFetch_Latency" id="locatorIFetch_Latency_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%IFetch_LatencyDescriptionAll</description>
                    <helpKeyword>configs.ifetch_latency_ifetch_latencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_LATENCY]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/IFetch_Latency_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%IFetch_LatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorIFetch_Latency") >0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ICacheMisses" id="locatorICacheMisses_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ICacheMissesDescriptionAll</description>
                    <helpKeyword>configs.icachemisses_icachemissesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ICACHE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/ICacheMisses_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%ICacheMissesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorICacheMisses") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ITLBOverhead" id="locatorITLBOverhead_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ITLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.itlboverhead_itlboverheaddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ITLB_MISS]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/ITLBOverhead_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%ITLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorITLBOverhead") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BACLEARS" id="locatorBACLEARS_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BACLEARSDescriptionAll</description>
                    <helpKeyword>configs.baclears_baclearsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_DETECT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BACLEARS_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%BACLEARSIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBACLEARS") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchResteers" id="locatorBranchResteers_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BranchResteersDescriptionAll</description>
                    <helpKeyword>configs.branchresteers_branchresteersdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_RESTEER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BranchResteers_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%BranchResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBranchResteers") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%IFetch_Bandwidth" id="locatorIFetch_Bandwidth_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%IFetch_BandwidthDescriptionAll</description>
                    <helpKeyword>configs.ifetch_bandwidth_ifetch_bandwidthdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_LATENCY]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/FrontendBoundPipelineSlots_small") - query("/IFetch_Latency_small") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/IFetch_Bandwidth_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%IFetch_BandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorIFetch_Bandwidth") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthCisc" id="locatorFEBandwidthCisc_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthCiscDescriptionAll</description>
                    <helpKeyword>configs.febandwidthcisc_febandwidthciscdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.CISC]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEBandwidthCisc_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthCiscIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidthCisc") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthDecode" id="locatorFEBandwidthDecode_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthDecodeDescriptionAll</description>
                    <helpKeyword>configs.febandwidthdecode_febandwidthdecodedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.DECODE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEBandwidthDecode_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthDecodeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidthDecode") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%PreDecodeWrong" id="locatorPreDecodeWrong_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%PreDecodeWrongDescriptionAll</description>
                    <helpKeyword>configs.predecodewrong_predecodewrongdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.PREDECODE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PreDecodeWrong_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%PreDecodeWrongIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPreDecodeWrong") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEOther" id="locatorFEOther_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEOtherDescriptionAll</description>
                    <helpKeyword>configs.feother_feotherdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.OTHER]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEOther_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%FEOtherIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEOther") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%CancelledPipelineSlots" id="locatorCancelledPipelineSlots_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CancelledPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.cancelledpipelineslots_cancelledpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/CancelledPipelineSlots_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%CancelledPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCancelledPipelineSlots") >0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchMispredict" id="locatorBranchMispredict_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BranchMispredictDescriptionAll</description>
                    <helpKeyword>configs.branchmispredict_branchmispredictdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MISPREDICT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BranchMispredict_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%BranchMispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBranchMispredict") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%LSD_Mispredict" id="locatorLSD_Mispredict_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LSD_MispredictDescriptionAll</description>
                    <helpKeyword>configs.lsd_mispredict_lsd_mispredictdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.LSD_MISPREDICT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/LSD_Mispredict_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%LSD_MispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLSD_Mispredict") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClearsNuke" id="locatorMachineClears_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MachineClearsNukeDescriptionAll</description>
                    <helpKeyword>configs.machineclears_machineclearsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MISPREDICT]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) if ( ( ( query("/CancelledPipelineSlots_small") - query("/BranchMispredict_small") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MachineClears_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%MachineClearsNukeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMachineClears") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Ucode_Assist" id="locatorUcode_Assist_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Ucode_AssistDescriptionAll</description>
                    <helpKeyword>configs.ucode_assist_ucode_assistdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Ucode_Assist_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%Ucode_AssistIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorUcode_Assist") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Machine_Restart" id="locatorMachine_Restart_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Machine_RestartDescriptionAll</description>
                    <helpKeyword>configs.machine_restart_machine_restartdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.FASTNUKE]/PMUCoreType[E-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Machine_Restart_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%Machine_RestartIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMachine_Restart") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBound" id="locatorBackendBound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BackendBoundDescriptionAll</description>
                    <helpKeyword>configs.backendbound_backendbounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BackendBound_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%BackendBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBackendBound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_Sub_Sys_Bound" id="locatorMem_Sub_Sys_Bound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mem_Sub_Sys_BoundDescriptionAll</description>
                    <helpKeyword>configs.mem_sub_sys_bound_mem_sub_sys_bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Mem_Sub_Sys_Bound_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%Mem_Sub_Sys_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMem_Sub_Sys_Bound") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L2Bound" id="locatorL2Bound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L2BoundDescriptionAll</description>
                    <helpKeyword>configs.l2bound_l2bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/L2Bound_small") ) ]]></valueEval>
                    <issueText>%L2BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL2Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L2Miss" id="locatorL2Miss_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L2MissDescriptionAll</description>
                    <helpKeyword>configs.l2miss_l2missdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_MISS]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/L2Miss_small") ) ]]></valueEval>
                    <issueText>%L2MissIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL2Miss") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Bound" id="locatorL3Bound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L3BoundDescriptionAll</description>
                    <helpKeyword>configs.l3bound_l3bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS_OTHERMOD]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/L3Bound_small") ) ]]></valueEval>
                    <issueText>%L3BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL3Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L3_Hit_Bound" id="locatorL3_Hit_Bound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L3_Hit_BoundDescriptionAll</description>
                    <helpKeyword>configs.l3_hit_bound_l3_hit_bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/L3_Hit_Bound_small") ) ]]></valueEval>
                    <issueText>%L3_Hit_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL3_Hit_Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FWD_Bound" id="locatorFWD_Bound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FWD_BoundDescriptionAll</description>
                    <helpKeyword>configs.fwd_bound_fwd_bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS_OTHERMOD]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/FWD_Bound_small") ) ]]></valueEval>
                    <issueText>%FWD_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFWD_Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MemBound" id="locatorMemBound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MemBoundDescriptionAll</description>
                    <helpKeyword>configs.membound_membounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS_OTHERMOD]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/MemBound_small") ) ]]></valueEval>
                    <issueText>%MemBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMemBound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%CoreBound" id="locatorCoreBound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CoreBoundDescriptionAll</description>
                    <helpKeyword>configs.corebound_corebounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/CoreBound_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%CoreBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCoreBound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Serializing_Operation" id="locatorSerializing_Operation_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Serializing_OperationDescriptionAll</description>
                    <helpKeyword>configs.serializing_operation_serializing_operationdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Serializing_Operation_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%Serializing_OperationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSerializing_Operation") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Pause" id="locatorPause_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%PauseDescriptionAll</description>
                    <helpKeyword>configs.pause_pausedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[SERIALIZATION.NON_C01_MS_SCB]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Pause_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%PauseIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPause") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Tpause" id="locatorTpause_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%TpauseDescriptionAll</description>
                    <helpKeyword>configs.tpause_tpausedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[SERIALIZATION.C01_MS_SCB]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Tpause_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%TpauseIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorTpause") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Fence" id="locatorFence_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FenceDescriptionAll</description>
                    <helpKeyword>configs.fence_fencedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[SERIALIZATION.IQ_JEU_SCB]/PMUCoreType[E-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Fence_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%FenceIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFence") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L1Bound" id="locatorL1Bound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L1BoundDescriptionAll</description>
                    <helpKeyword>configs.l1bound_l1bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") >= 10 )  ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") >= 10 ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/L1Bound_small") ) ]]></valueEval>
                    <issueText>%L1BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL1Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%RB_Bound" id="locatorRB_Bound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%RB_BoundDescriptionAll</description>
                    <helpKeyword>configs.rb_bound_rb_bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") >= 10 )  ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") >= 10 ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/RB_Bound_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%RB_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorRB_Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="locatorStoresBound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%StoresBoundDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") >= 10 ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") >= 10 ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/StoresBound_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%StoresBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStoresBound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Execution_Bound" id="locatorExecution_Bound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Execution_BoundDescriptionAll</description>
                    <helpKeyword>configs.execution_bound_execution_bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Execution_Bound_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%Execution_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorExecution_Bound") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Floating_Point_Bound" id="locatorFloating_Point_Bound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Floating_Point_BoundDescriptionAll</description>
                    <helpKeyword>configs.floating_point_bound_floating_point_bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Floating_Point_Bound_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%Floating_Point_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFloating_Point_Bound") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Port0" id="locatorFP_Port0_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_Port0DescriptionAll</description>
                    <helpKeyword>configs.fp_port0_fp_port0descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P0]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Port0_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%FP_Port0IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Port0") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Port1" id="locatorFP_Port1_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_Port1DescriptionAll</description>
                    <helpKeyword>configs.fp_port1_fp_port1descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P1]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Port1_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%FP_Port1IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Port1") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Port2" id="locatorFP_Port2_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_Port2DescriptionAll</description>
                    <helpKeyword>configs.fp_port2_fp_port2descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P2]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Port2_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%FP_Port2IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Port2") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Port3" id="locatorFP_Port3_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_Port3DescriptionAll</description>
                    <helpKeyword>configs.fp_port3_fp_port3descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.P3]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Port3_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%FP_Port3IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Port3") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_STD" id="locatorFP_STD_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_STDDescriptionAll</description>
                    <helpKeyword>configs.fp_std_fp_stddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.STD]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_STD_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%FP_STDIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_STD") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Integer_Bound" id="locatorInteger_Bound_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Integer_BoundDescriptionAll</description>
                    <helpKeyword>configs.integer_bound_integer_bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Integer_Bound_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%Integer_BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorInteger_Bound") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Load_Port" id="locatorInt_Load_Port_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Int_Load_PortDescriptionAll</description>
                    <helpKeyword>configs.int_load_port_int_load_portdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.LD]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Int_Load_Port_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%Int_Load_PortIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorInt_Load_Port") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_STA_Port" id="locatorInt_STA_Port_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Int_STA_PortDescriptionAll</description>
                    <helpKeyword>configs.int_sta_port_int_sta_portdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.STA]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Int_STA_Port_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%Int_STA_PortIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorInt_STA_Port") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_STD_JMP_Port" id="locatorInt_STD_JMP_Port_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Int_STD_JMP_PortDescriptionAll</description>
                    <helpKeyword>configs.int_std_jmp_port_int_std_jmp_portdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.STD_JMP]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Int_STD_JMP_Port_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%Int_STD_JMP_PortIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorInt_STD_JMP_Port") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Port0" id="locatorInt_Port0_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Int_Port0DescriptionAll</description>
                    <helpKeyword>configs.int_port0_int_port0descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) >= 10 if ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) < ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.LSD]/PMUCoreType[E-Core]") ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.WCB_FULL]/PMUCoreType[E-Core]") ) )  ) ) || ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[E-Core]") ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[E-Core]") ) ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_VINT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.P0]/PMUCoreType[E-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[INT_UOPS_EXECUTED.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Int_Port0_small") * query("/SLOTS_small")) / queryAll("/SLOTS_small", true) ) ]]></valueEval>
                    <issueText>%Int_Port0IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorInt_Port0") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Int_Port1" id="locatorInt_Port1_small">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Int_Port1DescriptionAll</description>
                    <helpKeyword>configs.int_port1_int_port1descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") >= 10 ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) >= 10 ) ) || ( ( ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[E-Core]") ) && ( query("/ClocktickSamples") >= 10 ) ) < ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) >= 10 ) ) ) if ( ( ( query("/BackendBound_small") - query("/Mem_Sub_Sys_Bound_small") ) > 0 ) ) else ( 0 ) ) else ( ( ( ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) >= 10 if ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[E-Core]") ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[E-Core]") ) ) < ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) else ( ( ( ( ( query("/ClocktickSamples") >= 10 ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[E-Core]") ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[E-Core]") ) ) || ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[E-Core]") ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL_P]/PMUCoreType[E-Core]") ) ) ) && ( query("/Clockt