/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.util.containers.ContainerUtil;
import com.theoryinpractice.testng.TestngBundle;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.annotations.DataProvider;

public class DataProviderReturnTypeInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(DataProviderReturnTypeInspection.class);

    public ProblemDescriptor @Nullable [] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiType returnType;
        String dataProviderFqn;
        PsiAnnotation annotation;
        if (method == null) {
            DataProviderReturnTypeInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DataProviderReturnTypeInspection.$$$reportNull$$$0(1);
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{dataProviderFqn = DataProvider.class.getName()})) != null && (returnType = method.getReturnType()) != null && !DataProviderReturnTypeInspection.isSuitableReturnType(returnType, annotation)) {
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            LOG.assertTrue(returnTypeElement != null);
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)annotation);
            if (module == null) {
                return null;
            }
            boolean supportOneDimensional = DataProviderReturnTypeInspection.supportOneDimensional(module);
            String message = supportOneDimensional ? TestngBundle.message("inspection.data.provider.return.type.check", new Object[0]) : TestngBundle.message("inspection.data.provider.return.type.multi.check", new Object[0]);
            return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)returnTypeElement, message, isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
        }
        return null;
    }

    private static boolean isSuitableReturnType(@NotNull PsiType type, @NotNull PsiAnnotation annotation) {
        if (type == null) {
            DataProviderReturnTypeInspection.$$$reportNull$$$0(2);
        }
        if (annotation == null) {
            DataProviderReturnTypeInspection.$$$reportNull$$$0(3);
        }
        if (type instanceof PsiArrayType) {
            return DataProviderReturnTypeInspection.isSuitableInnerType(((PsiArrayType)type).getComponentType(), annotation);
        }
        if (type instanceof PsiClassType) {
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type).resolveGenerics();
            PsiClass resolvedClass = resolveResult.getElement();
            if (resolvedClass == null || !"java.util.Iterator".equals(resolvedClass.getQualifiedName())) {
                return false;
            }
            Map substitutionMap = resolveResult.getSubstitutor().getSubstitutionMap();
            if (substitutionMap.size() != 1) {
                return false;
            }
            PsiType genericType = (PsiType)ContainerUtil.getFirstItem(substitutionMap.values());
            if (genericType == null) {
                return false;
            }
            return DataProviderReturnTypeInspection.isSuitableInnerType(genericType, annotation);
        }
        return false;
    }

    private static boolean isSuitableInnerType(@NotNull PsiType type, @NotNull PsiAnnotation annotation) {
        if (type == null) {
            DataProviderReturnTypeInspection.$$$reportNull$$$0(4);
        }
        if (annotation == null) {
            DataProviderReturnTypeInspection.$$$reportNull$$$0(5);
        }
        if (!(type instanceof PsiArrayType)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)annotation);
            if (module == null) {
                return false;
            }
            return DataProviderReturnTypeInspection.supportOneDimensional(module);
        }
        PsiType componentType = type.getDeepComponentType();
        if (!(componentType instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolvedClass = ((PsiClassType)componentType).resolve();
        return resolvedClass != null;
    }

    private static boolean supportOneDimensional(@NotNull Module module) {
        if (module == null) {
            DataProviderReturnTypeInspection.$$$reportNull$$$0(6);
        }
        return TestNGUtil.isVersionOrGreaterThan(module.getProject(), module, 6, 10, 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/theoryinpractice/testng/inspection/DataProviderReturnTypeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuitableReturnType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuitableInnerType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "supportOneDimensional";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

