/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.utils.GrInspectionUIUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&J\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/GroovyLocalInspectionTool;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "explicitlyEnabledFileTypes", "", "", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "buildGroovyVisitor", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "getOptionController", "Lcom/intellij/codeInspection/options/OptionController;", "getGroovyOptionsPane", "intellij.groovy.psi"})
public abstract class GroovyLocalInspectionTool
extends LocalInspectionTool {
    @JvmField
    @NotNull
    public Set<String> explicitlyEnabledFileTypes = new HashSet();

    @NotNull
    public final PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        GroovyElementVisitor groovyElementVisitor = this.buildGroovyVisitor(holder, isOnTheFly);
        return new GroovyPsiElementVisitor(this, groovyElementVisitor){
            final /* synthetic */ GroovyLocalInspectionTool this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (GrInspectionUIUtil.checkInspectionEnabledByFileType(this.this$0, element, this.this$0.explicitlyEnabledFileTypes)) {
                    super.visitElement(element);
                    return;
                }
            }
        };
    }

    @NotNull
    public abstract GroovyElementVisitor buildGroovyVisitor(@NotNull ProblemsHolder var1, boolean var2);

    @NotNull
    public final OptPane getOptionsPane() {
        OptPane pane = this.getGroovyOptionsPane();
        return GrInspectionUIUtil.enhanceInspectionToolPanel(this, pane);
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onPrefix("fileType", GrInspectionUIUtil.getFileTypeController(this.explicitlyEnabledFileTypes));
        Intrinsics.checkNotNullExpressionValue((Object)optionController, (String)"onPrefix(...)");
        return optionController;
    }

    @NotNull
    public OptPane getGroovyOptionsPane() {
        OptPane optPane = OptPane.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"EMPTY");
        return optPane;
    }
}

