/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IErrorCounterReparseableElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ElementTypeUtils;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.parsing.KotlinParser;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameterList;

public class LambdaExpressionElementType
extends IErrorCounterReparseableElementType {
    public LambdaExpressionElementType() {
        super("LAMBDA_EXPRESSION", (Language)KotlinLanguage.INSTANCE);
    }

    public ASTNode parseContents(ASTNode chameleon) {
        Project project = chameleon.getPsi().getProject();
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, null, (Language)KotlinLanguage.INSTANCE, chameleon.getChars());
        return KotlinParser.parseLambdaExpression(builder).getFirstChildNode();
    }

    public ASTNode createNode(CharSequence text) {
        return new KtLambdaExpression(text);
    }

    public boolean isParsable(@Nullable ASTNode parent, CharSequence buffer, Language fileLanguage, Project project) {
        return super.isParsable(parent, buffer, fileLanguage, project) && !LambdaExpressionElementType.wasArrowMovedOrDeleted(parent, buffer) && !LambdaExpressionElementType.wasParameterCommaMovedOrDeleted(parent, buffer);
    }

    private static boolean wasArrowMovedOrDeleted(@Nullable ASTNode parent, CharSequence buffer) {
        KtLambdaExpression lambdaExpression = LambdaExpressionElementType.findLambdaExpression(parent);
        if (lambdaExpression == null) {
            return false;
        }
        KtFunctionLiteral literal = lambdaExpression.getFunctionLiteral();
        PsiElement arrow = literal.getArrow();
        if (arrow == null) {
            return false;
        }
        int arrowOffset = arrow.getStartOffsetInParent() + literal.getStartOffsetInParent();
        return LambdaExpressionElementType.hasTokenMoved(lambdaExpression.getText(), buffer, arrowOffset, KtTokens.ARROW);
    }

    private static boolean wasParameterCommaMovedOrDeleted(@Nullable ASTNode parent, CharSequence buffer) {
        KtLambdaExpression lambdaExpression = LambdaExpressionElementType.findLambdaExpression(parent);
        if (lambdaExpression == null) {
            return false;
        }
        KtFunctionLiteral literal = lambdaExpression.getFunctionLiteral();
        KtParameterList valueParameterList = literal.getValueParameterList();
        if (valueParameterList == null || valueParameterList.getParameters().size() <= 1) {
            return false;
        }
        PsiElement comma = valueParameterList.getFirstComma();
        if (comma == null) {
            return false;
        }
        int commaOffset = comma.getTextOffset() - lambdaExpression.getTextOffset();
        return LambdaExpressionElementType.hasTokenMoved(lambdaExpression.getText(), buffer, commaOffset, KtTokens.COMMA);
    }

    private static KtLambdaExpression findLambdaExpression(@Nullable ASTNode parent) {
        if (parent == null) {
            return null;
        }
        PsiElement parentPsi = parent.getPsi();
        KtLambdaExpression[] lambdaExpressions = (KtLambdaExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)parentPsi, KtLambdaExpression.class);
        if (lambdaExpressions == null || lambdaExpressions.length != 1) {
            return null;
        }
        return lambdaExpressions[0];
    }

    private static boolean hasTokenMoved(String oldText, CharSequence buffer, int oldOffset, IElementType tokenType) {
        IElementType oldType;
        KotlinLexer oldLexer = new KotlinLexer();
        oldLexer.start(oldText);
        KotlinLexer newLexer = new KotlinLexer();
        newLexer.start(buffer);
        while ((oldType = oldLexer.getTokenType()) != null) {
            IElementType newType = newLexer.getTokenType();
            if (newType == null) {
                return true;
            }
            if (newType != oldType) {
                if (newType == KtTokens.WHITE_SPACE) {
                    newLexer.advance();
                    continue;
                }
                if (oldType == KtTokens.WHITE_SPACE) {
                    oldLexer.advance();
                    continue;
                }
                return true;
            }
            if (oldType == tokenType && oldLexer.getCurrentPosition().getOffset() == oldOffset) break;
            oldLexer.advance();
            newLexer.advance();
        }
        return false;
    }

    public int getErrorsCount(CharSequence seq, Language fileLanguage, Project project) {
        return ElementTypeUtils.getKotlinBlockImbalanceCount(seq);
    }
}

