/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.maven.server.telemetry.MavenServerOpenTelemetry;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.platform.diagnostic.telemetry.rt.context.TelemetryContext;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.ReflectionUtilRt;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.ParseException;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.cli.internal.extension.model.CoreExtension;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.path.DefaultPathTranslator;
import org.apache.maven.model.path.DefaultUrlNormalizer;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.path.UrlNormalizer;
import org.apache.maven.model.validation.DefaultModelValidator;
import org.apache.maven.model.validation.ModelValidator;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.PluginDescriptorCache;
import org.apache.maven.plugin.internal.PluginDependenciesResolver;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.SettingsBuilder;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.BaseLoggerManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.ExceptionUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.server.LongRunningTask;
import org.jetbrains.idea.maven.server.LongRunningTaskInput;
import org.jetbrains.idea.maven.server.Maven3EffectivePomDumper;
import org.jetbrains.idea.maven.server.Maven3ImporterSpy;
import org.jetbrains.idea.maven.server.Maven3ModelConverter;
import org.jetbrains.idea.maven.server.Maven3ServerConsoleLogger;
import org.jetbrains.idea.maven.server.Maven3ServerEmbedder;
import org.jetbrains.idea.maven.server.Maven3TransferListenerAdapter;
import org.jetbrains.idea.maven.server.MavenArtifactResolutionRequest;
import org.jetbrains.idea.maven.server.MavenArtifactResolveResult;
import org.jetbrains.idea.maven.server.MavenConfigParseException;
import org.jetbrains.idea.maven.server.MavenCoreInitializationException;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenGoalExecutionRequest;
import org.jetbrains.idea.maven.server.MavenGoalExecutionResult;
import org.jetbrains.idea.maven.server.MavenLeakDetector;
import org.jetbrains.idea.maven.server.MavenServerConfigUtil;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicator;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicatorImpl;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicatorWrapper;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.server.MavenServerGlobals;
import org.jetbrains.idea.maven.server.MavenServerResponse;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.MavenServerStatsCollector;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.ParallelRunnerForServer;
import org.jetbrains.idea.maven.server.PluginResolutionRequest;
import org.jetbrains.idea.maven.server.PluginResolutionResponse;
import org.jetbrains.idea.maven.server.PomHashMap;
import org.jetbrains.idea.maven.server.ProjectResolutionRequest;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ArtifactFactory;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ArtifactResolver;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ModelInterpolator2;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3RepositoryMetadataManager;
import org.jetbrains.idea.maven.server.embedder.CustomModelValidator385;
import org.jetbrains.idea.maven.server.embedder.Maven3ExecutionResult;
import org.jetbrains.idea.maven.server.security.MavenToken;
import org.jetbrains.idea.maven.server.utils.Maven3SettingsBuilder;
import org.jetbrains.idea.maven.server.utils.Maven3XProjectResolver;

public abstract class Maven3XServerEmbedder
extends Maven3ServerEmbedder {
    @NotNull
    private final DefaultPlexusContainer myContainer;
    @NotNull
    private final Settings myMavenSettings;
    private final ArtifactRepository myLocalRepository;
    private final Maven3ServerConsoleLogger myConsoleWrapper;
    private final Properties mySystemProperties;
    private final boolean myAlwaysUpdateSnapshots;
    @NotNull
    private final RepositorySystem myRepositorySystem;
    @NotNull
    protected final Maven3ImporterSpy myImporterSpy;
    @NotNull
    protected final MavenEmbedderSettings myEmbedderSettings;

    public Maven3XServerEmbedder(MavenEmbedderSettings settings) {
        super(settings.getSettings());
        Object cliRequest;
        Class<?> cliRequestClass;
        this.myEmbedderSettings = settings;
        String multiModuleProjectDirectory = settings.getMultiModuleProjectDirectory();
        if (multiModuleProjectDirectory != null) {
            System.setProperty("user.dir", multiModuleProjectDirectory);
            System.setProperty("maven.multiModuleProjectDirectory", multiModuleProjectDirectory);
        } else {
            System.setProperty("maven.multiModuleProjectDirectory", "");
        }
        MavenServerSettings serverSettings = settings.getSettings();
        String mavenHome = serverSettings.getMavenHomePath();
        if (mavenHome != null) {
            System.setProperty("maven.home", mavenHome);
        }
        this.myConsoleWrapper = new Maven3ServerConsoleLogger();
        this.myConsoleWrapper.setThreshold(serverSettings.getLoggingLevel());
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        MavenCli cli = new MavenCli(classWorld){

            protected void customizeContainer(PlexusContainer container) {
                ((DefaultPlexusContainer)container).setLoggerManager((LoggerManager)new BaseLoggerManager(){

                    protected Logger createLogger(String s) {
                        return Maven3XServerEmbedder.this.myConsoleWrapper;
                    }
                });
            }
        };
        DefaultSettingsBuilder settingsBuilder = null;
        try {
            cliRequestClass = MavenCli.class.getClassLoader().loadClass("org.apache.maven.cli.MavenCli$CliRequest");
        }
        catch (ClassNotFoundException e) {
            try {
                cliRequestClass = MavenCli.class.getClassLoader().loadClass("org.apache.maven.cli.CliRequest");
                settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException("unable to find maven CliRequest class");
            }
        }
        try {
            List<String> commandLineOptions = Maven3XServerEmbedder.createCommandLineOptions(serverSettings);
            this.myAlwaysUpdateSnapshots = commandLineOptions.contains("-U") || commandLineOptions.contains("--update-snapshots");
            Constructor<?> constructor = cliRequestClass.getDeclaredConstructor(String[].class, ClassWorld.class);
            constructor.setAccessible(true);
            cliRequest = constructor.newInstance(commandLineOptions.toArray(new String[0]), classWorld);
            for (String each : new String[]{"initialize", "cli", "logging", "properties"}) {
                Method m = MavenCli.class.getDeclaredMethod(each, cliRequestClass);
                m.setAccessible(true);
                m.invoke((Object)cli, cliRequest);
            }
        }
        catch (Exception e) {
            ParseException cause = (ParseException)ExceptionUtilRt.findCause((Throwable)e, ParseException.class);
            if (cause != null) {
                String workingDir = settings.getMultiModuleProjectDirectory();
                if (workingDir == null) {
                    workingDir = System.getProperty("user.dir");
                }
                throw new MavenConfigParseException(cause.getMessage(), workingDir);
            }
            throw new RuntimeException(e);
        }
        try {
            Method m = MavenCli.class.getDeclaredMethod("container", cliRequestClass);
            m.setAccessible(true);
            this.myContainer = (DefaultPlexusContainer)m.invoke((Object)cli, cliRequest);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException().getClass().getCanonicalName().equals("org.apache.maven.cli.internal.ExtensionResolutionException")) {
                MavenId id = Maven3XServerEmbedder.extractIdFromException(((InvocationTargetException)e).getTargetException());
                throw new MavenCoreInitializationException((Throwable)this.wrapToSerializableRuntimeException(((InvocationTargetException)e).getTargetException()), id);
            }
            throw this.wrapToSerializableRuntimeException(e);
        }
        this.myContainer.getLoggerManager().setThreshold(serverSettings.getLoggingLevel());
        this.mySystemProperties = (Properties)ReflectionUtilRt.getField(cliRequestClass, cliRequest, Properties.class, (String)"systemProperties");
        if (serverSettings.getProjectJdk() != null) {
            this.mySystemProperties.setProperty("java.home", serverSettings.getProjectJdk());
        }
        if (settingsBuilder == null) {
            settingsBuilder = (SettingsBuilder)ReflectionUtilRt.getField(MavenCli.class, (Object)cli, SettingsBuilder.class, (String)"settingsBuilder");
        }
        this.myMavenSettings = Maven3SettingsBuilder.buildSettings((SettingsBuilder)settingsBuilder, (MavenServerSettings)serverSettings, (Properties)this.mySystemProperties, (Properties)((Properties)ReflectionUtilRt.getField(cliRequestClass, cliRequest, Properties.class, (String)"userProperties")));
        this.myLocalRepository = this.createLocalRepository();
        this.myRepositorySystem = this.getComponent(RepositorySystem.class);
        Maven3ImporterSpy importerSpy = this.getComponentIfExists(Maven3ImporterSpy.class);
        if (importerSpy == null) {
            importerSpy = new Maven3ImporterSpy();
            this.myContainer.addComponent((Object)importerSpy, Maven3ImporterSpy.class.getName());
        }
        this.myImporterSpy = importerSpy;
    }

    @NotNull
    private static List<String> createCommandLineOptions(MavenServerSettings serverSettings) {
        ArrayList<String> commandLineOptions = new ArrayList<String>(serverSettings.getUserProperties().size());
        for (Map.Entry<Object, Object> each : serverSettings.getUserProperties().entrySet()) {
            commandLineOptions.add("-D" + each.getKey() + "=" + each.getValue());
        }
        if (serverSettings.getLocalRepositoryPath() != null) {
            commandLineOptions.add("-Dmaven.repo.local=" + serverSettings.getLocalRepositoryPath());
        }
        if (serverSettings.isUpdateSnapshots()) {
            commandLineOptions.add("-U");
        }
        if (serverSettings.getLoggingLevel() == 0) {
            commandLineOptions.add("-X");
            commandLineOptions.add("-e");
        } else if (serverSettings.getLoggingLevel() == 5) {
            commandLineOptions.add("-q");
        }
        String mavenEmbedderCliOptions = System.getProperty("idea.maven.embedder.ext.cli.args");
        if (mavenEmbedderCliOptions != null) {
            commandLineOptions.addAll(StringUtilRt.splitHonorQuotes((String)mavenEmbedderCliOptions, (char)' '));
        }
        if (serverSettings.getGlobalSettingsPath() != null && new File(serverSettings.getGlobalSettingsPath()).isFile()) {
            commandLineOptions.add("-gs");
            commandLineOptions.add(serverSettings.getGlobalSettingsPath());
        }
        if (serverSettings.getUserSettingsPath() != null && new File(serverSettings.getUserSettingsPath()).isFile()) {
            commandLineOptions.add("-s");
            commandLineOptions.add(serverSettings.getUserSettingsPath());
        }
        if (serverSettings.isOffline()) {
            commandLineOptions.add("-o");
        }
        ArrayList<String> arrayList = commandLineOptions;
        if (arrayList == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static MavenId extractIdFromException(Throwable exception) {
        try {
            Field field = exception.getClass().getDeclaredField("extension");
            field.setAccessible(true);
            CoreExtension extension = (CoreExtension)field.get(exception);
            return new MavenId(extension.getGroupId(), extension.getArtifactId(), extension.getVersion());
        }
        catch (Throwable e) {
            return null;
        }
    }

    @NotNull
    protected PlexusContainer getContainer() {
        DefaultPlexusContainer defaultPlexusContainer = this.myContainer;
        if (defaultPlexusContainer == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(1);
        }
        return defaultPlexusContainer;
    }

    private static List<Exception> filterExceptions(List<Throwable> list) {
        for (Throwable throwable : list) {
            if (throwable instanceof Exception) continue;
            throw new RuntimeException(throwable);
        }
        return list;
    }

    protected <T> void addComponent(T componemnt, Class<T> clazz) {
        this.myContainer.addComponent(componemnt, clazz.getName());
    }

    public <T> T getComponent(Class<T> clazz, String roleHint) {
        try {
            return (T)this.myContainer.lookup(clazz.getName(), roleHint);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getComponent(Class<T> clazz) {
        try {
            return (T)this.myContainer.lookup(clazz.getName());
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getComponentIfExists(Class<T> clazz) {
        try {
            return (T)this.myContainer.lookup(clazz.getName());
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    public <T> T getComponentIfExists(Class<T> clazz, String roleHint) {
        try {
            return (T)this.myContainer.lookup(clazz.getName(), roleHint);
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    public <T> List<T> getComponents(Class<T> clazz) {
        try {
            return this.myContainer.lookupList(clazz.getName());
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    private ArtifactRepository createLocalRepository() {
        try {
            ArtifactRepository localRepository = this.getComponent(RepositorySystem.class).createLocalRepository(new File(this.myMavenSettings.getLocalRepository()));
            String customRepoId = System.getProperty("maven3.localRepository.id", "localIntelliJ");
            if (customRepoId != null) {
                localRepository.setId(customRepoId);
            }
            return localRepository;
        }
        catch (InvalidRepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    protected void customizeComponents(@Nullable MavenWorkspaceMap workspaceMap) {
        try {
            ModelValidator modelValidator;
            if (VersionComparatorUtil.compare((String)"3.7.0-SNAPSHOT", (String)this.getMavenVersion()) < 0) {
                this.myContainer.addComponent((Object)this.getComponent(ArtifactFactory.class, "ide"), ArtifactFactory.ROLE);
            }
            this.myContainer.addComponent((Object)this.getComponent(ArtifactResolver.class, "ide"), ArtifactResolver.ROLE);
            this.myContainer.addComponent((Object)this.getComponent(RepositoryMetadataManager.class, "ide"), RepositoryMetadataManager.class.getName());
            this.myContainer.addComponent((Object)this.getComponent(PluginDescriptorCache.class, "ide"), PluginDescriptorCache.class.getName());
            org.apache.maven.model.interpolation.ModelInterpolator modelInterpolator = this.createAndPutInterpolator(this.myContainer);
            if (VersionComparatorUtil.compare((String)this.getMavenVersion(), (String)"3.8.5") >= 0) {
                modelValidator = new CustomModelValidator385((CustomMaven3ModelInterpolator2)modelInterpolator, (DefaultModelValidator)this.getComponent(ModelValidator.class));
            } else {
                modelValidator = this.getComponent(ModelValidator.class, "ide");
                this.myContainer.addComponent((Object)modelValidator, ModelValidator.class.getName());
            }
            DefaultModelBuilder defaultModelBuilder = (DefaultModelBuilder)this.getComponent(ModelBuilder.class);
            defaultModelBuilder.setModelValidator(modelValidator);
            defaultModelBuilder.setModelInterpolator(modelInterpolator);
            ArtifactFactory artifactFactory = this.getComponent(ArtifactFactory.class);
            if (artifactFactory instanceof CustomMaven3ArtifactFactory) {
                ((CustomMaven3ArtifactFactory)artifactFactory).customize();
            }
            ((CustomMaven3ArtifactResolver)this.getComponent(ArtifactResolver.class)).customize(workspaceMap);
            ((CustomMaven3RepositoryMetadataManager)this.getComponent(RepositoryMetadataManager.class)).customize(workspaceMap, this.mySystemProperties);
        }
        catch (Exception e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    protected void resetComponents() {
        RepositoryMetadataManager repositoryMetadataManager;
        ArtifactResolver artifactResolver;
        ArtifactFactory artifactFactory = this.getComponent(ArtifactFactory.class);
        if (artifactFactory instanceof CustomMaven3ArtifactFactory) {
            ((CustomMaven3ArtifactFactory)artifactFactory).reset();
        }
        if ((artifactResolver = this.getComponent(ArtifactResolver.class)) instanceof CustomMaven3ArtifactResolver) {
            ((CustomMaven3ArtifactResolver)artifactResolver).reset();
        }
        if ((repositoryMetadataManager = this.getComponent(RepositoryMetadataManager.class)) instanceof CustomMaven3RepositoryMetadataManager) {
            ((CustomMaven3RepositoryMetadataManager)repositoryMetadataManager).reset();
        }
    }

    private org.apache.maven.model.interpolation.ModelInterpolator createAndPutInterpolator(DefaultPlexusContainer container) {
        if (VersionComparatorUtil.compare((String)this.getMavenVersion(), (String)"3.6.2") >= 0) {
            DefaultPathTranslator pathTranslator = new DefaultPathTranslator();
            DefaultUrlNormalizer urlNormalizer = new DefaultUrlNormalizer();
            container.addComponent((Object)pathTranslator, PathTranslator.class.getName());
            container.addComponent((Object)pathTranslator, PathTranslator.class, "ide");
            container.addComponent((Object)urlNormalizer, UrlNormalizer.class.getName());
            container.addComponent((Object)urlNormalizer, UrlNormalizer.class, "ide");
            CustomMaven3ModelInterpolator2 interpolator = new CustomMaven3ModelInterpolator2();
            interpolator.setPathTranslator((PathTranslator)pathTranslator);
            interpolator.setUrlNormalizer((UrlNormalizer)urlNormalizer);
            if (VersionComparatorUtil.compare((String)this.getMavenVersion(), (String)"3.8.5") >= 0) {
                try {
                    Class<?> clazz = Class.forName("org.apache.maven.model.interpolation.ModelVersionProcessor");
                    Object component = this.getComponent(clazz);
                    container.addComponent(component, clazz.getName());
                    container.addComponent(component, clazz, "ide");
                    Method methodSetModelVersionProcessor = interpolator.getClass().getMethod("setVersionPropertiesProcessor", clazz);
                    methodSetModelVersionProcessor.invoke((Object)interpolator, component);
                }
                catch (Exception e) {
                    MavenServerGlobals.getLogger().error((Throwable)e);
                }
            }
            return interpolator;
        }
        org.apache.maven.model.interpolation.ModelInterpolator modelInterpolator = this.getComponent(org.apache.maven.model.interpolation.ModelInterpolator.class, "ide");
        this.myContainer.addComponent((Object)modelInterpolator, org.apache.maven.model.interpolation.ModelInterpolator.class.getName());
        this.myContainer.addComponent((Object)this.getComponent(ModelInterpolator.class, "ide"), ModelInterpolator.ROLE);
        return modelInterpolator;
    }

    /*
     * Loose catch block
     */
    @NotNull
    public @NotNull MavenServerResponse<@NotNull String> evaluateEffectivePom(@NotNull LongRunningTaskInput longRunningTaskInput, @NotNull File file, @NotNull ArrayList<String> activeProfiles, @NotNull ArrayList<String> inactiveProfiles, MavenToken token) {
        MavenServerResponse mavenServerResponse;
        LongRunningTask task;
        block13: {
            if (longRunningTaskInput == null) {
                Maven3XServerEmbedder.$$$reportNull$$$0(2);
            }
            if (file == null) {
                Maven3XServerEmbedder.$$$reportNull$$$0(3);
            }
            if (activeProfiles == null) {
                Maven3XServerEmbedder.$$$reportNull$$$0(4);
            }
            if (inactiveProfiles == null) {
                Maven3XServerEmbedder.$$$reportNull$$$0(5);
            }
            MavenServerUtil.checkToken((MavenToken)token);
            String longRunningTaskId = longRunningTaskInput.getLongRunningTaskId();
            task = this.newLongRunningTask(longRunningTaskId, 1, (MavenServerConsoleIndicatorWrapper)this.myConsoleWrapper);
            String result = Maven3EffectivePomDumper.evaluateEffectivePom((Maven3ServerEmbedder)this, (File)file, activeProfiles, inactiveProfiles);
            task.incrementFinishedRequests();
            mavenServerResponse = new MavenServerResponse((Serializable)((Object)result), this.getLongRunningTaskStatus(longRunningTaskId, token));
            if (task == null) break block13;
            task.close();
        }
        MavenServerResponse mavenServerResponse2 = mavenServerResponse;
        if (mavenServerResponse2 == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(6);
        }
        return mavenServerResponse2;
        {
            catch (Throwable throwable) {
                try {
                    if (task != null) {
                        try {
                            task.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw this.wrapToSerializableRuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public MavenServerResponse<ArrayList<MavenServerExecutionResult>> resolveProjects(@NotNull LongRunningTaskInput longRunningTaskInput, @NotNull ProjectResolutionRequest request, MavenToken token) {
        if (longRunningTaskInput == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(7);
        }
        if (request == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(8);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        String longRunningTaskId = longRunningTaskInput.getLongRunningTaskId();
        MavenServerOpenTelemetry telemetry = MavenServerOpenTelemetry.from((TelemetryContext)longRunningTaskInput.getTelemetryContext());
        @NotNull @NotNull List filesToResolve = request.getFilesToResolve();
        PomHashMap pomHashMap = request.getPomHashMap();
        List activeProfiles = request.getActiveProfiles();
        List inactiveProfiles = request.getInactiveProfiles();
        MavenWorkspaceMap workspaceMap = request.getWorkspaceMap();
        boolean updateSnapshots = this.myAlwaysUpdateSnapshots || request.updateSnapshots();
        LongRunningTask task = this.newLongRunningTask(longRunningTaskId, pomHashMap.size(), (MavenServerConsoleIndicatorWrapper)this.myConsoleWrapper);
        Maven3XProjectResolver projectResolver = this.createProjectResolver(filesToResolve, request, telemetry, updateSnapshots, task, pomHashMap, activeProfiles, inactiveProfiles, workspaceMap);
        this.customizeComponents(workspaceMap);
        ArrayList result = (ArrayList)telemetry.callWithSpan("projectResolver.resolveProjects", () -> projectResolver.resolveProjects());
        telemetry.shutdown();
        MavenServerResponse mavenServerResponse = new MavenServerResponse((Serializable)result, this.getLongRunningTaskStatus(longRunningTaskId, token));
        this.resetComponents();
        MavenServerResponse mavenServerResponse2 = mavenServerResponse;
        if (mavenServerResponse2 == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(9);
        }
        return mavenServerResponse2;
        {
            catch (Throwable throwable) {
                this.resetComponents();
                throw throwable;
            }
        }
        finally {
            if (task != null) {
                task.close();
            }
        }
    }

    @NotNull
    protected Maven3XProjectResolver createProjectResolver(@NotNull @NotNull List<@NotNull File> filesToResolve, @NotNull ProjectResolutionRequest request, MavenServerOpenTelemetry telemetry, boolean updateSnapshots, LongRunningTask task, PomHashMap pomHashMap, List<String> activeProfiles, List<String> inactiveProfiles, MavenWorkspaceMap workspaceMap) {
        Maven3XProjectResolver projectResolver;
        if (filesToResolve == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(10);
        }
        if (request == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(11);
        }
        Maven3XProjectResolver maven3XProjectResolver = projectResolver = new Maven3XProjectResolver(this, telemetry, updateSnapshots, this.myImporterSpy, task, filesToResolve, pomHashMap, activeProfiles, inactiveProfiles, workspaceMap, request.getUserProperties(), this.canResolveDependenciesInParallel());
        if (maven3XProjectResolver == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(12);
        }
        return maven3XProjectResolver;
    }

    private boolean canResolveDependenciesInParallel() {
        if (this.myEmbedderSettings.forceResolveDependenciesSequentially()) {
            return false;
        }
        String mavenVersion = System.getProperty("idea.maven.embedder.version");
        return !"3.8.2".equals(mavenVersion) && !"3.8.3".equals(mavenVersion);
    }

    public MavenExecutionRequest createRequest(@Nullable File file, @Nullable List<String> activeProfiles, @Nullable List<String> inactiveProfiles, @NotNull Properties customProperties) {
        if (customProperties == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(13);
        }
        DefaultMavenExecutionRequest result = new DefaultMavenExecutionRequest();
        try {
            this.getComponent(MavenExecutionRequestPopulator.class).populateFromSettings((MavenExecutionRequest)result, this.myMavenSettings);
            result.setPom(file);
            this.getComponent(MavenExecutionRequestPopulator.class).populateDefaults((MavenExecutionRequest)result);
            result.setSystemProperties(this.mySystemProperties);
            Properties userProperties = new Properties();
            if (file != null) {
                userProperties.putAll((Map<?, ?>)MavenServerConfigUtil.getMavenAndJvmConfigPropertiesForNestedProjectDir((File)file.getParentFile()));
            }
            userProperties.putAll((Map<?, ?>)customProperties);
            result.setUserProperties(userProperties);
            result.setActiveProfiles(Maven3XServerEmbedder.collectActiveProfiles(result.getActiveProfiles(), activeProfiles, inactiveProfiles));
            if (inactiveProfiles != null) {
                result.setInactiveProfiles(inactiveProfiles);
            }
            result.setCacheNotFound(true);
            result.setCacheTransferError(true);
            result.setStartTime(new Date());
            File mavenMultiModuleProjectDirectory = Maven3XServerEmbedder.getMultimoduleProjectDir(file);
            result.setBaseDirectory(mavenMultiModuleProjectDirectory);
            Method setMultiModuleProjectDirectoryMethod = Maven3XServerEmbedder.getSetMultiModuleProjectDirectoryMethod((MavenExecutionRequest)result);
            if (setMultiModuleProjectDirectoryMethod != null) {
                try {
                    result.setMultiModuleProjectDirectory(mavenMultiModuleProjectDirectory);
                }
                catch (Exception e) {
                    MavenServerGlobals.getLogger().error((Throwable)e);
                }
            }
            return result;
        }
        catch (MavenExecutionRequestPopulationException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<String> collectActiveProfiles(@Nullable List<String> defaultActiveProfiles, @Nullable List<String> explicitActiveProfiles, @Nullable List<String> explicitInactiveProfiles) {
        if (defaultActiveProfiles == null || defaultActiveProfiles.isEmpty()) {
            return explicitActiveProfiles != null ? explicitActiveProfiles : Collections.emptyList();
        }
        HashSet<String> result = new HashSet<String>(defaultActiveProfiles);
        if (explicitInactiveProfiles != null && !explicitInactiveProfiles.isEmpty()) {
            result.removeAll(explicitInactiveProfiles);
        }
        if (explicitActiveProfiles != null) {
            result.addAll(explicitActiveProfiles);
        }
        return new ArrayList<String>(result);
    }

    @NotNull
    private static File getMultimoduleProjectDir(@Nullable File file) {
        File mavenMultiModuleProjectDirectory = file == null ? new File(FileUtilRt.getTempDirectory()) : MavenServerUtil.findMavenBasedir((File)file);
        File file2 = mavenMultiModuleProjectDirectory;
        if (file2 == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(14);
        }
        return file2;
    }

    private static Method getSetMultiModuleProjectDirectoryMethod(MavenExecutionRequest result) {
        try {
            Method method = result.getClass().getDeclaredMethod("setMultiModuleProjectDirectory", File.class);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    @NotNull
    public File getLocalRepositoryFile() {
        return new File(this.myLocalRepository.getBasedir());
    }

    @NotNull
    private MavenGoalExecutionResult createEmbedderExecutionResult(@NotNull File file, Maven3ExecutionResult result) {
        if (file == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(15);
        }
        Collection<MavenProjectProblem> problems = this.collectProblems(file, result.getExceptions(), Collections.emptyList());
        MavenGoalExecutionResult.Folders folders = new MavenGoalExecutionResult.Folders();
        MavenProject mavenProject = result.getMavenProject();
        if (mavenProject == null) {
            return new MavenGoalExecutionResult(false, file, folders, problems);
        }
        folders.set(mavenProject.getCompileSourceRoots(), mavenProject.getTestCompileSourceRoots(), Maven3ModelConverter.convertResources((List)mavenProject.getModel().getBuild().getResources()), Maven3ModelConverter.convertResources((List)mavenProject.getModel().getBuild().getTestResources()));
        return new MavenGoalExecutionResult(true, file, folders, problems);
    }

    public Collection<MavenProjectProblem> collectProblems(@Nullable File file, @NotNull Collection<? extends Exception> exceptions, @NotNull List<? extends ModelProblem> modelProblems) {
        if (exceptions == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(16);
        }
        if (modelProblems == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(17);
        }
        LinkedHashSet<MavenProjectProblem> problems = new LinkedHashSet<MavenProjectProblem>();
        for (Throwable throwable : exceptions) {
            problems.addAll(this.collectExceptionProblems(file, throwable));
        }
        for (ModelProblem modelProblem : modelProblems) {
            String source = !StringUtilRt.isEmptyOrSpaces((CharSequence)modelProblem.getSource()) ? modelProblem.getSource() + ":" + modelProblem.getLineNumber() + ":" + modelProblem.getColumnNumber() : (file == null ? "" : file.getPath());
            this.myConsoleWrapper.error("Maven model problem: " + modelProblem.getMessage() + " at " + modelProblem.getSource() + ":" + modelProblem.getLineNumber() + ":" + modelProblem.getColumnNumber());
            Exception problemException = modelProblem.getException();
            if (problemException != null) {
                this.myConsoleWrapper.error("Maven model problem", (Throwable)problemException);
                problems.add(MavenProjectProblem.createStructureProblem((String)source, (String)modelProblem.getMessage()));
                continue;
            }
            problems.add(MavenProjectProblem.createStructureProblem((String)source, (String)modelProblem.getMessage(), (boolean)false));
        }
        return problems;
    }

    private List<MavenProjectProblem> collectExceptionProblems(@Nullable File file, Throwable ex) {
        String path;
        ArrayList<MavenProjectProblem> result = new ArrayList<MavenProjectProblem>();
        if (ex == null) {
            return result;
        }
        MavenServerGlobals.getLogger().print(ExceptionUtils.getFullStackTrace((Throwable)ex));
        this.myConsoleWrapper.info("Validation error:", ex);
        Artifact problemTransferArtifact = Maven3XServerEmbedder.getProblemTransferArtifact(ex);
        if (ex instanceof IllegalStateException && ex.getCause() != null) {
            ex = ex.getCause();
        }
        String string = path = file == null ? "" : file.getPath();
        if (path.isEmpty() && ex instanceof ProjectBuildingException) {
            File pomFile = ((ProjectBuildingException)ex).getPomFile();
            String string2 = path = pomFile == null ? "" : pomFile.getPath();
        }
        if (ex instanceof InvalidProjectModelException) {
            ModelValidationResult modelValidationResult = ((InvalidProjectModelException)ex).getValidationResult();
            if (modelValidationResult != null) {
                for (String eachValidationProblem : modelValidationResult.getMessages()) {
                    result.add(MavenProjectProblem.createStructureProblem((String)path, (String)eachValidationProblem));
                }
            } else {
                result.add(MavenProjectProblem.createStructureProblem((String)path, (String)ex.getCause().getMessage()));
            }
        } else if (ex instanceof ProjectBuildingException) {
            String causeMessage = ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage();
            result.add(MavenProjectProblem.createStructureProblem((String)path, (String)causeMessage));
        } else if (ex.getStackTrace().length > 0 && ex.getClass().getPackage().getName().equals("groovy.lang")) {
            this.myConsoleWrapper.error("Maven server structure problem", ex);
            StackTraceElement traceElement = ex.getStackTrace()[0];
            result.add(MavenProjectProblem.createStructureProblem((String)(traceElement.getFileName() + ":" + traceElement.getLineNumber()), (String)ex.getMessage()));
        } else if (problemTransferArtifact != null) {
            this.myConsoleWrapper.error("[server] Maven transfer artifact problem: " + problemTransferArtifact);
            String message = Maven3XServerEmbedder.getRootMessage(ex);
            MavenArtifact mavenArtifact = Maven3ModelConverter.convertArtifact((Artifact)problemTransferArtifact, (File)this.getLocalRepositoryFile());
            result.add(MavenProjectProblem.createRepositoryProblem((String)path, (String)message, (boolean)false, (MavenArtifact)mavenArtifact));
        } else {
            this.myConsoleWrapper.error("Maven server structure problem", ex);
            result.add(MavenProjectProblem.createStructureProblem((String)path, (String)Maven3XServerEmbedder.getRootMessage(ex), (boolean)false));
        }
        return result;
    }

    @NotNull
    private static String getRootMessage(Throwable each) {
        String baseMessage = each.getMessage() != null ? each.getMessage() : "";
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)each);
        String rootMessage = rootCause != null ? rootCause.getMessage() : "";
        String string = StringUtils.isNotEmpty((String)rootMessage) ? rootMessage : baseMessage;
        if (string == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nullable
    private static Artifact getProblemTransferArtifact(Throwable each) {
        Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)each);
        if (throwables == null) {
            return null;
        }
        for (Throwable throwable : throwables) {
            if (!(throwable instanceof ArtifactTransferException)) continue;
            return RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)((ArtifactTransferException)throwable).getArtifact());
        }
        return null;
    }

    /*
     * Loose catch block
     */
    @NotNull
    public @NotNull MavenServerResponse<@NotNull MavenArtifactResolveResult> resolveProcessorPathEntries(@NotNull LongRunningTaskInput longRunningTaskInput, @NotNull ArrayList<MavenArtifactInfo> artifacts, @NotNull ArrayList<MavenRemoteRepository> remoteRepositories, @NotNull HashMap<String, MavenArtifactInfo> managedDependencies, @NotNull MavenExplicitProfiles profiles, MavenToken token) {
        MavenServerResponse mavenServerResponse;
        LongRunningTask task;
        block14: {
            if (longRunningTaskInput == null) {
                Maven3XServerEmbedder.$$$reportNull$$$0(19);
            }
            if (artifacts == null) {
                Maven3XServerEmbedder.$$$reportNull$$$0(20);
            }
            if (remoteRepositories == null) {
                Maven3XServerEmbedder.$$$reportNull$$$0(21);
            }
            if (managedDependencies == null) {
                Maven3XServerEmbedder.$$$reportNull$$$0(22);
            }
            if (profiles == null) {
                Maven3XServerEmbedder.$$$reportNull$$$0(23);
            }
            MavenServerUtil.checkToken((MavenToken)token);
            String longRunningTaskId = longRunningTaskInput.getLongRunningTaskId();
            task = this.newLongRunningTask(longRunningTaskId, 1, (MavenServerConsoleIndicatorWrapper)this.myConsoleWrapper);
            HashMap managed = new HashMap();
            MavenArtifactResolveResult result = this.resolveProcessorPathEntries(artifacts, remoteRepositories, managedDependencies, profiles);
            task.incrementFinishedRequests();
            mavenServerResponse = new MavenServerResponse((Serializable)result, this.getLongRunningTaskStatus(longRunningTaskId, token));
            if (task == null) break block14;
            task.close();
        }
        MavenServerResponse mavenServerResponse2 = mavenServerResponse;
        if (mavenServerResponse2 == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(24);
        }
        return mavenServerResponse2;
        {
            catch (Throwable throwable) {
                try {
                    if (task != null) {
                        try {
                            task.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw this.wrapToSerializableRuntimeException(e);
                }
            }
        }
    }

    @NotNull
    private MavenArtifactResolveResult resolveProcessorPathEntries(@NotNull ArrayList<MavenArtifactInfo> artifacts, @NotNull ArrayList<MavenRemoteRepository> remoteRepositories, @NotNull Map<String, MavenArtifactInfo> managedDependencies, @NotNull MavenExplicitProfiles profiles) {
        if (artifacts == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(25);
        }
        if (remoteRepositories == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(26);
        }
        if (managedDependencies == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(27);
        }
        if (profiles == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(28);
        }
        try {
            MavenExecutionRequest request = this.createRequest(null, new ArrayList<String>(profiles.getEnabledProfiles()), new ArrayList<String>(profiles.getDisabledProfiles()), new Properties());
            Ref mavenArtifacts = Ref.create();
            this.executeWithMavenSession(request, () -> {
                try {
                    this.doResolveProcessorEntries(artifacts, remoteRepositories, managedDependencies, (Ref<List<MavenArtifact>>)mavenArtifacts);
                }
                catch (DependencyResolutionException e) {
                    throw new RuntimeException(e);
                }
            });
            return new MavenArtifactResolveResult((List)mavenArtifacts.get(), null);
        }
        catch (Exception e) {
            try {
                MavenProjectProblem problem;
                MavenServerGlobals.getLogger().error((Throwable)e);
                Artifact transferArtifact = Maven3XServerEmbedder.getProblemTransferArtifact(e);
                String message = Maven3XServerEmbedder.getRootMessage(e);
                if (transferArtifact != null) {
                    MavenArtifact mavenArtifact = Maven3ModelConverter.convertArtifact((Artifact)transferArtifact, (File)this.getLocalRepositoryFile());
                    problem = MavenProjectProblem.createRepositoryProblem((String)"", (String)message, (boolean)false, (MavenArtifact)mavenArtifact);
                } else {
                    problem = MavenProjectProblem.createStructureProblem((String)"", (String)message);
                }
                return new MavenArtifactResolveResult(Collections.emptyList(), problem);
            }
            catch (Exception e2) {
                throw this.wrapToSerializableRuntimeException(e2);
            }
        }
    }

    private void doResolveProcessorEntries(@NotNull ArrayList<MavenArtifactInfo> artifacts, @NotNull ArrayList<MavenRemoteRepository> remoteRepositories, @NotNull Map<String, MavenArtifactInfo> managedDependencies, Ref<List<MavenArtifact>> mavenArtifacts) throws DependencyResolutionException {
        if (artifacts == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(29);
        }
        if (remoteRepositories == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(30);
        }
        if (managedDependencies == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(31);
        }
        List repos = RepositoryUtils.toRepos(this.convertRepositories(remoteRepositories));
        CollectRequest collectRequest = new CollectRequest(this.convertToDependencies(artifacts), this.convertToDependencies(managedDependencies.values()), repos);
        DependencyRequest dependencyRequest = new DependencyRequest();
        dependencyRequest.setCollectRequest(collectRequest);
        RepositorySystemSession repoSession = this.getComponent(LegacySupport.class).getSession().getRepositorySession();
        DependencyResult dependencyResult = this.getComponent(org.eclipse.aether.RepositorySystem.class).resolveDependencies(repoSession, dependencyRequest);
        ArrayList artifact = new ArrayList();
        ArrayList exceptions = new ArrayList();
        dependencyResult.getArtifactResults().forEach(ar -> {
            org.eclipse.aether.artifact.Artifact resolved = ar.getArtifact();
            if (resolved != null) {
                artifact.add(new MavenArtifact(resolved.getGroupId(), resolved.getArtifactId(), resolved.getVersion(), resolved.getBaseVersion(), resolved.getExtension(), resolved.getClassifier(), ar.getRequest().getDependencyNode().getDependency().getScope(), false, resolved.getExtension(), resolved.getFile(), this.getLocalRepositoryFile(), ar.isResolved(), false));
            } else {
                exceptions.addAll(ar.getExceptions());
            }
        });
        if (!exceptions.isEmpty()) {
            exceptions.forEach(e -> MavenServerGlobals.getLogger().error((Throwable)e));
            throw new RuntimeException((Throwable)exceptions.get(0));
        }
        mavenArtifacts.set(artifact);
    }

    private List<Dependency> convertToDependencies(@NotNull Collection<MavenArtifactInfo> annotationProcessorPaths) {
        if (annotationProcessorPaths == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(32);
        }
        ArtifactHandlerManager artifactHandlerManager = this.getComponent(ArtifactHandlerManager.class);
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (MavenArtifactInfo annotationProcessorPath : annotationProcessorPaths) {
            ArtifactHandler handler = artifactHandlerManager.getArtifactHandler(annotationProcessorPath.getPackaging());
            DefaultArtifact artifact = new DefaultArtifact(annotationProcessorPath.getGroupId(), annotationProcessorPath.getArtifactId(), annotationProcessorPath.getClassifier(), handler.getExtension(), annotationProcessorPath.getVersion());
            dependencies.add(new Dependency((org.eclipse.aether.artifact.Artifact)artifact, "runtime", Boolean.valueOf(false), new HashSet()));
        }
        return dependencies;
    }

    @NotNull
    private List<MavenArtifact> doResolveTransitivelyWithError(@NotNull List<MavenArtifactInfo> artifacts, @NotNull List<MavenRemoteRepository> remoteRepositories, @NotNull Map<String, Artifact> managedDependencies) throws ArtifactResolutionException, ArtifactNotFoundException {
        if (artifacts == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(33);
        }
        if (remoteRepositories == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(34);
        }
        if (managedDependencies == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(35);
        }
        LinkedHashSet<Artifact> toResolve = new LinkedHashSet<Artifact>();
        for (MavenArtifactInfo each : artifacts) {
            toResolve.add(this.createArtifact(each));
        }
        Artifact project = this.getComponent(ArtifactFactory.class).createBuildArtifact("temp", "temp", "666", "pom");
        Set res = this.getComponent(ArtifactResolver.class).resolveTransitively(toResolve, project, managedDependencies, this.myLocalRepository, this.convertRepositories(remoteRepositories), this.getComponent(ArtifactMetadataSource.class)).getArtifacts();
        List list = Maven3ModelConverter.convertArtifacts((Collection)res, new HashMap(), (File)this.getLocalRepositoryFile());
        if (list == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(36);
        }
        return list;
    }

    public MavenServerResponse<ArrayList<PluginResolutionResponse>> resolvePlugins(@NotNull LongRunningTaskInput longRunningTaskInput, @NotNull ArrayList<PluginResolutionRequest> pluginResolutionRequests, boolean forceUpdateSnapshots, MavenToken token) {
        if (longRunningTaskInput == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(37);
        }
        if (pluginResolutionRequests == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(38);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        String longRunningTaskId = longRunningTaskInput.getLongRunningTaskId();
        MavenServerOpenTelemetry telemetry = MavenServerOpenTelemetry.from((TelemetryContext)longRunningTaskInput.getTelemetryContext());
        String mavenVersion = System.getProperty("idea.maven.embedder.version");
        boolean runInParallel = this.canResolveDependenciesInParallel() && VersionComparatorUtil.compare((String)mavenVersion, (String)"3.6.0") >= 0;
        try (LongRunningTask task = this.newLongRunningTask(longRunningTaskId, pluginResolutionRequests.size(), (MavenServerConsoleIndicatorWrapper)this.myConsoleWrapper);){
            MavenExecutionRequest request = this.createRequest(null, null, null);
            request.setTransferListener((TransferListener)new Maven3TransferListenerAdapter(task.getIndicator()));
            request.setUpdateSnapshots(this.myAlwaysUpdateSnapshots || forceUpdateSnapshots);
            DefaultMaven maven = (DefaultMaven)this.getComponent(Maven.class);
            RepositorySystemSession session = maven.newRepositorySession(request);
            this.myImporterSpy.setIndicator((MavenServerConsoleIndicator)task.getIndicator());
            ArrayList<PluginResolutionData> resolutions = new ArrayList<PluginResolutionData>();
            for (PluginResolutionRequest pluginResolutionRequest : pluginResolutionRequests) {
                MavenId mavenPluginId = pluginResolutionRequest.getMavenPluginId();
                List remoteRepos = RepositoryUtils.toRepos(this.convertRepositories(pluginResolutionRequest.getRepositories()));
                ArrayList<org.apache.maven.model.Dependency> dependencies = new ArrayList<org.apache.maven.model.Dependency>();
                for (MavenId dependencyId : pluginResolutionRequest.getPluginDependencies()) {
                    org.apache.maven.model.Dependency dependency = new org.apache.maven.model.Dependency();
                    dependency.setGroupId(dependencyId.getGroupId());
                    dependency.setArtifactId(dependencyId.getArtifactId());
                    dependency.setVersion(dependencyId.getVersion());
                    dependencies.add(dependency);
                }
                PluginResolutionData resolution2 = new PluginResolutionData(mavenPluginId, pluginResolutionRequest.resolvePluginDependencies(), dependencies, remoteRepos);
                resolutions.add(resolution2);
            }
            List results = ParallelRunnerForServer.execute((boolean)runInParallel, resolutions, resolution -> this.resolvePlugin(task, resolution.mavenPluginId, resolution.resolveDependencies, resolution.dependencies, resolution.remoteRepos, session));
            telemetry.shutdown();
            MavenServerResponse mavenServerResponse = new MavenServerResponse(new ArrayList(results), this.getLongRunningTaskStatus(longRunningTaskId, token));
            return mavenServerResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private PluginResolutionResponse resolvePlugin(LongRunningTask task, MavenId mavenPluginId, boolean resolveDependencies, List<org.apache.maven.model.Dependency> dependencies, List<RemoteRepository> remoteRepos, RepositorySystemSession session) {
        PluginResolutionResponse pluginResolutionResponse;
        MavenServerStatsCollector.pluginResolve((String)mavenPluginId.toString());
        long startTime = System.currentTimeMillis();
        MavenArtifact mavenPluginArtifact = null;
        ArrayList<MavenArtifact> artifacts = new ArrayList<MavenArtifact>();
        if (task.isCanceled()) {
            return new PluginResolutionResponse(mavenPluginId, mavenPluginArtifact, artifacts);
        }
        try {
            Plugin plugin = new Plugin();
            plugin.setGroupId(mavenPluginId.getGroupId());
            plugin.setArtifactId(mavenPluginId.getArtifactId());
            plugin.setVersion(mavenPluginId.getVersion());
            plugin.setDependencies(dependencies);
            PluginDependenciesResolver pluginDependenciesResolver = this.getComponent(PluginDependenciesResolver.class);
            org.eclipse.aether.artifact.Artifact pluginArtifact = pluginDependenciesResolver.resolve(plugin, remoteRepos, session);
            mavenPluginArtifact = Maven3ModelConverter.convertArtifact((Artifact)RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)pluginArtifact), (File)this.getLocalRepositoryFile());
            DependencyFilter dependencyFilter = resolveDependencies ? null : new DependencyFilter(){

                public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                    return false;
                }
            };
            DependencyNode node = pluginDependenciesResolver.resolve(plugin, pluginArtifact, dependencyFilter, remoteRepos, session);
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            node.accept((DependencyVisitor)nlg);
            for (org.eclipse.aether.artifact.Artifact artifact : nlg.getArtifacts(true)) {
                MavenArtifact mavenArtifact = Maven3ModelConverter.convertArtifact((Artifact)RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)artifact), (File)this.getLocalRepositoryFile());
                if (Objects.equals(artifact.getArtifactId(), plugin.getArtifactId()) && Objects.equals(artifact.getGroupId(), plugin.getGroupId())) continue;
                artifacts.add(mavenArtifact);
            }
            task.incrementFinishedRequests();
            PluginResolutionResponse pluginResolutionResponse2 = new PluginResolutionResponse(mavenPluginId, mavenPluginArtifact, artifacts);
            pluginResolutionResponse = pluginResolutionResponse2;
        }
        catch (Exception e) {
            MavenServerGlobals.getLogger().warn((Throwable)e);
            PluginResolutionResponse pluginResolutionResponse3 = new PluginResolutionResponse(mavenPluginId, mavenPluginArtifact, artifacts);
            PluginResolutionResponse pluginResolutionResponse4 = pluginResolutionResponse3;
            if (pluginResolutionResponse4 == null) {
                Maven3XServerEmbedder.$$$reportNull$$$0(40);
            }
            return pluginResolutionResponse4;
        }
        finally {
            long totalTime = System.currentTimeMillis() - startTime;
            MavenServerGlobals.getLogger().debug("Resolved plugin " + mavenPluginId + " in " + totalTime + " ms");
        }
        if (pluginResolutionResponse == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(39);
        }
        return pluginResolutionResponse;
    }

    @Nullable
    public MavenModel readModel(File file, MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            HashMap<String, Object> inputOptions = new HashMap<String, Object>();
            inputOptions.put("org.apache.maven.model.building.source", new FileModelSource(file));
            inputOptions.put("org.apache.maven.model.io.isStrict", false);
            ModelReader reader = null;
            if (!StringUtilRt.endsWithIgnoreCase((CharSequence)file.getName(), (CharSequence)"xml")) {
                try {
                    Object polyglotManager = this.myContainer.lookup("org.sonatype.maven.polyglot.PolyglotModelManager");
                    if (polyglotManager != null) {
                        Method getReaderFor = polyglotManager.getClass().getMethod("getReaderFor", Map.class);
                        reader = (ModelReader)getReaderFor.invoke(polyglotManager, inputOptions);
                    }
                }
                catch (ComponentLookupException polyglotManager) {
                }
                catch (Throwable e) {
                    MavenServerGlobals.getLogger().warn(e);
                }
            }
            if (reader == null) {
                try {
                    reader = (ModelReader)this.myContainer.lookup(ModelReader.class);
                }
                catch (ComponentLookupException e) {
                    // empty catch block
                }
            }
            if (reader != null) {
                try {
                    Model model = reader.read(file, inputOptions);
                    return Maven3ModelConverter.convertModel((Model)model, null);
                }
                catch (Exception e) {
                    MavenServerGlobals.getLogger().warn((Throwable)e);
                }
            }
        }
        catch (Exception e) {
            MavenServerGlobals.getLogger().warn((Throwable)e);
        }
        return null;
    }

    @NotNull
    public MavenServerResponse<ArrayList<MavenArtifact>> resolveArtifacts(@NotNull LongRunningTaskInput longRunningTaskInput, @NotNull ArrayList<MavenArtifactResolutionRequest> requests, MavenToken token) {
        if (longRunningTaskInput == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(41);
        }
        if (requests == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(42);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        String longRunningTaskId = longRunningTaskInput.getLongRunningTaskId();
        MavenServerOpenTelemetry telemetry = MavenServerOpenTelemetry.from((TelemetryContext)longRunningTaskInput.getTelemetryContext());
        LongRunningTask task = this.newLongRunningTask(longRunningTaskId, requests.size(), (MavenServerConsoleIndicatorWrapper)this.myConsoleWrapper);
        ArrayList<MavenArtifact> artifacts = this.doResolveArtifacts(task, requests);
        telemetry.shutdown();
        MavenServerResponse mavenServerResponse = new MavenServerResponse(artifacts, this.getLongRunningTaskStatus(longRunningTaskId, token));
        MavenServerResponse mavenServerResponse2 = mavenServerResponse;
        if (mavenServerResponse2 == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(43);
        }
        return mavenServerResponse2;
        finally {
            if (task != null) {
                task.close();
            }
        }
    }

    @NotNull
    private ArrayList<MavenArtifact> doResolveArtifacts(@NotNull LongRunningTask task, @NotNull Collection<MavenArtifactResolutionRequest> requests) {
        ArrayList<MavenArtifact> arrayList;
        if (task == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(44);
        }
        if (requests == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(45);
        }
        try {
            ArrayList<MavenArtifact> artifacts = new ArrayList<MavenArtifact>();
            for (MavenArtifactResolutionRequest request : requests) {
                if (task.isCanceled()) break;
                MavenArtifact artifact = this.doResolveArtifact(request.getArtifactInfo(), request.getRemoteRepositories(), request.updateSnapshots(), task.getIndicator());
                artifacts.add(artifact);
                task.incrementFinishedRequests();
            }
            arrayList = artifacts;
        }
        catch (Exception e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
        if (arrayList == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(46);
        }
        return arrayList;
    }

    private MavenArtifact doResolveArtifact(MavenArtifactInfo info, List<MavenRemoteRepository> remoteRepositories, boolean updateSnapshots, MavenServerConsoleIndicatorImpl indicator) {
        Artifact resolved = this.doResolveArtifact(this.createArtifact(info), this.convertRepositories(remoteRepositories), updateSnapshots, indicator);
        return Maven3ModelConverter.convertArtifact((Artifact)resolved, (File)this.getLocalRepositoryFile());
    }

    private Artifact doResolveArtifact(Artifact artifact, List<ArtifactRepository> remoteRepositories, boolean updateSnapshots, MavenServerConsoleIndicatorImpl indicator) {
        try {
            return this.tryResolveArtifact(artifact, remoteRepositories, updateSnapshots, indicator);
        }
        catch (Exception e) {
            MavenServerGlobals.getLogger().info((Throwable)e);
            return artifact;
        }
    }

    private Artifact tryResolveArtifact(@NotNull Artifact artifact, @NotNull List<ArtifactRepository> repos, boolean updateSnapshots, MavenServerConsoleIndicatorImpl indicator) throws ArtifactResolutionException, ArtifactNotFoundException, RemoteException, org.eclipse.aether.resolution.ArtifactResolutionException {
        if (artifact == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(47);
        }
        if (repos == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(48);
        }
        String mavenVersion = this.getMavenVersion();
        this.myImporterSpy.setIndicator((MavenServerConsoleIndicator)indicator);
        if (USE_MVN2_COMPATIBLE_DEPENDENCY_RESOLVING || VersionComparatorUtil.compare((String)mavenVersion, (String)"3.2.5") < 0) {
            DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
            request.setRemoteRepositories(repos);
            try {
                this.getComponent(MavenExecutionRequestPopulator.class).populateFromSettings((MavenExecutionRequest)request, this.myMavenSettings);
                this.getComponent(MavenExecutionRequestPopulator.class).populateDefaults((MavenExecutionRequest)request);
            }
            catch (MavenExecutionRequestPopulationException e) {
                throw new RuntimeException(e);
            }
            this.getComponent(ArtifactResolver.class).resolve(artifact, request.getRemoteRepositories(), this.myLocalRepository);
            return artifact;
        }
        MavenExecutionRequest request = this.createRequest(null, null, null);
        if (updateSnapshots) {
            request.setUpdateSnapshots(true);
        }
        for (ArtifactRepository artifactRepository : repos) {
            request.addRemoteRepository(artifactRepository);
        }
        DefaultMaven maven = (DefaultMaven)this.getComponent(Maven.class);
        RepositorySystemSession repositorySystemSession = maven.newRepositorySession(request);
        this.initLogging(this.myConsoleWrapper);
        RemoteRepositoryManager remoteRepositoryManager = this.getComponent(RemoteRepositoryManager.class);
        org.eclipse.aether.RepositorySystem repositorySystem = this.getComponent(org.eclipse.aether.RepositorySystem.class);
        List repositories = RepositoryUtils.toRepos(repos);
        repositories = remoteRepositoryManager.aggregateRepositories(repositorySystemSession, new ArrayList(), repositories, false);
        ArtifactResult artifactResult = repositorySystem.resolveArtifact(repositorySystemSession, new ArtifactRequest(RepositoryUtils.toArtifact((Artifact)artifact), repositories, null));
        return RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)artifactResult.getArtifact());
    }

    protected abstract void initLogging(Maven3ServerConsoleLogger var1);

    @NotNull
    protected List<ArtifactRepository> convertRepositories(List<MavenRemoteRepository> repositories) {
        List result = this.map2ArtifactRepositories(repositories);
        if (this.getComponent(LegacySupport.class).getRepositorySession() == null) {
            this.myRepositorySystem.injectMirror(result, this.myMavenSettings.getMirrors());
            this.myRepositorySystem.injectProxy(result, this.myMavenSettings.getProxies());
            this.myRepositorySystem.injectAuthentication(result, this.myMavenSettings.getServers());
        }
        List list = result;
        if (list == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(49);
        }
        return list;
    }

    private Artifact createArtifact(MavenArtifactInfo info) {
        return this.getComponent(ArtifactFactory.class).createArtifactWithClassifier(info.getGroupId(), info.getArtifactId(), info.getVersion(), info.getPackaging(), info.getClassifier());
    }

    @NotNull
    public MavenServerResponse<ArrayList<MavenGoalExecutionResult>> executeGoal(@NotNull LongRunningTaskInput longRunningTaskInput, @NotNull ArrayList<MavenGoalExecutionRequest> requests, @NotNull String goal, MavenToken token) {
        if (longRunningTaskInput == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(50);
        }
        if (requests == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(51);
        }
        if (goal == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(52);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        String longRunningTaskId = longRunningTaskInput.getLongRunningTaskId();
        MavenServerOpenTelemetry telemetry = MavenServerOpenTelemetry.from((TelemetryContext)longRunningTaskInput.getTelemetryContext());
        LongRunningTask task = this.newLongRunningTask(longRunningTaskId, requests.size(), (MavenServerConsoleIndicatorWrapper)this.myConsoleWrapper);
        ArrayList<MavenGoalExecutionResult> results = this.executeGoal(task, requests, goal);
        telemetry.shutdown();
        MavenServerResponse mavenServerResponse = new MavenServerResponse(results, this.getLongRunningTaskStatus(longRunningTaskId, token));
        MavenServerResponse mavenServerResponse2 = mavenServerResponse;
        if (mavenServerResponse2 == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(53);
        }
        return mavenServerResponse2;
        finally {
            if (task != null) {
                task.close();
            }
        }
    }

    private ArrayList<MavenGoalExecutionResult> executeGoal(@NotNull LongRunningTask task, @NotNull Collection<MavenGoalExecutionRequest> requests, @NotNull String goal) {
        if (task == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(54);
        }
        if (requests == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(55);
        }
        if (goal == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(56);
        }
        try {
            ArrayList<MavenGoalExecutionResult> results = new ArrayList<MavenGoalExecutionResult>();
            for (MavenGoalExecutionRequest request : requests) {
                if (task.isCanceled()) break;
                MavenGoalExecutionResult result = this.doExecute(request, goal);
                results.add(result);
                task.incrementFinishedRequests();
            }
            return results;
        }
        catch (Exception e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    private MavenGoalExecutionResult doExecute(@NotNull MavenGoalExecutionRequest request, @NotNull String goal) {
        if (request == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(57);
        }
        if (goal == null) {
            Maven3XServerEmbedder.$$$reportNull$$$0(58);
        }
        File file = request.file();
        MavenExplicitProfiles profiles = request.profiles();
        ArrayList activeProfiles = new ArrayList(profiles.getEnabledProfiles());
        ArrayList inactiveProfiles = new ArrayList(profiles.getDisabledProfiles());
        MavenExecutionRequest mavenExecutionRequest = this.createRequest(file, activeProfiles, inactiveProfiles);
        mavenExecutionRequest.setGoals(Collections.singletonList(goal));
        Properties userProperties = request.userProperties();
        mavenExecutionRequest.setUserProperties(userProperties);
        List selectedProjects = request.selectedProjects();
        if (!selectedProjects.isEmpty()) {
            mavenExecutionRequest.setSelectedProjects(selectedProjects);
        }
        MavenExecutionResult executionResult = Maven3XServerEmbedder.safeExecute(mavenExecutionRequest, this.getComponent(Maven.class));
        Maven3ExecutionResult result = new Maven3ExecutionResult(executionResult.getProject(), Maven3XServerEmbedder.filterExceptions(executionResult.getExceptions()));
        return this.createEmbedderExecutionResult(file, result);
    }

    private static MavenExecutionResult safeExecute(MavenExecutionRequest request, Maven maven) {
        MavenLeakDetector detector = new MavenLeakDetector().mark();
        MavenExecutionResult result = maven.execute(request);
        detector.check();
        return result;
    }

    public void release(MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            this.myContainer.dispose();
        }
        catch (Exception e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    protected ArtifactRepository getLocalRepository() {
        return this.myLocalRepository;
    }

    public Properties getSystemProperties() {
        return this.mySystemProperties;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/Maven3XServerEmbedder";
                break;
            }
            case 2: 
            case 7: 
            case 19: 
            case 37: 
            case 41: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "longRunningTaskInput";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inactiveProfiles";
                break;
            }
            case 8: 
            case 11: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToResolve";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customProperties";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelProblems";
                break;
            }
            case 20: 
            case 25: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 21: 
            case 26: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRepositories";
                break;
            }
            case 22: 
            case 27: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managedDependencies";
                break;
            }
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationProcessorPaths";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginResolutionRequests";
                break;
            }
            case 42: 
            case 45: 
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 44: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repos";
                break;
            }
            case 52: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLineOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/Maven3XServerEmbedder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateEffectivePom";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveProjects";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectResolver";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultimoduleProjectDir";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootMessage";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveProcessorPathEntries";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveTransitivelyWithError";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePlugin";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArtifacts";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveArtifacts";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "convertRepositories";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "executeGoal";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "evaluateEffectivePom";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjects";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createProjectResolver";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createRequest";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createEmbedderExecutionResult";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectProblems";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveProcessorPathEntries";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doResolveProcessorEntries";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "convertToDependencies";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "doResolveTransitivelyWithError";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "resolvePlugins";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "resolveArtifacts";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "doResolveArtifacts";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "tryResolveArtifact";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "executeGoal";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PluginResolutionData {
        MavenId mavenPluginId;
        boolean resolveDependencies;
        List<org.apache.maven.model.Dependency> dependencies;
        List<RemoteRepository> remoteRepos;

        private PluginResolutionData(MavenId mavenPluginId, boolean resolveDependencies, List<org.apache.maven.model.Dependency> dependencies, List<RemoteRepository> remoteRepos) {
            this.mavenPluginId = mavenPluginId;
            this.resolveDependencies = resolveDependencies;
            this.remoteRepos = remoteRepos;
            this.dependencies = dependencies;
        }
    }
}

