#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 Allure
version:              0.11.0.0
visibility:           public
id:                   Allure-0.11.0.0-2bC22PJowlZ5etDXq6McGP
key:                  Allure-0.11.0.0-2bC22PJowlZ5etDXq6McGP
license:              AGPL-3.0-or-later
maintainer:           Mikolaj Konarski <mikolaj.konarski@funktory.com>
author:               Andres Loeh, Mikolaj Konarski and others
homepage:             http://allureofthestars.com
synopsis:             Near-future Sci-Fi roguelike and tactical squad combat game
description:
    Allure of the Stars is a near-future Sci-Fi roguelike
    and tactical squad combat game. Binaries and the game manual
    are available at the homepage. You can also try the game out
    in the browser at <http://allureofthestars.com/play>.

    Not a single image in this game. You have to imagine everything
    yourself, like with a book (a grown-up book, without pictures).
    Once you learn to imagine things, though, you can keep exploring
    and mastering the world and making up stories for a long time.

    The game is written in Haskell using the LambdaHack roguelike
    game engine <http://hackage.haskell.org/package/LambdaHack>.
    Please see the changelog file for recent improvements
    and the issue tracker for short-term plans. Long term goals
    are high replayability and auto-balancing through procedural
    content generation and persistent content modification
    based on player behaviour. Contributions are welcome.

    This is a workaround .cabal file, flattened to eliminate
    internal libraries until generating haddocks for them
    is fixed. The original .cabal file is in .cabal.bkp file.

category:             Game
abi:                  b19481468cfa10037077885562c0b471
exposed:              True
exposed-modules:
    Client.UI.Content.Input Client.UI.Content.Screen Content.CaveKind
    Content.FactionKind Content.ItemKind Content.ItemKindActor
    Content.ItemKindBlast Content.ItemKindEmbed Content.ItemKindOrgan
    Content.ItemKindTemporary Content.ModeKind Content.PlaceKind
    Content.RuleKind Content.TileKind
    Implementation.MonadClientImplementation
    Implementation.MonadServerImplementation TieKnot

hidden-modules:       Paths_Allure
import-dirs:          /usr/lib/ghc-9.4.8/site-local/Allure-0.11.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/Allure-0.11.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/Allure-0.11.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/allure
hs-libraries:         HSAllure-0.11.0.0-2bC22PJowlZ5etDXq6McGP
depends:
    LambdaHack-0.11.0.1-3CIVfwR4cwmLMvdLbIzrfc
    async-2.2.5-8OaaAgguhBf8cQN41yeIS0 base-4.17.2.1
    enummapset-0.7.3.0-9zWIGxi4aNL4TAhCKokAxf
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    ghc-compact-0.1.0.0 hsini-0.5.2.2-DcNi4hOQb7Y6L7uqhNIN7p
    optparse-applicative-0.17.1.0-CKO7Hv5HIMoIThZFruc57S
    primitive-0.8.0.0-5TU9coTCbFAF1LmcqkQLR6
    splitmix-0.1.0.5-KIh5vIIkmXD5nd5Z5bT2Ks template-haskell-2.19.0.0
    text-2.0.2 th-lift-instances-0.1.20-44S0PgyFzrn3ocnzbt19xG
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/allure/html/Allure.haddock
haddock-html:         /usr/share/doc/allure/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

