#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.2
visibility:           public
id:                   arch-hs-0.12.0.2-EiTKzYACJ5V5qCq7r3iJxc
key:                  arch-hs-0.12.0.2-EiTKzYACJ5V5qCq7r3iJxc
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  3d79541eda33316e4b805c6b43b063f6
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.2-EiTKzYACJ5V5qCq7r3iJxc
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.2/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-8NUfR4WKqY5H9Ttf0Koorw
    aeson-2.1.2.1-5BFfk7iI7w6HPWzhbIRzqn
    algebraic-graphs-0.7-KhCLIWiNB1l3cJfVhz7djR
    arch-web-0.3.1-JmOry5n9jzS622qsDYPEnQ base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-8kXjnDSt7SWIbXyadQmMao
    conduit-extra-1.3.7-GgIHVySPz3hISDirRf9TTh containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-CJNhJ67w3NJ9ZCcaBLdTi4
    http-client-0.7.18-EyzJQbPJ45W9RPu7xSmNVF
    http-client-tls-0.3.6.4-8ZVhrtbQUCNJsVgPqLCBvc
    megaparsec-9.6.1-LBbcO7GVsOtJwvx1ioFUK2
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-ERJ2P3RZ6V11Os1hKYfETl
    optparse-simple-0.1.1.4-L3r4SR0ZoifFqcUglvqHpv
    polysemy-1.9.2.0-2xhqQ6omeS3BfafFjEXE4N
    prettyprinter-1.7.1-7RzBp6WzYsKH449UzuuntO
    prettyprinter-ansi-terminal-1.1.3-LoL3RNOrI4LLVb0h5b4flD
    servant-client-0.20-GrcqzjUjdvB3IaSZ6QDP4j
    split-0.2.5-9yRmZJdLmWeEyOIWbrT71c
    tar-conduit-0.4.1-7rP9gD00kea7SOMwSUKosS template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

