#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.2
visibility:           public
id:                   arch-hs-0.12.0.2-6D9br1MTA8YqDuMPiITO1
key:                  arch-hs-0.12.0.2-6D9br1MTA8YqDuMPiITO1
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  af47338aefe7fdcf35123b1782efb43e
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.2-6D9br1MTA8YqDuMPiITO1
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.2/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-9HGGTyO9t5E8DUBaQPBda0
    aeson-2.1.2.1-EZ4q40CmD1e6rYIqwxbubT
    algebraic-graphs-0.7-6p4aZY5QAd6H7EVTsRtfsR
    arch-web-0.3.1-FnwzKTLhloiE41U9Cmn6M base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-HPPRf3ag9AHz93zM59Qo5
    conduit-extra-1.3.7-FvyuxdYF6UXGuylyEwQGso containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-5PatboMkr8C4DJsreKlr7u
    http-client-0.7.18-2ofV5QEO18r5DBx66M5AT0
    http-client-tls-0.3.6.4-6wdDSE7a7MH1UuelJ2W96c
    megaparsec-9.6.1-6qeEGREH0fMn1gOMY5ab1
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd
    microlens-th-0.4.3.17-Vfga0HXPTS6SXD3NuXqZ3
    neat-interpolation-0.5.1.4-3LfO6OXzYXU6K77tgevNGF
    optparse-simple-0.1.1.4-5kZOeA0qJz8CnYcKpsx64F
    polysemy-1.9.2.0-F6hPyEXUMx071L8MSDk4jE
    prettyprinter-1.7.1-K49FGRh0RcS7wKSRgaQVIq
    prettyprinter-ansi-terminal-1.1.3-5ygAz6ImaPm6RZS7bXOXnZ
    servant-client-0.20-JwUTqWdty41LPAqh3QwuuF
    split-0.2.5-BnFKgRDhiQY6EGNXY3CRsu
    tar-conduit-0.4.1-7W4zWXeNMnX571s8Mh25QW template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

