#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.1
visibility:           public
id:                   arch-hs-0.12.1-FCGsaIeBQQx4F5uuHKBKyb
key:                  arch-hs-0.12.1-FCGsaIeBQQx4F5uuHKBKyb
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  34e0dddd29b0740fb18753415eea55c7
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.1-FCGsaIeBQQx4F5uuHKBKyb
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1/include
depends:
    Cabal-3.8.1.0 Diff-0.5-5Q1Xtyajup54pAeJMO94Af
    aeson-2.1.2.1-7cfkxE9Bq2x7khGuVuQDC7
    algebraic-graphs-0.7-LcfvSq3iowZAqUvWZeH85t
    arch-web-0.3.2-Gd9fa1S8nVo40wfqGHXG84 base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-RIPQH88pa6HdGnxqZVAxX
    conduit-extra-1.3.8-Wf90Wdd777ELFlunPZvQx containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-uub1gwl9R373tlEtKGUwq
    http-client-0.7.19-JmHmaoQUy1C5oiPZXr15YF
    http-client-tls-0.3.6.4-E28gxMM2RzzxyhHorY0f0
    megaparsec-9.7.0-1c2jPx0UmJAAFouxjMyF3D
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-7cgZ61WU1e86mDJfA93D0Q
    optparse-simple-0.1.1.4-DypyxQGvvZs8xjcVkmG8pl
    polysemy-1.9.2.0-b9KGWiVREZ42iHWz4X7QR
    prettyprinter-1.7.1-DU2dJrN5bRm6Aoduk8wHMr
    prettyprinter-ansi-terminal-1.1.3-7KCj1mL67LzLqfzn0Ykct6
    servant-client-0.20.3.0-AcywA8NbwYUJBu3M6nuMUg
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q
    tar-conduit-0.4.1-IFGnHmYpjoR2s7mNsFnR9n template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

