#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.1
visibility:           public
id:                   arch-hs-0.12.1-2bStQXTh9qtLWfkLi2y8ZD
key:                  arch-hs-0.12.1-2bStQXTh9qtLWfkLi2y8ZD
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  7173ff91d225f743f399c5e633d38cd2
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.1-2bStQXTh9qtLWfkLi2y8ZD
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1/include
depends:
    Cabal-3.8.1.0 Diff-0.5-CFajIZ8dkNLBAcT1NAzb1Z
    aeson-2.1.2.1-AErwMfn2r5g1Pc6FekWoJb
    algebraic-graphs-0.7-BFwbj7lZLYhB3rNcL3oWJR
    arch-web-0.3.2-Ao93gGtzc1TKSvVJfcpKa1 base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-CtNjiY6d9ioJN2CqltSeEi
    conduit-extra-1.3.8-E6affjwsmt94hD5QSBQcbY containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-9qA5xWF8BBZ1jqtTn3pzuL
    http-client-0.7.19-4UbGlDhlNmJ9JhWVX5eNPs
    http-client-tls-0.3.6.4-AVJGLtBIuZakSDpEPaS0o
    megaparsec-9.7.0-ATzV0kIhS1c1WF6GxcAl4n
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-DjLdjHdVtVP78fKYpzdxbC
    optparse-simple-0.1.1.4-L6ouDA8HHcfD9fW2CA8sau
    polysemy-1.9.2.0-Gvy4fjHxfz73TREWw9NIiQ
    prettyprinter-1.7.1-KHTd6ELn8JD9j39b7JIrXU
    prettyprinter-ansi-terminal-1.1.3-1UfbVX11m0EFNFdqWdhwHG
    servant-client-0.20.3.0-EzC0Z6jqyc3EkEqHdtFHjG
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q
    tar-conduit-0.4.1-1WAE5gq7qGLKS8ulWD1B4Q template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

