﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace SecurityHub
{
namespace Model
{
  enum class VulnerabilityFixAvailable
  {
    NOT_SET,
    YES,
    NO,
    PARTIAL
  };

namespace VulnerabilityFixAvailableMapper
{
AWS_SECURITYHUB_API VulnerabilityFixAvailable GetVulnerabilityFixAvailableForName(const Aws::String& name);

AWS_SECURITYHUB_API Aws::String GetNameForVulnerabilityFixAvailable(VulnerabilityFixAvailable value);
} // namespace VulnerabilityFixAvailableMapper
} // namespace Model
} // namespace SecurityHub
} // namespace Aws
