﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/osis/OSIS_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/osis/model/PipelineEndpointConnection.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace OSIS
{
namespace Model
{
  class ListPipelineEndpointConnectionsResult
  {
  public:
    AWS_OSIS_API ListPipelineEndpointConnectionsResult() = default;
    AWS_OSIS_API ListPipelineEndpointConnectionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_OSIS_API ListPipelineEndpointConnectionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>When <code>nextToken</code> is returned, there are more results available.
     * The value of <code>nextToken</code> is a unique pagination token for each page.
     * Make the call again using the returned token to retrieve the next page.</p>
     */
    inline const Aws::String& GetNextToken() const { return m_nextToken; }
    template<typename NextTokenT = Aws::String>
    void SetNextToken(NextTokenT&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::forward<NextTokenT>(value); }
    template<typename NextTokenT = Aws::String>
    ListPipelineEndpointConnectionsResult& WithNextToken(NextTokenT&& value) { SetNextToken(std::forward<NextTokenT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A list of pipeline endpoint connections.</p>
     */
    inline const Aws::Vector<PipelineEndpointConnection>& GetPipelineEndpointConnections() const { return m_pipelineEndpointConnections; }
    template<typename PipelineEndpointConnectionsT = Aws::Vector<PipelineEndpointConnection>>
    void SetPipelineEndpointConnections(PipelineEndpointConnectionsT&& value) { m_pipelineEndpointConnectionsHasBeenSet = true; m_pipelineEndpointConnections = std::forward<PipelineEndpointConnectionsT>(value); }
    template<typename PipelineEndpointConnectionsT = Aws::Vector<PipelineEndpointConnection>>
    ListPipelineEndpointConnectionsResult& WithPipelineEndpointConnections(PipelineEndpointConnectionsT&& value) { SetPipelineEndpointConnections(std::forward<PipelineEndpointConnectionsT>(value)); return *this;}
    template<typename PipelineEndpointConnectionsT = PipelineEndpointConnection>
    ListPipelineEndpointConnectionsResult& AddPipelineEndpointConnections(PipelineEndpointConnectionsT&& value) { m_pipelineEndpointConnectionsHasBeenSet = true; m_pipelineEndpointConnections.emplace_back(std::forward<PipelineEndpointConnectionsT>(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const { return m_requestId; }
    template<typename RequestIdT = Aws::String>
    void SetRequestId(RequestIdT&& value) { m_requestIdHasBeenSet = true; m_requestId = std::forward<RequestIdT>(value); }
    template<typename RequestIdT = Aws::String>
    ListPipelineEndpointConnectionsResult& WithRequestId(RequestIdT&& value) { SetRequestId(std::forward<RequestIdT>(value)); return *this;}
    ///@}
  private:

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet = false;

    Aws::Vector<PipelineEndpointConnection> m_pipelineEndpointConnections;
    bool m_pipelineEndpointConnectionsHasBeenSet = false;

    Aws::String m_requestId;
    bool m_requestIdHasBeenSet = false;
  };

} // namespace Model
} // namespace OSIS
} // namespace Aws
