﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/sso-admin/SSOAdmin_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SSOAdmin {
namespace Model {
class GetApplicationAccessScopeResult {
 public:
  AWS_SSOADMIN_API GetApplicationAccessScopeResult() = default;
  AWS_SSOADMIN_API GetApplicationAccessScopeResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SSOADMIN_API GetApplicationAccessScopeResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The name of the access scope that can be used with the authorized
   * targets.</p>
   */
  inline const Aws::String& GetScope() const { return m_scope; }
  template <typename ScopeT = Aws::String>
  void SetScope(ScopeT&& value) {
    m_scopeHasBeenSet = true;
    m_scope = std::forward<ScopeT>(value);
  }
  template <typename ScopeT = Aws::String>
  GetApplicationAccessScopeResult& WithScope(ScopeT&& value) {
    SetScope(std::forward<ScopeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array of authorized targets associated with this access scope.</p>
   */
  inline const Aws::Vector<Aws::String>& GetAuthorizedTargets() const { return m_authorizedTargets; }
  template <typename AuthorizedTargetsT = Aws::Vector<Aws::String>>
  void SetAuthorizedTargets(AuthorizedTargetsT&& value) {
    m_authorizedTargetsHasBeenSet = true;
    m_authorizedTargets = std::forward<AuthorizedTargetsT>(value);
  }
  template <typename AuthorizedTargetsT = Aws::Vector<Aws::String>>
  GetApplicationAccessScopeResult& WithAuthorizedTargets(AuthorizedTargetsT&& value) {
    SetAuthorizedTargets(std::forward<AuthorizedTargetsT>(value));
    return *this;
  }
  template <typename AuthorizedTargetsT = Aws::String>
  GetApplicationAccessScopeResult& AddAuthorizedTargets(AuthorizedTargetsT&& value) {
    m_authorizedTargetsHasBeenSet = true;
    m_authorizedTargets.emplace_back(std::forward<AuthorizedTargetsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetApplicationAccessScopeResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_scope;
  bool m_scopeHasBeenSet = false;

  Aws::Vector<Aws::String> m_authorizedTargets;
  bool m_authorizedTargetsHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SSOAdmin
}  // namespace Aws
