﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/quicksight/QuickSightRequest.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>

#include <utility>

namespace Aws {
namespace QuickSight {
namespace Model {

/**
 */
class DescribeDashboardSnapshotJobRequest : public QuickSightRequest {
 public:
  AWS_QUICKSIGHT_API DescribeDashboardSnapshotJobRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeDashboardSnapshotJob"; }

  AWS_QUICKSIGHT_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The ID of the Amazon Web Services account that the dashboard snapshot job is
   * executed in.</p>
   */
  inline const Aws::String& GetAwsAccountId() const { return m_awsAccountId; }
  inline bool AwsAccountIdHasBeenSet() const { return m_awsAccountIdHasBeenSet; }
  template <typename AwsAccountIdT = Aws::String>
  void SetAwsAccountId(AwsAccountIdT&& value) {
    m_awsAccountIdHasBeenSet = true;
    m_awsAccountId = std::forward<AwsAccountIdT>(value);
  }
  template <typename AwsAccountIdT = Aws::String>
  DescribeDashboardSnapshotJobRequest& WithAwsAccountId(AwsAccountIdT&& value) {
    SetAwsAccountId(std::forward<AwsAccountIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the dashboard that you have started a snapshot job for.</p>
   */
  inline const Aws::String& GetDashboardId() const { return m_dashboardId; }
  inline bool DashboardIdHasBeenSet() const { return m_dashboardIdHasBeenSet; }
  template <typename DashboardIdT = Aws::String>
  void SetDashboardId(DashboardIdT&& value) {
    m_dashboardIdHasBeenSet = true;
    m_dashboardId = std::forward<DashboardIdT>(value);
  }
  template <typename DashboardIdT = Aws::String>
  DescribeDashboardSnapshotJobRequest& WithDashboardId(DashboardIdT&& value) {
    SetDashboardId(std::forward<DashboardIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the job to be described. The job ID is set when you start a new job
   * with a <code>StartDashboardSnapshotJob</code> API call.</p>
   */
  inline const Aws::String& GetSnapshotJobId() const { return m_snapshotJobId; }
  inline bool SnapshotJobIdHasBeenSet() const { return m_snapshotJobIdHasBeenSet; }
  template <typename SnapshotJobIdT = Aws::String>
  void SetSnapshotJobId(SnapshotJobIdT&& value) {
    m_snapshotJobIdHasBeenSet = true;
    m_snapshotJobId = std::forward<SnapshotJobIdT>(value);
  }
  template <typename SnapshotJobIdT = Aws::String>
  DescribeDashboardSnapshotJobRequest& WithSnapshotJobId(SnapshotJobIdT&& value) {
    SetSnapshotJobId(std::forward<SnapshotJobIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_awsAccountId;
  bool m_awsAccountIdHasBeenSet = false;

  Aws::String m_dashboardId;
  bool m_dashboardIdHasBeenSet = false;

  Aws::String m_snapshotJobId;
  bool m_snapshotJobIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
