#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 clash-ghc
version:              1.8.2
visibility:           public
id:                   clash-ghc-1.8.2-FHCFgUkfvxuLrw5ateqSW9
key:                  clash-ghc-1.8.2-FHCFgUkfvxuLrw5ateqSW9
license:              BSD-2-Clause
copyright:
    Copyright © 2012-2016, University of Twente,
    2016-2017, Myrtle Software Ltd,
    2017-2019, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - GHC frontend

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * Clash Compiler binary using GHC/Haskell as a frontend


    Prelude library: <https://hackage.haskell.org/package/clash-prelude>

category:             Hardware
abi:                  ca5c9c3a16b847ace936a3a59d94159a
exposed:              True
exposed-modules:
    Clash.GHC.Evaluator Clash.GHC.Evaluator.Primitive
    Clash.GHC.GenerateBindings Clash.GHC.LoadModules
    Clash.GHC.NetlistTypes Clash.GHC.PartialEval
    Clash.GHC.PartialEval.Eval Clash.GHC.PartialEval.Primitive
    Clash.GHC.PartialEval.Quote Clash.GHCi.Common Clash.Main

hidden-modules:
    Clash.GHCi.Leak Clash.GHCi.UI Clash.GHCi.UI.Info
    Clash.GHCi.UI.Monad Clash.GHC.ClashFlags Clash.GHC.GHC2Core
    Clash.GHC.LoadInterfaceFiles Clash.GHC.Util Data.Text.Extra
    Paths_clash_ghc Clash.GHCi.Util Clash.GHCi.UI.Tags

import-dirs:          /usr/lib/ghc-9.4.8/site-local/clash-ghc-1.8.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/clash-ghc-1.8.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/clash-ghc-1.8.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/clash-ghc
hs-libraries:         HSclash-ghc-1.8.2-FHCFgUkfvxuLrw5ateqSW9
depends:
    Cabal-3.8.1.0 array-0.5.4.0 base-4.17.2.1 bytestring-0.11.5.3
    clash-lib-1.8.2-6aiPD6MH0Z58k2WxMR11E8
    clash-prelude-1.8.2-E0V1YoYZVpy40bZEwPyWHQ containers-0.6.7
    data-binary-ieee754-0.4.4-3K4wyZ8KRa1CgKftL8GYsk deepseq-1.4.8.0
    directory-1.3.7.1 exceptions-0.10.5
    extra-1.7.16-3MpJB5o0ESB1pjz4ZT9XVu filepath-1.4.2.2 ghc-9.4.8
    ghc-bignum-1.3 ghc-boot-9.4.8 ghc-prim-0.9.1
    ghc-typelits-extra-0.4.5-D1n47uTbxarkqzZKa2gou
    ghc-typelits-knownnat-0.7.10-8miUgVWxFebDgeEM6vOfl0
    ghc-typelits-natnormalise-0.7.10-JoWgPRPJIpm1tBiDWtMzH0 ghci-9.4.8
    hashable-1.4.4.0-AmJtI56ndXc1GvGfBNNgwb haskeline-0.8.2
    lens-5.3.1-LF4jCoE0w776e2gq32lhyl mtl-2.2.2
    primitive-0.9.1.0-IHF3DoB9Qq2KNGfApZUSXg process-1.6.18.0
    reflection-2.1.9-8jVa02izI7IBNQmBZ6vQzn
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV
    string-interpolate-0.3.4.0-GUhOL39uhAyKDrcIRsMINf
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 uniplate-1.6.13-Gp4QETVlMcq98QRy3s343D
    unix-2.7.3 unordered-containers-0.2.20-3NcLl7S6t7kAuh7l4Ieeoo
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15
    vector-0.13.2.0-CQ8QMV1t4PN5YFZtNXivGS

haddock-interfaces:   /usr/share/doc/clash-ghc/html/clash-ghc.haddock
haddock-html:         /usr/share/doc/clash-ghc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

