"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IsolatedCircuitError = void 0;
const BrokenCircuitError_1 = require("./BrokenCircuitError");
class IsolatedCircuitError extends BrokenCircuitError_1.BrokenCircuitError {
    /**
     * Exception thrown from {@link CircuitBreakerPolicy.execute} when the
     * circuit breaker is open.
     */
    constructor() {
        super(`Execution prevented because the circuit breaker is open`);
        this.isIsolatedCircuitError = true;
    }
}
exports.IsolatedCircuitError = IsolatedCircuitError;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/e3550cfac4b63ca4eafca7b601f0d2885817fd1f/node_modules/cockatiel/dist/errors/IsolatedCircuitError.js.map