// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
import { credentialLogger, formatError } from "../util/logging.js";
const BrowserNotSupportedError = new Error("AzureDeveloperCliCredential is not supported in the browser.");
const logger = credentialLogger("AzureDeveloperCliCredential");
/**
 * This credential will use the currently logged-in user login information
 * via the Azure Developer CLI ('azd') commandline tool.
 */
export class AzureDeveloperCliCredential {
    /**
     * Only available in Node.js
     */
    constructor() {
        logger.info(formatError("", BrowserNotSupportedError));
        throw BrowserNotSupportedError;
    }
    getToken() {
        logger.getToken.info(formatError("", BrowserNotSupportedError));
        throw BrowserNotSupportedError;
    }
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/6f17636121051a53c88d3e605c491d22af2ba755/node_modules/@azure/identity/dist/browser/credentials/azureDeveloperCliCredential-browser.mjs.map