/*! @azure/msal-browser v4.22.1 2025-09-09 */
'use strict';
import { CustomAuthError } from './CustomAuthError.mjs';

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
class NoCachedAccountFoundError extends CustomAuthError {
    constructor(correlationId) {
        super("no_cached_account_found", "No account found in the cache", correlationId);
        Object.setPrototypeOf(this, NoCachedAccountFoundError.prototype);
    }
}

export { NoCachedAccountFoundError };
//# sourceMappingURL=NoCachedAccountFoundError.mjs.map
