/*! @azure/msal-browser v4.24.1 2025-09-30 */
'use strict';
import { SignInSubmitPasswordError } from '../error_type/SignInError.mjs';
import { SignInCompletedState } from '../state/SignInCompletedState.mjs';
import { SignInFailedState } from '../state/SignInFailedState.mjs';
import { AuthFlowResultBase } from '../../../core/auth_flow/AuthFlowResultBase.mjs';
import { AuthMethodRegistrationRequiredState } from '../../../core/auth_flow/jit/state/AuthMethodRegistrationState.mjs';

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/*
 * Result of a sign-in submit password operation.
 */
class SignInSubmitPasswordResult extends AuthFlowResultBase {
    static createWithError(error) {
        const result = new SignInSubmitPasswordResult(new SignInFailedState());
        result.error = new SignInSubmitPasswordError(SignInSubmitPasswordResult.createErrorData(error));
        return result;
    }
    /**
     * Checks if the result is in a failed state.
     */
    isFailed() {
        return this.state instanceof SignInFailedState;
    }
    /**
     * Checks if the result is in a completed state.
     */
    isCompleted() {
        return this.state instanceof SignInCompletedState;
    }
    /**
     * Checks if the result requires authentication method registration.
     * @warning This API is experimental. It may be changed in the future without notice. Do not use in production applications.
     */
    isAuthMethodRegistrationRequired() {
        return this.state instanceof AuthMethodRegistrationRequiredState;
    }
}

export { SignInSubmitPasswordResult };
//# sourceMappingURL=SignInSubmitPasswordResult.mjs.map
