/*! @azure/msal-browser v4.25.0 2025-10-09 */
'use strict';
import { AuthFlowResultBase } from '../../AuthFlowResultBase.mjs';
import { MfaSubmitChallengeError } from '../error_type/MfaError.mjs';
import { MfaCompletedState } from '../state/MfaCompletedState.mjs';
import { MfaFailedState } from '../state/MfaFailedState.mjs';

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Result of submitting an MFA challenge.
 */
class MfaSubmitChallengeResult extends AuthFlowResultBase {
    /**
     * Creates an MfaSubmitChallengeResult with an error.
     * @param error The error that occurred.
     * @returns The MfaSubmitChallengeResult with error.
     */
    static createWithError(error) {
        const result = new MfaSubmitChallengeResult(new MfaFailedState());
        result.error = new MfaSubmitChallengeError(MfaSubmitChallengeResult.createErrorData(error));
        return result;
    }
    /**
     * Checks if the MFA flow is completed successfully.
     * @returns true if completed, false otherwise.
     * @warning This API is experimental. It may be changed in the future without notice. Do not use in production applications.
     */
    isCompleted() {
        return this.state instanceof MfaCompletedState;
    }
    /**
     * Checks if the result is in a failed state.
     * @returns true if the result is failed, false otherwise.
     * @warning This API is experimental. It may be changed in the future without notice. Do not use in production applications.
     */
    isFailed() {
        return this.state instanceof MfaFailedState;
    }
}

export { MfaSubmitChallengeResult };
//# sourceMappingURL=MfaSubmitChallengeResult.mjs.map
