#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 cryptol
version:              3.2.0
visibility:           public
id:                   cryptol-3.2.0-AEhgjobvDys1E1luV6mazF
key:                  cryptol-3.2.0-AEhgjobvDys1E1luV6mazF
license:              BSD-3-Clause
copyright:            2013-2022 Galois Inc.
maintainer:           cryptol@galois.com
author:               Galois, Inc.
homepage:             http://www.cryptol.net/
synopsis:             Cryptol: The Language of Cryptography
description:
    Cryptol is a domain-specific language for specifying cryptographic algorithms. A Cryptol implementation of an algorithm resembles its mathematical specification more closely than an implementation in a general purpose language. For more, see <http://www.cryptol.net/>.

category:             Language
abi:                  1a87c45d49d3acd8cca67a6169cd48d8
exposed:              True
exposed-modules:
    Cryptol.AES Cryptol.Backend Cryptol.Backend.Arch
    Cryptol.Backend.Concrete Cryptol.Backend.FFI
    Cryptol.Backend.FFI.Error Cryptol.Backend.FloatHelpers
    Cryptol.Backend.Monad Cryptol.Backend.SBV Cryptol.Backend.SeqMap
    Cryptol.Backend.What4 Cryptol.Backend.WordValue Cryptol.Eval
    Cryptol.Eval.Concrete Cryptol.Eval.Env Cryptol.Eval.FFI
    Cryptol.Eval.FFI.GenHeader Cryptol.Eval.Generic Cryptol.Eval.Prims
    Cryptol.Eval.Reference Cryptol.Eval.SBV Cryptol.Eval.Type
    Cryptol.Eval.Value Cryptol.Eval.What4 Cryptol.F2
    Cryptol.IR.FreeVars Cryptol.IR.TraverseNames Cryptol.ModuleSystem
    Cryptol.ModuleSystem.Base Cryptol.ModuleSystem.Binds
    Cryptol.ModuleSystem.Env Cryptol.ModuleSystem.Exports
    Cryptol.ModuleSystem.Fingerprint Cryptol.ModuleSystem.Interface
    Cryptol.ModuleSystem.Monad Cryptol.ModuleSystem.Name
    Cryptol.ModuleSystem.Names Cryptol.ModuleSystem.NamingEnv
    Cryptol.ModuleSystem.NamingEnv.Types Cryptol.ModuleSystem.Renamer
    Cryptol.ModuleSystem.Renamer.Error
    Cryptol.ModuleSystem.Renamer.ImplicitImports
    Cryptol.ModuleSystem.Renamer.Imports
    Cryptol.ModuleSystem.Renamer.Monad Cryptol.Parser
    Cryptol.Parser.AST Cryptol.Parser.ExpandPropGuards
    Cryptol.Parser.Layout Cryptol.Parser.Lexer Cryptol.Parser.Name
    Cryptol.Parser.Names Cryptol.Parser.NoInclude Cryptol.Parser.NoPat
    Cryptol.Parser.Position Cryptol.Parser.Selector
    Cryptol.Parser.Token Cryptol.Parser.Unlit Cryptol.Parser.Utils
    Cryptol.PrimeEC Cryptol.REPL.Browse Cryptol.REPL.Command
    Cryptol.REPL.Help Cryptol.REPL.Monad Cryptol.REPL.Trie Cryptol.SHA
    Cryptol.Symbolic Cryptol.Symbolic.SBV Cryptol.Symbolic.What4
    Cryptol.Testing.Random Cryptol.Transform.MonoValues
    Cryptol.Transform.Specialize Cryptol.TypeCheck
    Cryptol.TypeCheck.AST Cryptol.TypeCheck.Default
    Cryptol.TypeCheck.Error Cryptol.TypeCheck.FFI
    Cryptol.TypeCheck.FFI.Error Cryptol.TypeCheck.FFI.FFIType
    Cryptol.TypeCheck.Infer Cryptol.TypeCheck.InferTypes
    Cryptol.TypeCheck.Instantiate Cryptol.TypeCheck.Interface
    Cryptol.TypeCheck.Kind Cryptol.TypeCheck.Module
    Cryptol.TypeCheck.ModuleBacktickInstance
    Cryptol.TypeCheck.ModuleInstance Cryptol.TypeCheck.Monad
    Cryptol.TypeCheck.PP Cryptol.TypeCheck.Parseable
    Cryptol.TypeCheck.Sanity Cryptol.TypeCheck.SimpType
    Cryptol.TypeCheck.SimpleSolver Cryptol.TypeCheck.Solve
    Cryptol.TypeCheck.Solver.Class Cryptol.TypeCheck.Solver.Improve
    Cryptol.TypeCheck.Solver.InfNat Cryptol.TypeCheck.Solver.Numeric
    Cryptol.TypeCheck.Solver.Numeric.Fin
    Cryptol.TypeCheck.Solver.Numeric.Interval
    Cryptol.TypeCheck.Solver.SMT Cryptol.TypeCheck.Solver.Selector
    Cryptol.TypeCheck.Solver.Types Cryptol.TypeCheck.Solver.Utils
    Cryptol.TypeCheck.Subst Cryptol.TypeCheck.TCon
    Cryptol.TypeCheck.Type Cryptol.TypeCheck.TypeMap
    Cryptol.TypeCheck.TypeOf Cryptol.TypeCheck.TypePat
    Cryptol.TypeCheck.Unify Cryptol.Utils.Benchmark Cryptol.Utils.Debug
    Cryptol.Utils.Fixity Cryptol.Utils.Ident Cryptol.Utils.Logger
    Cryptol.Utils.Misc Cryptol.Utils.PP Cryptol.Utils.Panic
    Cryptol.Utils.Patterns Cryptol.Utils.RecordMap Cryptol.Utils.Types
    Cryptol.Version

hidden-modules:
    Cryptol.Parser.LexerUtils Cryptol.Parser.ParserUtils
    Cryptol.Prelude GHC.Num.Compat Paths_cryptol GitRev

import-dirs:          /usr/lib/ghc-9.4.8/site-local/cryptol-3.2.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/cryptol-3.2.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/cryptol-3.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/cryptol
hs-libraries:         HScryptol-3.2.0-AEhgjobvDys1E1luV6mazF
depends:
    GraphSCC-1.0.4-BvH3gdGqztj6roihacPJAg
    MemoTrie-0.6.11-8JfEEY2v8XDAeVE1RRpCUl
    arithmoi-0.13.1.0-Jcc6ZDQRdA2LdrdRiXXxm0 array-0.5.4.0
    async-2.2.5-BcqMz9kSLpQJiwvDzQjiwa base-4.17.2.1
    base-compat-0.13.0-4bY7VGgUDQwFnN0OMsXbDp
    bv-sized-1.0.6-3rMJ6YsZ0fIEHuML5CtyjC bytestring-0.11.5.3
    containers-0.6.7
    criterion-measurement-0.2.3.0-G5k9TxLxHBB2gpF71gjwPg
    cryptohash-sha1-0.11.101.0-27F69yLuQim9xJ5ZXXesJa deepseq-1.4.8.0
    directory-1.3.7.1 exceptions-0.10.5
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    ghc-bignum-1.3 ghc-prim-0.9.1 gitrev-1.3.1-A894QJs696v2EtFduMnCKp
    hgmp-0.1.2.1-65QhFZU08GZ6ZjZ208y4Rh
    language-c99-0.2.0-I2YO1ITQKgi7h1b2QKXgRh
    language-c99-simple-0.3.0-LtsnH0LVnu56Mhd4fxlDo
    libBF-0.6.6-52pO3yoPXEP7z0kHAaKsLo
    libffi-0.2.1-DPsLfzr2gvt1V2FBULxP58
    monad-control-1.0.3.1-A6UHjJX2HGtJRyc7xUQpzx
    monadLib-3.10.3-9u69WCWPr5d93B1By2kxXa mtl-2.2.2
    panic-0.4.0.1-3HuynR94lzrCKtPGBGvV9o
    parameterized-utils-2.1.10.0-FZIbLyYUQWfLipp8gHPdru pretty-1.1.3.6
    pretty-show-1.10-Ey6CADemQl3EFi7OIHqHDp
    prettyprinter-1.7.1-K25tjwTKXuP4KBelsyCegB process-1.6.18.0
    sbv-10.2-DLejj3hvPUb5Cydlu8ovjQ
    simple-smt-0.9.8-GxJMYuz27wdJmfDJ6DG7cL stm-2.5.1.0
    strict-0.5-IvjGD3Xj8OA9AWKKyQ3ATf text-2.0.2
    tf-random-0.5-EopLsqkrMN2B7honVq5AME time-1.12.2
    transformers-base-0.4.6-7kB1pwF0Wr6CXgFXZQ42bw unix-2.7.3
    vector-0.13.2.0-FNdsFzivQrc5gVfjRMxS7n
    what4-1.6-GYUM1ePOYDpFCBEqQJ4oPK

haddock-interfaces:   /usr/share/doc/cryptol/html/cryptol.haddock
haddock-html:         /usr/share/doc/cryptol/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

