/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai;

import java.time.LocalDateTime;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.utils.CommonUtils;

public class AIMessage {
    @NotNull
    private final AIMessageType role;
    @NotNull
    private final String content;
    @Nullable
    private final String displayMessage;
    @NotNull
    private final LocalDateTime time;

    public AIMessage(@NotNull AIMessageType role, @NotNull String content, @Nullable String displayMessage, @NotNull LocalDateTime time) {
        this.role = role;
        this.content = content;
        this.displayMessage = displayMessage;
        this.time = time;
    }

    @NotNull
    public static AIMessage systemMessage(@NotNull String message) {
        return new AIMessage(AIMessageType.SYSTEM, message);
    }

    @NotNull
    public static AIMessage userMessage(@NotNull String message) {
        return new AIMessage(AIMessageType.USER, message);
    }

    @NotNull
    public static AIMessage assistantMessage(@NotNull String message) {
        return new AIMessage(AIMessageType.ASSISTANT, message);
    }

    @NotNull
    public static AIMessage errorMessage(@NotNull Throwable throwable) {
        return new AIMessage(AIMessageType.ERROR, CommonUtils.toString((Object)CommonUtils.getAllExceptionMessages((Throwable)throwable), (String)"Unknown error"));
    }

    @NotNull
    public static AIMessage userAutoMessage(@NotNull String prompt, @NotNull String uiMessage) {
        return new AIMessage(AIMessageType.USER, prompt, uiMessage, LocalDateTime.now());
    }

    public AIMessage(@NotNull AIMessageType role, @NotNull String content) {
        this(role, content, content, LocalDateTime.now());
    }

    public String toString() {
        return "Message (" + String.valueOf((Object)this.role) + "): " + this.content;
    }

    public boolean isAutoGenerated() {
        return this.displayMessage != null && !CommonUtils.equalObjects((Object)this.displayMessage, (Object)this.content);
    }

    public String getDisplayMessage() {
        return this.displayMessage != null ? this.displayMessage : this.content;
    }

    public String getRawDisplayMessage() {
        return this.displayMessage;
    }

    @NotNull
    public AIMessageType getRole() {
        return this.role;
    }

    @NotNull
    public String getContent() {
        return this.content;
    }

    @NotNull
    public LocalDateTime getTime() {
        return this.time;
    }

    public AIMessage withContent(String newContent) {
        return new AIMessage(this.role, newContent, this.displayMessage, this.time);
    }
}

