/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.model.DBPExternalFileManager;
import org.jkiss.dbeaver.model.app.DBACertificateStorage;
import org.jkiss.dbeaver.model.app.DBPApplicationController;
import org.jkiss.dbeaver.model.app.DBPApplicationDesktop;
import org.jkiss.dbeaver.model.app.DBPGlobalEventManager;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPPlatformLanguage;
import org.jkiss.dbeaver.model.app.DBPPlatformLanguageManager;
import org.jkiss.dbeaver.model.app.DBPWorkspaceDesktop;
import org.jkiss.dbeaver.model.impl.app.BaseApplicationImpl;
import org.jkiss.dbeaver.model.impl.app.DefaultCertificateStorage;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DesktopNavigatorModel;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.model.qm.QMRegistry;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.model.runtime.features.DBRFeatureRegistry;
import org.jkiss.dbeaver.registry.BasePlatformImpl;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.GlobalEventManagerImpl;
import org.jkiss.dbeaver.registry.language.PlatformLanguageRegistry;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.runtime.SecurityProviderUtils;
import org.jkiss.dbeaver.runtime.qm.QMLogFileWriter;
import org.jkiss.dbeaver.runtime.qm.QMRegistryImpl;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.CommonUtils;

public class DesktopPlatform
extends BasePlatformImpl
implements DBPPlatformDesktop,
DBPPlatformLanguageManager {
    public static final String PLUGIN_ID = "org.jkiss.dbeaver.core";
    public static final String DBEAVER_DATA_DIR = "DBeaverData";
    private static final String TEMP_PROJECT_NAME = ".dbeaver-temp";
    private static final String DBEAVER_CONFIG_FOLDER = "settings";
    private static final String DBEAVER_CONFIG_FILE = "global-settings.ini";
    private static final String DBEAVER_PROP_LANGUAGE = "nl";
    private static final Log log = Log.getLog(DesktopPlatform.class);
    static DesktopPlatform instance;
    private static volatile boolean isClosing;
    private Path tempFolder;
    private DBPWorkspaceDesktop workspace;
    private QMRegistryImpl queryManager;
    private QMLogFileWriter qmLogWriter;
    private DBACertificateStorage certificateStorage;
    private DBPPlatformLanguage language;
    private volatile boolean workbenchStarted;

    static {
        isClosing = false;
    }

    public static boolean isStandalone() {
        return BaseApplicationImpl.getInstance().isStandalone();
    }

    public static boolean isClosing() {
        if (isClosing) {
            return true;
        }
        if (!PlatformUI.isWorkbenchRunning()) {
            return false;
        }
        return false;
    }

    static void setClosing(boolean closing) {
        isClosing = closing;
    }

    public DesktopPlatform() {
        instance = this;
    }

    protected void initialize() {
        long startTime = System.currentTimeMillis();
        log.debug((Object)"Initialize desktop platform...");
        this.language = PlatformLanguageRegistry.getInstance().getLanguage(Locale.getDefault());
        if (this.language == null) {
            log.debug((Object)("Language for locale '" + String.valueOf(Locale.getDefault()) + "' not found. Use default."));
            this.language = PlatformLanguageRegistry.getInstance().getLanguage(Locale.ENGLISH);
        }
        if (this.getPreferenceStore().getBoolean("security.jce.bc")) {
            SecurityProviderUtils.registerSecurityProvider();
        }
        this.certificateStorage = new DefaultCertificateStorage(RuntimeUtils.getPluginStateLocation((Plugin)DBeaverActivator.getInstance()).resolve("security"));
        this.getApplication().beforeWorkspaceInitialization();
        this.workspace = this.getApplication().createWorkspace((DBPPlatform)this);
        this.workspace.initializeProjects();
        QMUtils.initApplication((DBPPlatform)this);
        this.queryManager = new QMRegistryImpl();
        this.qmLogWriter = new QMLogFileWriter();
        this.queryManager.registerMetaListener((QMMetaListener)this.qmLogWriter);
        super.initialize();
        DBRFeatureRegistry.getInstance().startTracking();
        log.debug((Object)("Platform initialized (" + (System.currentTimeMillis() - startTime) + "ms)"));
    }

    protected DBNModel createNavigatorModel() {
        return new DesktopNavigatorModel((DBPPlatform)this, null);
    }

    public synchronized void dispose() {
        long startTime = System.currentTimeMillis();
        log.debug((Object)"Shutdown desktop platform...");
        DesktopPlatform.setClosing(true);
        DBPApplicationDesktop application = this.getApplication();
        if (application instanceof DBPApplicationController) {
            ((DBPApplicationController)application).setHeadlessMode(true);
        }
        DBRFeatureRegistry.getInstance().endTracking();
        super.dispose();
        if (this.workspace != null) {
            this.workspace.dispose();
            this.workspace = null;
        }
        if (this.qmLogWriter != null) {
            this.queryManager.unregisterMetaListener((QMMetaListener)this.qmLogWriter);
            this.qmLogWriter.dispose();
            this.qmLogWriter = null;
        }
        if (this.queryManager != null) {
            this.queryManager.dispose();
        }
        DataSourceProviderRegistry.dispose();
        if (DesktopPlatform.isStandalone() && this.workspace != null && !application.isExclusiveMode()) {
            try {
                this.workspace.save((DBRProgressMonitor)new LoggingProgressMonitor(log));
            }
            catch (DBException ex) {
                log.error((Object)"Can not save workspace", (Throwable)ex);
            }
        }
        if (this.tempFolder != null) {
            if (!ContentUtils.deleteFileRecursive((Path)this.tempFolder)) {
                log.warn((Object)("Can not delete temp folder '" + String.valueOf(this.tempFolder) + "'"));
            }
            this.tempFolder = null;
        }
        instance = null;
        System.gc();
        log.debug((Object)("Platform shutdown completed (" + (System.currentTimeMillis() - startTime) + "ms)"));
        new Thread(() -> {
            RuntimeUtils.pause((int)10000);
            System.out.println("App shutdown was halted. Force system shutdown!");
            System.exit(-2);
        }).start();
    }

    protected Plugin getProductPlugin() {
        return DBeaverActivator.getInstance();
    }

    @NotNull
    public DBPWorkspaceDesktop getWorkspace() {
        return this.workspace;
    }

    @NotNull
    public DBPApplicationDesktop getApplication() {
        return (DBPApplicationDesktop)BaseApplicationImpl.getInstance();
    }

    @NotNull
    public DBPPlatformLanguage getLanguage() {
        return this.language;
    }

    public void setPlatformLanguage(@NotNull DBPPlatformLanguage language) throws DBException {
        if (CommonUtils.equalObjects((Object)language, (Object)this.language)) {
            return;
        }
        try {
            this.setConfigProperty(DBEAVER_PROP_LANGUAGE, language.getCode());
            this.language = language;
            this.getPreferenceStore().setValue("platform.language", language.getCode());
        }
        catch (IOException e) {
            throw new DBException("Can't change platform language: " + e.getMessage(), (Throwable)e);
        }
    }

    private void setConfigProperty(@NotNull String key, @Nullable String value) throws IOException {
        Object var7_9;
        Throwable throwable;
        Path root = Path.of(RuntimeUtils.getWorkingDirectory((String)DBEAVER_DATA_DIR), new String[0]);
        Path file = root.resolve(DBEAVER_CONFIG_FOLDER).resolve(DBEAVER_CONFIG_FILE);
        Properties properties = new Properties();
        if (Files.exists(file, new LinkOption[0])) {
            throwable = null;
            var7_9 = null;
            try (BufferedReader reader = Files.newBufferedReader(file);){
                properties.load(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (value != null) {
            properties.setProperty(key, value);
        } else {
            properties.remove(key);
        }
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        throwable = null;
        var7_9 = null;
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            properties.store(writer, "DBeaver configuration");
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @NotNull
    public QMRegistry getQueryManager() {
        return this.queryManager;
    }

    @NotNull
    public DBPGlobalEventManager getGlobalEventManager() {
        return GlobalEventManagerImpl.getInstance();
    }

    @NotNull
    public DBPPreferenceStore getPreferenceStore() {
        return this.getApplication().getPreferenceStore();
    }

    @NotNull
    public DBACertificateStorage getCertificateStorage() {
        return this.certificateStorage;
    }

    @NotNull
    public DBPExternalFileManager getExternalFileManager() {
        return this.workspace;
    }

    public boolean isWorkbenchStarted() {
        return this.workbenchStarted || !this.getApplication().isStandalone();
    }

    public void setWorkbenchStarted(boolean started) {
        this.workbenchStarted = started;
    }

    @NotNull
    public Path getTempFolder(@NotNull DBRProgressMonitor monitor, @NotNull String name) {
        Path localTemp;
        block14: {
            if (this.tempFolder == null) {
                monitor.subTask("Create temp folder");
                try {
                    Path tmpFolder;
                    String tempFolderPath = System.getProperty("dbeaver.io.tmpdir");
                    if (!CommonUtils.isEmpty((String)tempFolderPath)) {
                        File dbTempFolder = new File(tempFolderPath = GeneralUtils.replaceVariables((String)tempFolderPath, (IVariableResolver)new SystemVariablesResolver()));
                        if (!dbTempFolder.mkdirs()) {
                            throw new IOException("Can't create temp directory '" + dbTempFolder.getAbsolutePath() + "'");
                        }
                    } else {
                        tempFolderPath = System.getProperty("java.io.tmpdir");
                    }
                    if (!Files.exists(tmpFolder = Paths.get(tempFolderPath, new String[0]), new LinkOption[0])) {
                        log.debug((Object)("Create global temp folder '" + String.valueOf(tmpFolder) + "'"));
                        Files.createDirectories(tmpFolder, new FileAttribute[0]);
                    }
                    this.tempFolder = Files.createTempDirectory(tmpFolder, TEMP_PROJECT_NAME, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    String sysTempFolder = System.getProperty("java.io.tmpdir");
                    if (CommonUtils.isEmpty((String)sysTempFolder)) break block14;
                    this.tempFolder = Path.of(sysTempFolder, new String[0]).resolve(TEMP_PROJECT_NAME);
                    if (Files.exists(this.tempFolder, new LinkOption[0])) break block14;
                    try {
                        Files.createDirectories(this.tempFolder, new FileAttribute[0]);
                    }
                    catch (IOException iOException2) {
                        String sysUserFolder = System.getProperty("user.home");
                        if (CommonUtils.isEmpty((String)sysUserFolder)) break block14;
                        this.tempFolder = Path.of(sysUserFolder, new String[0]).resolve(TEMP_PROJECT_NAME);
                        if (Files.exists(this.tempFolder, new LinkOption[0])) break block14;
                        try {
                            Files.createDirectories(this.tempFolder, new FileAttribute[0]);
                        }
                        catch (IOException iOException3) {
                            this.tempFolder = Path.of(TEMP_PROJECT_NAME, new String[0]);
                        }
                    }
                }
            }
        }
        Path path = localTemp = name == null ? this.tempFolder : this.tempFolder.resolve(name);
        if (!Files.exists(localTemp, new LinkOption[0])) {
            try {
                Files.createDirectories(localTemp, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error((Object)("Can't create temp directory " + String.valueOf(localTemp)), (Throwable)e);
            }
        }
        return localTemp;
    }

    public boolean isShuttingDown() {
        return DesktopPlatform.isClosing();
    }
}

