/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser;

import com.github.weisj.jsvg.parser.DefaultElementLoader;
import com.github.weisj.jsvg.parser.DefaultParserProvider;
import com.github.weisj.jsvg.parser.DefaultResourcePolicy;
import com.github.weisj.jsvg.parser.DocumentLimits;
import com.github.weisj.jsvg.parser.ElementLoader;
import com.github.weisj.jsvg.parser.LoaderContext;
import com.github.weisj.jsvg.parser.ParserProvider;
import com.github.weisj.jsvg.parser.ResourceLoader;
import com.github.weisj.jsvg.parser.ResourcePolicy;
import com.github.weisj.jsvg.parser.SynchronousResourceLoader;
import org.jetbrains.annotations.NotNull;

final class MutableLoaderContext
implements LoaderContext,
LoaderContext.Builder {
    private static final ParserProvider DEFAULT_PARSER_PROVIDER = new DefaultParserProvider();
    private static final ResourceLoader DEFAULT_RESOURCE_LOADER = new SynchronousResourceLoader();
    private static final ElementLoader DEFAULT_ELEMENT_LOADER = new DefaultElementLoader(DefaultElementLoader.AllowExternalResources.DENY);
    @NotNull
    private ParserProvider parserProvider = DEFAULT_PARSER_PROVIDER;
    @NotNull
    private ResourceLoader resourceLoader = DEFAULT_RESOURCE_LOADER;
    @NotNull
    private ElementLoader elementLoader = DEFAULT_ELEMENT_LOADER;
    @NotNull
    private ResourcePolicy resourcePolicy = ResourcePolicy.DENY_EXTERNAL;
    @NotNull
    private DocumentLimits documentLimits = DocumentLimits.DEFAULT;

    MutableLoaderContext() {
    }

    @NotNull
    static MutableLoaderContext createDefault() {
        return new MutableLoaderContext();
    }

    @Override
    @NotNull
    public ParserProvider parserProvider() {
        return this.parserProvider;
    }

    @Override
    @NotNull
    public ResourceLoader resourceLoader() {
        return this.resourceLoader;
    }

    @Override
    @NotNull
    public ElementLoader elementLoader() {
        return this.elementLoader;
    }

    @Override
    @NotNull
    public ResourcePolicy externalResourcePolicy() {
        return this.resourcePolicy;
    }

    @Override
    @NotNull
    public DocumentLimits documentLimits() {
        return this.documentLimits;
    }

    @Override
    @NotNull
    public LoaderContext.Builder parserProvider(@NotNull ParserProvider parserProvider) {
        this.parserProvider = parserProvider;
        return this;
    }

    @Override
    @NotNull
    public LoaderContext.Builder resourceLoader(@NotNull ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        return this;
    }

    @Override
    @NotNull
    public LoaderContext.Builder elementLoader(@NotNull ElementLoader elementLoader) {
        this.elementLoader = elementLoader;
        return this;
    }

    @Override
    @NotNull
    public LoaderContext.Builder externalResourcePolicy(@NotNull ResourcePolicy policy) {
        this.resourcePolicy = policy;
        return this;
    }

    @Override
    @NotNull
    public LoaderContext.Builder documentLimits(@NotNull DocumentLimits documentLimits) {
        this.documentLimits = documentLimits;
        return this;
    }

    @Override
    @NotNull
    public LoaderContext build() {
        if (!(this.resourcePolicy instanceof DefaultResourcePolicy) || ((DefaultResourcePolicy)this.resourcePolicy).allowsExternalResources()) {
            this.elementLoader = new DefaultElementLoader(DefaultElementLoader.AllowExternalResources.ALLOW);
        }
        return this;
    }
}

