/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.ui.svg;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.File;
import org.apache.batik.ext.awt.image.codec.png.PNGImageWriter;
import org.apache.batik.ext.awt.image.spi.ImageWriter;
import org.apache.batik.ext.awt.image.spi.ImageWriterRegistry;
import org.apache.batik.svggen.SVGGraphics2D;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IClippingStrategy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.LayerManager;
import org.jkiss.dbeaver.erd.ui.export.ERDExportFormatHandler;
import org.jkiss.dbeaver.erd.ui.model.EntityDiagram;
import org.jkiss.dbeaver.erd.ui.part.DiagramPart;
import org.jkiss.dbeaver.ext.ui.svg.GraphicsToGraphics2DAdaptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;

public class ERDExportSVG
implements ERDExportFormatHandler {
    private static boolean pngWriterRegistered;

    private static synchronized void checkWriterRegister() {
        if (!pngWriterRegistered) {
            ImageWriterRegistry.getInstance().register((ImageWriter)new PNGImageWriter());
            pngWriterRegistered = true;
        }
    }

    public void exportDiagram(EntityDiagram diagram, IFigure figure, DiagramPart diagramPart, File targetFile) {
        ERDExportSVG.checkWriterRegister();
        try {
            Rectangle contentBounds = figure instanceof FreeformLayeredPane ? ((FreeformLayeredPane)figure).getFreeformExtent() : figure.getBounds();
            String svgNS = "http://www.w3.org/2000/svg";
            Document document = XMLUtils.createDocument();
            document.createAttributeNS(svgNS, "svg");
            SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
            svgGenerator.setSVGCanvasSize(new Dimension(contentBounds.width, contentBounds.height));
            GraphicsToGraphics2DAdaptor graphics = new GraphicsToGraphics2DAdaptor((Graphics2D)svgGenerator);
            graphics.translate(contentBounds.x * -1, contentBounds.y * -1);
            ERDExportSVG.paintDiagram(graphics, figure);
            LayerManager layerManager = (LayerManager)diagramPart.getViewer().getEditPartRegistry().get(LayerManager.ID);
            IFigure connectionLayer = layerManager.getLayer((Object)"Connection Layer");
            if (connectionLayer != null) {
                ERDExportSVG.paintDiagram(graphics, connectionLayer);
            }
            svgGenerator.stream(targetFile.getAbsolutePath());
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Save ERD as SVG", null, (Throwable)e);
        }
    }

    public static void paintDiagram(Graphics g, IFigure figure) {
        g.pushState();
        try {
            Rectangle rectangle;
            int n;
            int n2;
            Rectangle[] rectangleArray;
            Rectangle[] clipping;
            IFigure cf;
            IClippingStrategy clippingStrategy = figure.getClippingStrategy();
            for (Object child : figure.getChildren()) {
                if (child instanceof Layer) {
                    ERDExportSVG.paintDiagram(g, (IFigure)child);
                    continue;
                }
                if (!(child instanceof IFigure) || !(cf = (IFigure)child).isVisible()) continue;
                clipping = clippingStrategy != null ? clippingStrategy.getClip(cf) : new Rectangle[]{cf.getBounds()};
                rectangleArray = clipping;
                n2 = clipping.length;
                n = 0;
                while (n < n2) {
                    rectangle = rectangleArray[n];
                    if (rectangle.intersects(g.getClip(Rectangle.SINGLETON))) {
                        g.clipRect(rectangle);
                        cf.paint(g);
                        g.restoreState();
                    }
                    ++n;
                }
            }
            for (Object child : figure.getChildren()) {
                if (child instanceof Layer) {
                    ERDExportSVG.paintDiagram(g, (IFigure)child);
                }
                if (!(child instanceof IFigure) || !(cf = (IFigure)child).isVisible()) continue;
                clipping = clippingStrategy != null ? clippingStrategy.getClip(cf) : new Rectangle[]{cf.getBounds()};
                rectangleArray = clipping;
                n2 = clipping.length;
                n = 0;
                while (n < n2) {
                    rectangle = rectangleArray[n];
                    if (rectangle.intersects(g.getClip(Rectangle.SINGLETON))) {
                        g.clipRect(rectangle);
                        cf.paint(g);
                        g.restoreState();
                    }
                    ++n;
                }
            }
        }
        finally {
            g.popState();
        }
    }
}

