#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-ARdj0Gxwp4zGVoeX7XRn3A
key:                  dhall-1.42.2-ARdj0Gxwp4zGVoeX7XRn3A
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  bac437e265e745a121604b5dce3befe2
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-ARdj0Gxwp4zGVoeX7XRn3A
depends:
    Diff-0.4.1-B2xcsGNDyYyBHYwoGXiqMQ
    aeson-2.1.2.1-3ASKPK4Fa4QIZhzaxHwjxs
    aeson-pretty-0.8.10-1AsSJT9eYm9Akcn2tJ7MIY
    ansi-terminal-1.0.2-XVTjmfGbRhHh9m6ho3xPH
    atomic-write-0.2.1.1-8vu8iMNOSP6FssgWKDrGhs base-4.17.2.1
    base16-bytestring-1.0.2.0-EhkcVfgjuwAFVcx9XSm9uN
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-AOA4nZpESyL6LWb0KJmot5
    cborg-0.2.10.0-3VWb2fOK4z54OXOOjdCXx3
    cborg-json-0.2.6.0-BKkEEBovah7CurBfM40OWf containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-HK56u3px6RG1xGhDO81YoU
    data-fix-0.3.4-3tRLqTqnvH9GRGS7pLBfmC deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-JG4OTaLD8q1JPGlO8ceaZ7 exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-85sAnDkXIezLaVgctnkqec
    hashable-1.4.4.0-LeeIMVjvAfZ9pPDINFzJD3 haskeline-0.8.2
    http-client-0.7.18-2NBb8dRviZKF6gbPYE1it4
    http-client-tls-0.3.6.4-BNGtksKQZKoECMCkSQ8MhB
    http-types-0.12.4-JpXwqVeZXXKG8r6IvWPhPd
    indexed-traversable-0.1.4-7CVeuyouOTWKKa0kOI3ZHn
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-JIPw0VhlgXw3PCyB13SIAd
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-DdGoDFf3a3s7opu51wg3pq
    optparse-applicative-0.18.1.0-JRetn46hlLlGJ3GGKWAoff
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-6Me2FrfcOrdDOEFYQvDDDS
    pretty-simple-4.1.3.0-28S9ODnYi6A68JtumJ7sLu
    prettyprinter-1.7.1-ARIw2mjtQpRKFC0c75EykB
    prettyprinter-ansi-terminal-1.1.3-LWfd6XDRCXz2xNhESbK4r6
    profunctors-5.6.3-KRXf9rmVmV78rw7qsBrwqj
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.7.0-JqDV6opWCxfJYHM9hyUj1A
    serialise-0.2.6.1-4EXAX7GpCH9KjVjXv7nlBl template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-2dDEEkkhN9tEjdamOdfiGE
    text-short-0.1.6-KJ0KTmkJywlCQ57Q6ssygH
    th-lift-instances-0.1.20-21KKubLyrgoDI1czPibrx6 time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-5ezZizqQJI15CptMYaxmcc
    unordered-containers-0.2.20-LYUGqPQqiY1BtOxHMcngyp
    vector-0.13.2.0-DPvrhXfCE7T9HqJPMF38TY

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

