#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-C4nLfZpetMGsHdWXCR0eK
key:                  dhall-1.42.2-C4nLfZpetMGsHdWXCR0eK
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  f3ad6b76b0ea5da39588b69251247a07
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-C4nLfZpetMGsHdWXCR0eK
depends:
    Diff-0.4.1-BmR9nNrQwEPKsr6PSDMu3O
    aeson-2.1.2.1-DB2WsLvgTWYJbtB30Xr8uJ
    aeson-pretty-0.8.10-PLDUS4zsNe5BQPgrk9TIJ
    ansi-terminal-1.0.2-LK0hClTnqmnJXcQeh9qy33
    atomic-write-0.2.1.1-4V6zxQdgad6DvTbUJc8p87 base-4.17.2.1
    base16-bytestring-1.0.2.0-LEEZwYejCoZIthDQuiR9Zl
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-AIyOIkWFirE5gpwTHG13Fu
    cborg-0.2.10.0-JVLl70UbLZOLEL9f5r3Ia5
    cborg-json-0.2.6.0-JMGqVDItock2MmCNxgM9SN containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-4JIbMddDaOXDo24rgc78BK
    data-fix-0.3.4-2jBVw9mVh6hAbHM1ILsfEX deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-IEmCO5851GeDCuxYv8WI8u exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-6LnfCPcAd9dD4woWc4t5ij
    hashable-1.4.4.0-AxDm5kAgNA5AvAaNWXByLz haskeline-0.8.2
    http-client-0.7.18-3vBNda5SjtbD5m5tsPaQL9
    http-client-tls-0.3.6.4-2QdJ0MZ3QyPHBUzjS48Mma
    http-types-0.12.4-4iQ18EdfzNXG56M81TRVoy
    indexed-traversable-0.1.4-VgTDAKc7FOgNGXQ9TZ6
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-LEWOdoLm1W5HTyDo64s7RA
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-LH7woP6vetbJGQX1SzjlFY
    optparse-applicative-0.18.1.0-1UwvuBjTKFPFYzwsnOKAv7
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-EhbKHfpK2HnB2MEB9gzK0E
    pretty-simple-4.1.3.0-I9Mu20EjcVUF5nYbqNvpVc
    prettyprinter-1.7.1-ysnoMH95zUAKne5mwEFMY
    prettyprinter-ansi-terminal-1.1.3-8XSGFzV1valACs8qdaFbhC
    profunctors-5.6.3-EQLRKaMm2BCCqZQyH074Of
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.7.0-IiHfNWD2tBVFD7awc0NPte
    serialise-0.2.6.1-2EhelsPeZ3C1K6yqil3YDU template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-BWqlDNkC6i82PsTVq7seew
    text-short-0.1.6-L68UC9kG34b4VUl3x2rWba
    th-lift-instances-0.1.20-FpClurckKBTLKoLaK7Yi01 time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-9C8yVdF7bi078s1yBf345q
    unordered-containers-0.2.20-8pr2L2RDRM8Dqz21gIQp5G
    vector-0.13.2.0-5yTDFxdzRoNJu0VJvStUzF

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

