#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-49v9S92rOxPATn9nkng0rU
key:                  dhall-1.42.2-49v9S92rOxPATn9nkng0rU
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  e64493d36fea381d8960a60f02acfe49
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-49v9S92rOxPATn9nkng0rU
depends:
    Diff-0.4.1-J7uSJlkc9TFAbNe91KhLc0
    aeson-2.1.2.1-5gViDrHjeNhDfT19MwgeMT
    aeson-pretty-0.8.10-B9vRt54sIQsFdBteW4H6Dw
    ansi-terminal-1.0.2-7iJd05aKggE3LiIfKfS0OR
    atomic-write-0.2.1.1-2yBeyL4UhJHCbwf6VnwfuP base-4.17.2.1
    base16-bytestring-1.0.2.0-EvVnyNi6qSO1YApUrGufKM
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-D4Bx6jK2099tFJcppXDxv
    cborg-0.2.10.0-BUQ9IKhBmxw8yxShvJzJ9L
    cborg-json-0.2.6.0-7cc43CxgD2S5Zr5EeYgj6E containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-AaSlMMY9xbgBJ7moz40mKm
    data-fix-0.3.4-Kii2WqV9rpv5NGnbCSWHZ8 deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-Dg8aFzMAKa97kgiVSsgEK2 exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-HoGdj9OYF61HabLoQBGZ4A
    hashable-1.4.4.0-HcIU0jNirb1KY01FJoO6uU haskeline-0.8.2
    http-client-0.7.18-F2vUdc4GuQE1q0cHPJLrjL
    http-client-tls-0.3.6.4-DODfTH3cedh5x8SsPyX9KG
    http-types-0.12.4-845zQBf8K2R8QZqh3scBqV
    indexed-traversable-0.1.4-KlT0Wrn9TQiIszwKvODAZp
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-K842mSJotk3GLelhPtnPWL
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-9MIvjX5zY25ED43FJsYIB3
    optparse-applicative-0.18.1.0-7KCyXOPBHhG88hE75wN8Ie
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-Fiw27Lc4EhH6mrPl22nuKX
    pretty-simple-4.1.3.0-GMo4aOMlYWyBPy8Bajnc8o
    prettyprinter-1.7.1-LPaoyWKSQT7KS513LTmQrZ
    prettyprinter-ansi-terminal-1.1.3-2hI4QKbGqc5CZyGYrHlhah
    profunctors-5.6.3-HEYfd0vfOhiGNfrAjjmycl
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.7.0-HvL2E1otFtODq1T2dktHha
    serialise-0.2.6.1-AcJ0tBl2hMe9A9hdn37xVJ template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-2YQABpPHWB7FwwpB3Arv3P
    text-short-0.1.6-7t34DbZEKVN2R4tjCNJcWJ
    th-lift-instances-0.1.20-I4VQVEAO06MBHdzDdaqPPK time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-FtHhyYNKXNEEfGBWiva7Zs
    unordered-containers-0.2.20-BooESfmG3DbHMU6mBvbzIL
    vector-0.13.2.0-InZif5xbqP17OkTvptfKiM

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

