#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-F3YQca5YzktLc7Rdpa7G0c
key:                  dhall-1.42.2-F3YQca5YzktLc7Rdpa7G0c
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  56c72e761348a9684430fabc0891dae1
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-F3YQca5YzktLc7Rdpa7G0c
depends:
    Diff-0.4.1-BX7ePMXM8kOEj0lpdSYnwr
    aeson-2.1.2.1-nFo3VMHABFBaVDPPKfnuT
    aeson-pretty-0.8.10-FEdTNv6fEiP4zvH2lfwaXH
    ansi-terminal-1.0.2-EudAPB7rRCyDJBI0UXDeTd
    atomic-write-0.2.1.1-J56cyeY6uwnK4PCZ5tdNjq base-4.17.2.1
    base16-bytestring-1.0.2.0-9yylp2Sfu9J66hFLYzeXZn
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-Abd5Q51hq5G7EsMEex29Bt
    cborg-0.2.10.0-LiTav6yP4ZcHShRsEcgjCg
    cborg-json-0.2.6.0-JJhL16vDa1P5o0j8hDZeFj containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-9RaDD3AAaBu2B6NmvhT0dc
    data-fix-0.3.4-4x3W56i2UvW3Hbdd3wUR3y deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-4wM6z7VZ4W1hydl8ETevA exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-40LB4EcVau85SjZMxLi1OK
    hashable-1.4.4.0-JPfSbBrFTKBgQKoWbpACz haskeline-0.8.2
    http-client-0.7.18-K1IvRTF7D2SE2xldIkW1tD
    http-client-tls-0.3.6.4-9bvTIKuCxU6Eviq8WtS8lH
    http-types-0.12.4-ERErpW4oIqaKIzWiLMLiFN
    indexed-traversable-0.1.4-daDHdCedQd5Buv5VkdtT9
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-5wqMRZqTk6B8Hn3YAbESf9
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-9UqT53JjEGDF2lVDrQUMu1
    optparse-applicative-0.18.1.0-FC4zXF1Gvg5FVkM3KJzuj
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-H8uFmkVMbmeEuDJmRTcBZ4
    pretty-simple-4.1.3.0-Jqj7IfhMIWs4pBYpeuh7Sm
    prettyprinter-1.7.1-KiZcPWXJVNZ6oHVA0qVcfd
    prettyprinter-ansi-terminal-1.1.3-1ng9uWt2kiaHr5skgX5vwF
    profunctors-5.6.3-H5kxQI8g3rPGwXZPmQhHiV
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.7.0-H4Og6N92k1lGQSMIPZo0fR
    serialise-0.2.6.1-IOzEiwzgu1RASVIi2SNrqq template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-IpKFl3Nw1Jq53BNwHQ4PYG
    text-short-0.1.6-COyi1A9OddE7eSTfGwcwgg
    th-lift-instances-0.1.20-P0ISBryUMCLQnt15KL0p9 time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-BZWTyxtN7nl3Z0fwlVJ8w5
    unordered-containers-0.2.20-DaOkK38PYRa9pF7ZwbG4ZB
    vector-0.13.2.0-5IsJnyR8rmEEUPyguFia6U

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

