#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-EVf7bvzhJ1v7KIu22W9MbI
key:                  dhall-1.42.2-EVf7bvzhJ1v7KIu22W9MbI
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  78fe832860618e019a353fb1c80cf50f
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-EVf7bvzhJ1v7KIu22W9MbI
depends:
    Diff-0.4.1-4VjaazPwKkA8eC2BQCP8tm
    aeson-2.1.2.1-4cRYi3WcVwTKRqMhXUztfB
    aeson-pretty-0.8.10-HNTMWj24mP2BSAsGYS1aNs
    ansi-terminal-1.0.2-4F37L3ko1KQ1hALBi4f5f0
    atomic-write-0.2.1.1-GF4swC3FvRbDqvPBJp7KVj base-4.17.2.1
    base16-bytestring-1.0.2.0-3fBZP0w16aFKJmcNXn7qs9
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-EmvCHr7Pi0DF9aG5Som7hU
    cborg-0.2.10.0-B4k4W5DnMZ6JGExWP718tc
    cborg-json-0.2.6.0-JRWi9BWMsuTLM4X7V3Olp3 containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-AWxbRMlvEmVEIOOYcJSQT9
    data-fix-0.3.4-2nMNNF2nAaTCmUor536blE deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-JiyT1BCFVADGwhi0Kk5aEw exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-7bHujTHlubyCizCOczF7LC
    hashable-1.4.4.0-4IkOt4KzeSSA3Xc4u5PLaT haskeline-0.8.2
    http-client-0.7.18-IsbH9OAm6XgF9hL4xsUtLO
    http-client-tls-0.3.6.4-AbKaWsrN8o1Gmv354Xqd1x
    http-types-0.12.4-Hz1QXcCML2nIj1GeZ6O8D8
    indexed-traversable-0.1.4-FpAcbJlkQDVBCnOnkgXYhG
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-GErkrd4BuZw1o2z4Ja9YFU
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-HPE7I962wSKDZCCiANqdpI
    optparse-applicative-0.18.1.0-FquNYXEN3Tk7yAxpGHhMRz
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-LCg4ZRhZS13DgYdSbllTWN
    pretty-simple-4.1.3.0-D2myQsZ10nhLeXXigtJ5xd
    prettyprinter-1.7.1-G4E3PI2BTIHFT7NfmJKOqD
    prettyprinter-ansi-terminal-1.1.3-FHReNHhiJ9k22dC6VcAYKN
    profunctors-5.6.3-4WpHBsS0I4A3CkrD0G43oU
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.7.0-K2KPplW6Nka7Ws1cS3R2Yx
    serialise-0.2.6.1-LGLO7J4YZ3PJ7o2n9Tj4dH template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-2I7wwxRpJfmFbGF5kBkE65
    text-short-0.1.6-HLVfhs0XYYaCbcLaS6jByH
    th-lift-instances-0.1.20-6i65Sr2FVp53pAKeRcKAmJ time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-HkeMBjDm0rZC7ERiJ32kv5
    unordered-containers-0.2.20-A2tjqfQXDXnFd3Ae9FP0C3
    vector-0.13.2.0-5H8NMvQc0Ab8bNH9ZMgAUW

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

