#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-8yLangQOjD8DSPnf9cWhqv
key:                  dhall-1.42.2-8yLangQOjD8DSPnf9cWhqv
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  9ce2f07b3e5e73d23fa1d47c92251024
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-8yLangQOjD8DSPnf9cWhqv
depends:
    Diff-0.4.1-E4QQdwFPhVj2ic4COxhZBq
    aeson-2.1.2.1-6LfdTurWC20A9IWYLs821k
    aeson-pretty-0.8.10-4128uI3WaVsCsV26qTAcKt
    ansi-terminal-1.0.2-GMfU0IJ80BpJLoxPRZMG7V
    atomic-write-0.2.1.1-6bfycPW8IdO69wXOgnPBl4 base-4.17.2.1
    base16-bytestring-1.0.2.0-2U8KlRNggLqLs1cZzvTsOg
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-5l2QOpNdY1A6hVaz3nH17n
    cborg-0.2.10.0-5YJJ6dD9se1JFxGsroF0J5
    cborg-json-0.2.6.0-BeHSO8aFCLYEVezf9Ibog0 containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-51bloADwKm07Nm7zxUYeej
    data-fix-0.3.4-4gmf3Gb5k9Q33Mbau7zDoG deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-51OmDqe3WLj8XbZiB8kqF7 exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-3CA28O0gQhxBFDzBPTgQ4d
    hashable-1.4.4.0-9uPnQxUdwOnCZlD9EiHqMs haskeline-0.8.2
    http-client-0.7.18-9qBJxh17yshDwYABVFlZAq
    http-client-tls-0.3.6.4-BmU0JwWls2VKjAI6YrsjSE
    http-types-0.12.4-1Pq1Zy5bmQBJRy3r5PsBE
    indexed-traversable-0.1.4-GRWI01OF8Y0Lwm8Qck38KL
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.7.0-8pqi9iESDeArTxKEjGQsn
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-KyuZLjrVkMLH56LkxlYTeb
    optparse-applicative-0.18.1.0-iHmWlwYwvYAmLT692zZvc
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-JYJq89eNa6TDPMBJo3uKrQ
    pretty-simple-4.1.3.0-LM5klPeWHePBLXXgxkZEl1
    prettyprinter-1.7.1-OSddR9QU1LKvWd60o7pju
    prettyprinter-ansi-terminal-1.1.3-32HfLtjcgVL9wxVBnHPent
    profunctors-5.6.3-Awvi78GiKWR1SSMXJ32bHl
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-4T67wgFVOmHCrVwu3HwSpM
    serialise-0.2.6.1-1bMf3T2wIkRIx3aUsjzxyQ template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-HKfGuQSRKVl1X6mN3AumDa
    text-short-0.1.6-DtEm1uyDHCFKxrESeItn2B
    th-lift-instances-0.1.20-LFNV6AmxvYH4EakjJWjxIb time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-G4SKwUBWRB0BAMhxExxVa1
    unordered-containers-0.2.20-3iRUctzIz2JCUYhLp7SKku
    vector-0.13.2.0-GniUvXn58d91eC1W7jmZ0

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

