#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-DQxNRICQA6S5jyU5onutbk
key:                  dhall-1.42.2-DQxNRICQA6S5jyU5onutbk
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  9ae492beab51c9c02fbe1068988455c6
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-DQxNRICQA6S5jyU5onutbk
depends:
    Diff-0.4.1-GcqdD78fbkMBZft0adAeUr
    aeson-2.1.2.1-LDc25PpdH5WHlLB8Mcp2Rh
    aeson-pretty-0.8.10-HWmn7v7pElT331cgWAs6cN
    ansi-terminal-1.0.2-9C7TLPMqFC3EnANnfcyKas
    atomic-write-0.2.1.1-Hg8LW2lwRUs2VmKuFBH0qf base-4.17.2.1
    base16-bytestring-1.0.2.0-HnopC1pBvWk9dgrypuG55K
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-1RHeXy1S6Rm5Spie3OUbmD
    cborg-0.2.10.0-CRAHniDpPicH1m0DFqhKeC
    cborg-json-0.2.6.0-13INRkcB8FoGFGuaocnEDq containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-H4bTMrsO7C8KhRBEMouzBp
    data-fix-0.3.4-9JiznarwTn78ZcCXXj3YzS deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-5odMBcc62wYKnG3NIEf1TN exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-5j7KBLY7MMb1TlICWCiBrf
    hashable-1.4.4.0-85lkkmOSRZHDIzkr9EkKNp haskeline-0.8.2
    http-client-0.7.19-GGFMm7MPmy6D22PtCWjSH6
    http-client-tls-0.3.6.4-SlbGxNbffj8iOCf5aZg59
    http-types-0.12.4-AKSPjJIqePQLPw819bUb23
    indexed-traversable-0.1.4-G1Ar9vM2x492EvfRvVfHxJ
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.7.0-AMbJQB9BzBxf81g5ZS6Op
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-HjnHIRdbGth3RAPPiFyOPG
    optparse-applicative-0.18.1.0-5z7uKq3kDhiFdyVMsq5grp
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-5eBAUS44oB72eQOCpZb1Sj
    pretty-simple-4.1.3.0-32yylESRFjw6n90rZ53c5v
    prettyprinter-1.7.1-Lg6JVLzvNS6KZGjYMe3Z72
    prettyprinter-ansi-terminal-1.1.3-IwF9o6IcilF2GB12Um99ek
    profunctors-5.6.3-Ks2eCIzdKc2gesAHQYhNk
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-HUqAf4XaF5T5GawpMI5GwR
    serialise-0.2.6.1-EDYpgETWrrFL7dQg2Da7xh template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-2mNlcNo3Rgb8u5uV2U2FLO
    text-short-0.1.6-fDzHeUBKE6ANI3Oi274D7
    th-lift-instances-0.1.20-AeUdbWqQ7Hq4NSZBSNUP4Q time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-BDNMqGtORWv1TblmXvfCQe
    unordered-containers-0.2.20-Cw2Ec4BgC4sInKE4e5RLSk
    vector-0.13.2.0-3jopdCx3MMLHVSrvHoDH9i

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

