#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-GJNWdpEz9yoIHUckqAKjzB
key:                  dhall-1.42.2-GJNWdpEz9yoIHUckqAKjzB
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  d16da34735ebfb6e3553a553d67976d2
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-GJNWdpEz9yoIHUckqAKjzB
depends:
    Diff-0.4.1-JwyFShoyUNq8AaVjf61637
    aeson-2.1.2.1-BWqAP5DPS0iMNSAJtMWSf
    aeson-pretty-0.8.10-8EXoxIF81CyGdoAzb1CQGS
    ansi-terminal-1.0.2-1WMmnSFsRadEUq8BUHK73i
    atomic-write-0.2.1.1-Q2jnywEaZ772CdBnXkvUV base-4.17.2.1
    base16-bytestring-1.0.2.0-1bEkwAvKVlC52PGjoO72jZ
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-GKEaqjX3nXNEZmMRebSTRD
    cborg-0.2.10.0-616VPqstnwoLQCUNvfaUe9
    cborg-json-0.2.6.0-CxIjdlq0cG69x7UFKo8eGb containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-7HoC5OGxbDV3R4V8a1pbCZ
    data-fix-0.3.4-FO20vmPdeJ5BzvBM5IbLNx deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-Jcf6sU2rPLkCKL4N9yh4Qm exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-HIMgn2FeOp2FBhhejn29Jr
    hashable-1.4.4.0-2lvxXC6j7O5I2GR31C0SqX haskeline-0.8.2
    http-client-0.7.19-LKlU3HcOEMNION0MdQYtj
    http-client-tls-0.3.6.4-1iaAAi64BfdGALlJ7qoOys
    http-types-0.12.4-JotGc98QwUtHuX8PPdlxoe
    indexed-traversable-0.1.4-LyeF3yLPY26FCcc6uHtQva
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.7.0-DoL2miG02BJ8XUb2sfozR5
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-CScpRPfTOboAxTStoroPUs
    optparse-applicative-0.18.1.0-3iEgSETSoiB1QksrTAD8kN
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-7LaBP4SOVfQ2EPeolO2UXt
    pretty-simple-4.1.3.0-Ijf3z2zjjwZ7zmbupjTGgU
    prettyprinter-1.7.1-GW24MvTJNAcBiqvxAdyJJ2
    prettyprinter-ansi-terminal-1.1.3-1FYm69oHtbE2eHLM7mvKdL
    profunctors-5.6.3-63mQtfUXOTH6K8o94A7vA
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-Lr1UPzAneM96vFGoFLDTYK
    serialise-0.2.6.1-68hYgXYfX17KKn1fXHeG7O template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-8ZgWnkStTkPLij7IXIEGcA
    text-short-0.1.6-61JSmlAoOQSLZ3xCmH2jrS
    th-lift-instances-0.1.20-CcEP2rBfSfZ8kYVUD1JuBC time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-GSBAQpPSas81W7oazsVVV
    unordered-containers-0.2.20-G9Xtyt8hv5K8HhfrH8JX1r
    vector-0.13.2.0-K0fBmK5qd7y3388236ZS0A

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

