#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-87DsYLGRkvc3QarVTsKqYU
key:                  dhall-1.42.2-87DsYLGRkvc3QarVTsKqYU
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  837189777fb16c2052f74bc71365956a
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-87DsYLGRkvc3QarVTsKqYU
depends:
    Diff-0.4.1-HOGfEyxGmCUAz64jdnP9fa
    aeson-2.1.2.1-FurzwiqHIOZ8NUBnR3RWtD
    aeson-pretty-0.8.10-E7uvBK5bOfQ9dZdffWV4UL
    ansi-terminal-1.0.2-8A8xJnPl6su1eTYW5nsKkX
    atomic-write-0.2.1.1-JjvYJ8wjZh4DssIyy809kY base-4.17.2.1
    base16-bytestring-1.0.2.0-8KOr0OVfDkD2ATl4yj4Mhp
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-4gOYP47XUTf2S4ZStIaMwN
    cborg-0.2.10.0-AQs3wNcJhnkDgaC0uh50E0
    cborg-json-0.2.6.0-J8Nu6f5m2G4AF8XRqGpKHH containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-DHpnW6ZF2XUFBgo7TwHTlm
    data-fix-0.3.4-IY2lXAlldZ275cX4sUP0m2 deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-4PnIfFw6dvu3zYJXsq2Evv exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-3hFRRmiFPk04ERoUT42jy4
    hashable-1.4.4.0-GlxcJ9XR4pRDbsSt4txSan haskeline-0.8.2
    http-client-0.7.19-7TptaWByUgGB9Q5jnOoQnY
    http-client-tls-0.3.6.4-3HdL8pscJo22qAm0LdYAWU
    http-types-0.12.4-GK6adOlCgtYAucedrAKKtY
    indexed-traversable-0.1.4-6pCmebCJxsJJEjw4pmJbeU
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.7.0-3djLYUlnjlAJjkWgXBHMlu
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-DUv5vSA1kyG9zefYf8rGu8
    optparse-applicative-0.18.1.0-AciOqB5cZ6TCe3A10FCF62
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-53xTBdi59lo9R6pKoutq7F
    pretty-simple-4.1.3.0-5FFcWCIzKxdAtLBNOAbcat
    prettyprinter-1.7.1-GvA4HkORFFfEAfVfftDbx5
    prettyprinter-ansi-terminal-1.1.3-HlEqsxZMjvBXkYPY2xpN5
    profunctors-5.6.3-2LK7nm52yOQFV8ojOctBk5
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-FY8DXpomWvN257bBgIbNZf
    serialise-0.2.6.1-BOD7c2focdsL11uefLDHH template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-H2yikSNhN0d7nb4UpZJDl9
    text-short-0.1.6-LFaRzCZdyShLlrJly9OIQT
    th-lift-instances-0.1.20-8dR7NMz4WaYLnGM3etmKuG time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-Hu6g1FPEkjd5KkhG0SWdOc
    unordered-containers-0.2.20-3ZBRQjn1NdW5zFXXpEAC63
    vector-0.13.2.0-7SsYBYYt4xiG1AFztZAEHX

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

