#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-DPwuaktESnbDzHLJwBm64E
key:                  dhall-1.42.2-DPwuaktESnbDzHLJwBm64E
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  9dcde50d91f0762a16c806e008a0d423
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-DPwuaktESnbDzHLJwBm64E
depends:
    Diff-0.4.1-EPHFVS7K0Jk50U1vJ3ZOtn
    aeson-2.1.2.1-4ODQ1UQyjV4HqW8vjPOsEA
    aeson-pretty-0.8.10-6Euy8cnI6OXHGa0B9GNfZp
    ansi-terminal-1.0.2-FkjFmzyZyQ09kjMl1I4g29
    atomic-write-0.2.1.1-J3mouw3kBLe9AAhodld2Rd base-4.17.2.1
    base16-bytestring-1.0.2.0-5BDVtclqicADEa9JZ5fsZH
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-6fVgEt7vrFc1sDHTeWeWXd
    cborg-0.2.10.0-FctIksAcAYHH3HFNYgNU30
    cborg-json-0.2.6.0-9RU8AqdCDz36QxJQW1bJbP containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-HAyjavxhaX1LI8tBHa1Jqj
    data-fix-0.3.4-9bjWYMOeexnGH14jkRYSOh deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-9LFBcehmdk7BiW9XTQtRz2 exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-1pqGgJr5J2DGczblBGc3N3
    hashable-1.4.4.0-BPBogvz51gTFqjBeDWtSVb haskeline-0.8.2
    http-client-0.7.19-GBWZtgLxevaKnflbUYdsDc
    http-client-tls-0.3.6.4-IYe2sIHragA22YL3SplOCc
    http-types-0.12.4-ALPJWcgMeIc83stb9QW9Gl
    indexed-traversable-0.1.4-1dhHBoLFntW5SGzstHUOxj
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.7.0-DEUv5YUmdT01sIVP4Xv3Ec
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-HOjMWSH0yhpFPW7mMXqod2
    optparse-applicative-0.18.1.0-LtQWPLKmjlx59fIGxpWSti
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-3REwiOQUcVa7yibkAUTWrj
    pretty-simple-4.1.3.0-Bq1aVNsCDCOBIqNwPKqMuG
    prettyprinter-1.7.1-AUeOQjFrPgDFiTKCjRnpzw
    prettyprinter-ansi-terminal-1.1.3-JYpKT4K1fh8DBq6vtnsXuJ
    profunctors-5.6.3-DKBzX3YqV8IBJaFEhWlMk0
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-KN45uED49ez8IbcjYjrLBN
    serialise-0.2.6.1-6ebjCykyzFRIurL5Jh6dc5 template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-DHN3x29eYckLeFHplo1ouN
    text-short-0.1.6-Iw5qJriXjnZ5HQscs86bYL
    th-lift-instances-0.1.20-6A9vs3XVslTHgRJodRaMgs time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-Vv5ZVefh6nKwhTswwMae7
    unordered-containers-0.2.20-7dvM9aaOf5JATet72j0BPX
    vector-0.13.2.0-JDMr93x2QgFDQPvksTJZzq

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

