#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-IxPLfiNYZuQF4e0YQTqORz
key:                  dhall-1.42.2-IxPLfiNYZuQF4e0YQTqORz
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  0a9ffdad7e3e39db1e807250c6285e2c
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-IxPLfiNYZuQF4e0YQTqORz
depends:
    Diff-0.4.1-Ku34wyKp5JHHh0VBRQYd7N
    aeson-2.1.2.1-J19dEw13kUOF5hLEOQVj2r
    aeson-pretty-0.8.10-6qTGYZatwwqDkYKjXv3jx5
    ansi-terminal-1.0.2-ELflFHQZXI14MtzKLMv1G6
    atomic-write-0.2.1.1-1mClutwVSa5AswUAtcDUch base-4.17.2.1
    base16-bytestring-1.0.2.0-5J7tyLLyUk5BSrxgZ0XvOi
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-A0C3sKUh8bjBoKTAh9uBrV
    cborg-0.2.10.0-FbwPDZ2B8oR2KG7c6qM7g9
    cborg-json-0.2.6.0-KlElgoUmZUVi1dw5avBzD containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-3VpgZnrNkchINpWq9aX9Hh
    data-fix-0.3.4-LUx4ujKUZqlLcnDlnKPyrs deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-27U4hIAlWIYEG8CtosP519 exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-H78Ak7IfYacFNBgQsFQOu7
    hashable-1.4.4.0-KHdv63hvW7JkoOGsLWKac haskeline-0.8.2
    http-client-0.7.19-KicVexkpqk4oKge5Ko4JA
    http-client-tls-0.3.6.4-BH2xF2TCL7BBkvzFmR7sFV
    http-types-0.12.4-3tEQsAXlW3W83gTXUT3vtQ
    indexed-traversable-0.1.4-3V8UCsCL2nP2CArv2W49N1
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.7.0-7JToewzpODIKYsxdMWTRd1
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-14hVMYCnjzx6Mshy3n2kRE
    optparse-applicative-0.18.1.0-FoUSxzMBUR5IeTMTUEotqz
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-F1EbyLFKjurFIdX9vYicqL
    pretty-simple-4.1.3.0-5bHDjl9JSZt2N60dm6nRuH
    prettyprinter-1.7.1-K25tjwTKXuP4KBelsyCegB
    prettyprinter-ansi-terminal-1.1.3-1B0Gr63y68dtMIFWWuAl2
    profunctors-5.6.3-Al90cA0rHhQB7urjPM7Mrc
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-JD5EMEyFBUc5yMNfC55Oq6
    serialise-0.2.6.1-5aF09EfSh0V9mGCPjcJl90 template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-AhnXcribKyc59wwSvRtgyJ
    text-short-0.1.6-E7dU7XggPrS2MqFRVhPPLu
    th-lift-instances-0.1.20-CZv5UcUxK4JJQ4zAbS7ny8 time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-3FdbTf0wHyAAtiLARGDxS5
    unordered-containers-0.2.20-1i1FNKzvn6TI2R1AzcNrcz
    vector-0.13.2.0-FNdsFzivQrc5gVfjRMxS7n

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

