#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-7B25cj1DH4WH1R6HEueLBG
key:                  dhall-1.42.2-7B25cj1DH4WH1R6HEueLBG
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  3fc0e2fa2be4ff54876770571f53a26f
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-7B25cj1DH4WH1R6HEueLBG
depends:
    Diff-0.4.1-1z8203Zj7CQKOl3UA5hzTf
    aeson-2.1.2.1-Eu0ZMA1fvZJ7acphaZ1YUp
    aeson-pretty-0.8.10-8K6VAOlgEiI6kbxgmBEhWH
    ansi-terminal-1.0.2-3ZetLec9Al83HbTC6rcVId
    atomic-write-0.2.1.1-6j4n84ErJ7JpHMU9E1J8l base-4.17.2.1
    base16-bytestring-1.0.2.0-HHn0a1B8psO3gTbvWbogBl
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-ELM66iRIeZm6Dg1Td1yG95
    cborg-0.2.10.0-Ol0l2aO0w696FYxGVg3Qt
    cborg-json-0.2.6.0-Bakv9TZ4BWTFWPmpeDEPt containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-4onQdfLSkOaAm79BnwT8G7
    data-fix-0.3.4-48cXvQcshtj1tNVGAndj5R deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-Dt1znj70bMfI4ry68g47tW exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-oeWdudwI02FYYu106poM3
    hashable-1.4.4.0-HmFtE5Wyl97MxSGTvKCoh haskeline-0.8.2
    http-client-0.7.19-3rmvGvyaabxFxCJ9oJ0aDx
    http-client-tls-0.3.6.4-8TCMitZJevE8PRVlviJUoX
    http-types-0.12.4-AxSTuELtXS8Ebx20Rd9Bgd
    indexed-traversable-0.1.4-3Mq4EBXbmCUGTMDLGSN4EO
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.7.0-L9yzYQswnVIEfh0e6mQmZ2
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-E8aEaRQxCxy3qJUPBltH5o
    optparse-applicative-0.18.1.0-9usJKW05Tg77TzGdDpbTqq
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-otW7EfV3VJ68kSOSvXH7p
    pretty-simple-4.1.3.0-IojhPEFWmMPIri6V7Takq7
    prettyprinter-1.7.1-CsTpPkPqzgLjuO06MZsX5
    prettyprinter-ansi-terminal-1.1.3-H6b8xRSUd7E1Hz5nUxGJlx
    profunctors-5.6.3-2aeeHhQ6SaUCZXw42yISfH
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-hGLqISimekA59HuDEk96u
    serialise-0.2.6.1-BVcgehS2dAx1Y5WK4jTFft template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-J90hKn8YQl74yiPd98BE4Y
    text-short-0.1.6-5tdBq4uv374KgT7qGb8rUa
    th-lift-instances-0.1.20-IJys8owbLUd1cC2sqxKfqW time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-7O49sxXSp3B9cDegRW2Oej
    unordered-containers-0.2.20-5YE9FG6zPmjDjdA4DCPpEY
    vector-0.13.2.0-2If6MrCrP3g55Bnhb5dowG

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

