#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-ATzYvQFOvh83I19AhuaOM2
key:                  dhall-1.42.2-ATzYvQFOvh83I19AhuaOM2
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  5be2a7ff5b259829e63c152fbe6130e9
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-ATzYvQFOvh83I19AhuaOM2
depends:
    Diff-0.5-I9LKtAA6ptaIdud9jo1N33
    aeson-2.1.2.1-JflO2jKMgLf4qHLretO6v3
    aeson-pretty-0.8.10-4jYTVUzf20XD2mi58X3Oq8
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU
    atomic-write-0.2.1.1-EOD51WqtYYBJQT6ABvv0WY base-4.17.2.1
    base16-bytestring-1.0.2.0-8PN9291fiWfGUTIhioOibg
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-BbofItWtqOBJTc7ifMkeDp
    cborg-0.2.10.0-8XoOWSl2BFR8ccBKzp2EZx
    cborg-json-0.2.6.0-n7YNyRPbYZFa4Dt47tIAL containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-HTw5zKiYP3d1f11znYSa95
    data-fix-0.3.4-HCeTjtMQtNEDmkpJMPqJaI deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-7spijw5YLKBGnbDzFy9xka exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-Gga8RBK2Opa74qgQ58LcG8
    hashable-1.4.4.0-6tleuNdu8X41J3b2E1oOOY haskeline-0.8.2
    http-client-0.7.19-AzjKmN88iKpHUThQVz5Oi6
    http-client-tls-0.3.6.4-7hFqlCciT2L8ai6mzNcHUq
    http-types-0.12.4-IN69whTTZpTCgL5hadx0pQ
    indexed-traversable-0.1.4-FjrZ8c6UpDNGZqVYWjmd91
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.7.0-FHgjCkAAg7CFkxuBfGOMbb
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-2gUAl98MPyzDbzRsnMqG8p
    optparse-applicative-0.18.1.0-LGvZkTwKuqyFBAUogcAFyK
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-4yPBovHI6Gs3s5A8NPgJkW
    pretty-simple-4.1.3.0-1bcxNvgToUC00TXp7o784
    prettyprinter-1.7.1-Da1BCiI1NV6LfdDEPEDf77
    prettyprinter-ansi-terminal-1.1.3-JvMlFweUqjX9cwpH0vA579
    profunctors-5.6.3-FiHazNoTbSuEkaVv0xHC9t
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-8fLTd8S79uT7C3Z3GpM5Vd
    serialise-0.2.6.1-8E4SlmEFsza2z8KUQ5OpZA template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-30gN0RBJ1MQ6qgILGcDUo8
    text-short-0.1.6-87eR6cDNww9GOZXiGn0zTP
    th-lift-instances-0.1.20-GiLeFSVZ9CnLoGkW315HYa time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-2QwnBrWekoc6SOPsPeItcF
    unordered-containers-0.2.20-Eo1ocpXri5ABLOF81VToPu
    vector-0.13.2.0-ByKMfTK8tTR39fPNQcIOcc

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

