#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-CbXnNOYdZKc4twWgRXVhFa
key:                  dhall-1.42.2-CbXnNOYdZKc4twWgRXVhFa
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  7059f275c373a5684860d7878a925c2f
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-CbXnNOYdZKc4twWgRXVhFa
depends:
    Diff-0.5-BA8gjrNLWD91mpgDqPEm1l
    aeson-2.1.2.1-56YME0rnoff9HEf3dDitk2
    aeson-pretty-0.8.10-DpHDVh8mDGd5mr1ZEAcaAo
    ansi-terminal-1.0.2-D5qYwqv6rV8C8VJ5M6PJzO
    atomic-write-0.2.1.1-EZechIaOAOO2bcRddlYEcY base-4.17.2.1
    base16-bytestring-1.0.2.0-JJ3kiIXKgAJ4lIXvD45idj
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-6AEDVQFE46r4UgT1OZ8vwx
    cborg-0.2.10.0-3o9nClG9PIRK1OE3AVygAa
    cborg-json-0.2.6.0-ISy4egm6sxcCBBjkugwK9N containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-BxQla8G9gPrGgfqAI9qhcu
    data-fix-0.3.4-6n95UW8MJKJ7MAzOZYxKuv deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-BtcezSfqlh64PFukFhtSzB exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-KQYObrv2EhlE4BBDygd70G
    hashable-1.4.4.0-7d9WFDaK31uHgEwdYM8cSb haskeline-0.8.2
    http-client-0.7.19-Iv0FNpcg1x0FpQ6t2lbifU
    http-client-tls-0.3.6.4-EHp2ApKIbMzCSorMXxum8X
    http-types-0.12.4-GF9q12zDyJCA1fCuHO5qN
    indexed-traversable-0.1.4-8ofzt1DXjtN8gbqsckEMG8
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.7.0-8QcUjVGbdbIDZ3h44NDcYc
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-20b9im5hRHiD5kB2vlJ1JL
    optparse-applicative-0.18.1.0-4I1HvF8r6VYLyVAzfeWbyM
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-96TAO08wqwjKaheNsS5gML
    pretty-simple-4.1.3.0-2vva2SV3ZC7qAO6rTZlYi
    prettyprinter-1.7.1-3l8vMA7BErkrlUUW8GNd2
    prettyprinter-ansi-terminal-1.1.3-3eJvdoQSl8mFOC6iJleOk
    profunctors-5.6.3-LgeRiRAoZIJ3q2a53AXjzp
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-6cXdeLWNyVuBHCExgz4Uaq
    serialise-0.2.6.1-4H3OtCsRAcp15hotOPkAR7 template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-859UBLMUJJ21UR5NaqUtGg
    text-short-0.1.6-7zj2YTdDFfS2kbhHmok7g5
    th-lift-instances-0.1.20-HIy4qdodoErFLL1XYxnub9 time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-IR9uEbNEBGbEspkibOUysa
    unordered-containers-0.2.20-90liAnN3BtD8VAzg2AGnlq
    vector-0.13.2.0-Fx80VLFrFKz3Sy2krWU8Ue

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

