#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-3MsHvAMoe6f5dAHYxdDAU4
key:                  dhall-1.42.2-3MsHvAMoe6f5dAHYxdDAU4
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  b687a6c42c4a4517305a2ae97386fc21
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-3MsHvAMoe6f5dAHYxdDAU4
depends:
    Diff-0.4.1-FxeNHFTYxDKIg5IYEwDazL
    aeson-2.1.2.1-41nZsNdpCJ94QO3IYYsFbV
    aeson-pretty-0.8.10-IZJWvJOS5Pt8YP1BQIa5sH
    ansi-terminal-1.0.2-9CIjNy1ywbv7w6pdI3Bv5F
    atomic-write-0.2.1.1-7nDLrooeUkU1En2o2Br0dz base-4.17.2.1
    base16-bytestring-1.0.2.0-2g7vQYppoMG2r37VyquVQT
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-KKJyu9JGFWV4kYAUCco28N
    cborg-0.2.10.0-6EtzN6lKdvM6wfA7oWZMes
    cborg-json-0.2.6.0-1Gtp5UygU5PA7KsFUz3kkE containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-GfhtmodVm1TDKUEAsbmXLC
    data-fix-0.3.4-LTha4dzDF4F4XkXfeLK9EP deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-7Zp6tBxVD7YDnLCYGhuBhQ exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.2-LDg9GlY5Eao2p4zLZCGOlG
    hashable-1.4.4.0-qRezrAQI2A9YjlaZCGaTD haskeline-0.8.2
    http-client-0.7.18-A4jrf0T4IUlJxNtpZ7Nwzn
    http-client-tls-0.3.6.4-LD1hpdHz2s01SRGVBwzZUu
    http-types-0.12.4-4HneWdIW87FoB16iA969W
    indexed-traversable-0.1.4-2szbUMNNPUzJzNFFELzGKG
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-3pvQMUNVcr66BLLEBIDI4Y
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-5qu1Opa5LrJOaefG2BKZh
    optparse-applicative-0.18.1.0-I3dZF1AZY7RGkPlqEy6VM
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-29OO6RRubKi2VNfi1RFGcs
    pretty-simple-4.1.3.0-JDGJ2c1bxH6KWreMPJaXAV
    prettyprinter-1.7.1-7FxwfHkFGwc7hJXAWpcKVm
    prettyprinter-ansi-terminal-1.1.3-Hr0nD63w4DMF62mQlb80ld
    profunctors-5.6.3-PymLQAalAEKVMfrsZfYFk
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.7.0-BwEO4QQ4poVHhQfhShWbCU
    serialise-0.2.6.1-jYyqA45SUMD4NcLBJisiw template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-5ZmUsdendNkGLzTaq5BS6A
    text-short-0.1.6-1oCjatcA1Ln49eMwMPARK0
    th-lift-instances-0.1.20-2lvA8RW5Neh2JR7kvBO0g4 time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.3-7MOpQwyxwK0Jq8BeTkHkvB
    unordered-containers-0.2.20-1XH4GFhGkAzqDGOzdhg7S
    vector-0.13.2.0-7SxE3dSPVCM2VxyJW4x4GJ

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

