#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-CtaHEQAu2nNK6NyW0RT53w
key:                  dhall-1.42.3-CtaHEQAu2nNK6NyW0RT53w
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  c0c4d5ba821930843aeff8e329d09f87
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-CtaHEQAu2nNK6NyW0RT53w
depends:
    Diff-0.5-Kmquztt1Pme7b2u4whWtE aeson-2.1.2.1-CoFGCad0PesDH4XC5ctCv4
    aeson-pretty-0.8.10-6nxfz7a4luE95UqAi5t8dP
    ansi-terminal-1.0.2-JNQYc01xThWEgUAi55dqd4
    atomic-write-0.2.1.1-5LGhJbpnb0RLsRifwqqqYh base-4.17.2.1
    base16-bytestring-1.0.2.0-ISe9mmeVuu6374zTlmWEXC
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-761P1jvxXU26pNc4Eb30SJ
    cborg-0.2.10.0-9Hrr2oeru5vCMAPH6NZhx5
    cborg-json-0.2.6.0-E8xJwZDtJvf9C5gjN8h7qA containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-JBWXGSDAQ7g3JohDhEeY6e
    data-fix-0.3.4-JZbh22uLyZWqGXAfKoGDz deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-DVRV7MwX651AHF1w4Fai0a exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-5wVwZ95fT9hEvoHgT9DPhB
    hashable-1.4.5.0-46ofdJt9DgFJv5hpm4ccL9 haskeline-0.8.2
    http-client-0.7.19-HFBYUAVX9SV94aIPjIMqUW
    http-client-tls-0.3.6.4-I1IVdyrtE11JseC54qsUOj
    http-types-0.12.4-BqXeLjMsy2zE8Q8bHBFhrt
    indexed-traversable-0.1.4-4tpIJXRq7N27Ef4t7nI4Bs
    megaparsec-9.7.0-3LvenIwsMr98PPayp8iMYY
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-4IxerK0JG7wGRLJekUQEdr
    optparse-applicative-0.18.1.0-CZp2uWBrZhVKrqP7dbntdc
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-ALVsMej7KbTGgXV5in5Vk5
    pretty-simple-4.1.3.0-3HNn5XiXTTKImfyRxLqC2U
    prettyprinter-1.7.1-FOlixpN0mDDCGef0cfE7Yp
    prettyprinter-ansi-terminal-1.1.3-J2hiX2mZ69Y4bAjq7wYi3i
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-3ah0qUGLDw61YSMhCVhWLa
    serialise-0.2.6.1-L2loQnJZaFe662jbW5XUhJ template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-GfLEUhrzXiw7qJN5TvUOQ3
    text-short-0.1.6-Ak8LNWwlG5Ft0bmTheLgI
    th-lift-instances-0.1.20-JQomWmBUs8UFOUBupUBy46 time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-7mIDBr1TancFwsGNESA8LC
    unordered-containers-0.2.20-9wNMaDmysQKAAHkxxaXhUB
    vector-0.13.2.0-7UWGIXxclbLLOjGg0s2qXt

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

