#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall-docs
version:              1.0.12
visibility:           public
id:                   dhall-docs-1.0.12-K382VLEdm8OAx2elzfFCdg
key:                  dhall-docs-1.0.12-K382VLEdm8OAx2elzfFCdg
license:              BSD-3-Clause
copyright:            2020 Germán Robayo
maintainer:           GenuineGabriella@gmail.com
author:               Germán Robayo
synopsis:             Generate HTML docs from a dhall package
description:
    Use this package if you want to create HTML documentation from your dhall
    packages:

    * See the "Dhall.Docs" module if you want to use this package as a library

    * Use the @dhall-docs@ program from this package if you want an executable

    The "Dhall.Docs" module also contains instructions for how to use this package

category:             Compiler
abi:                  8ebbae76d5a2f6a0703616a7f884bcd8
exposed:              True
exposed-modules:      Dhall.Docs Dhall.Docs.Core
hidden-modules:
    Dhall.Docs.CodeRenderer Dhall.Docs.Comment Dhall.Docs.Embedded
    Dhall.Docs.Html Dhall.Docs.Markdown Dhall.Docs.Store
    Dhall.Docs.Util Paths_dhall_docs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-docs-1.0.12
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-docs-1.0.12
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-docs-1.0.12
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall-docs
hs-libraries:         HSdhall-docs-1.0.12-K382VLEdm8OAx2elzfFCdg
depends:
    base-4.17.2.1 base16-bytestring-1.0.2.0-KBep11INWPS4gh3hA0irR7
    bytestring-0.11.5.3 containers-0.6.7
    cryptohash-sha256-0.11.102.1-16wRg0gM8EaDoVyZpUOCza
    dhall-1.42.2-EZMh3BUVdR52oMUj5x1SS5 directory-1.3.7.1
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    lucid-2.11.20230408-HiJfMKFjOuHGydinQxLGEW
    megaparsec-9.6.1-6qeEGREH0fMn1gOMY5ab1
    mmark-0.0.7.6-GTbsSZuBYoN9aC5FTcdmV3 mtl-2.2.2
    optparse-applicative-0.17.1.0-CKO7Hv5HIMoIThZFruc57S
    path-0.9.5-4ufoUJBOZ8QHS3XKuacr6a
    path-io-1.8.2-3yFmr2DypYjC6EUTJQRsSG
    prettyprinter-1.7.1-K49FGRh0RcS7wKSRgaQVIq text-2.0.2
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/dhall-docs/html/dhall-docs.haddock
haddock-html:         /usr/share/doc/dhall-docs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

