#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall-docs
version:              1.0.12
visibility:           public
id:                   dhall-docs-1.0.12-63MKsj0ij31G7zk1UTcOlm
key:                  dhall-docs-1.0.12-63MKsj0ij31G7zk1UTcOlm
license:              BSD-3-Clause
copyright:            2020 Germán Robayo
maintainer:           GenuineGabriella@gmail.com
author:               Germán Robayo
synopsis:             Generate HTML docs from a dhall package
description:
    Use this package if you want to create HTML documentation from your dhall
    packages:

    * See the "Dhall.Docs" module if you want to use this package as a library

    * Use the @dhall-docs@ program from this package if you want an executable

    The "Dhall.Docs" module also contains instructions for how to use this package

category:             Compiler
abi:                  0303badd3cb92909f51b46bad4101ec0
exposed:              True
exposed-modules:      Dhall.Docs Dhall.Docs.Core
hidden-modules:
    Dhall.Docs.CodeRenderer Dhall.Docs.Comment Dhall.Docs.Embedded
    Dhall.Docs.Html Dhall.Docs.Markdown Dhall.Docs.Store
    Dhall.Docs.Util Paths_dhall_docs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-docs-1.0.12
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-docs-1.0.12
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-docs-1.0.12
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall-docs
hs-libraries:         HSdhall-docs-1.0.12-63MKsj0ij31G7zk1UTcOlm
depends:
    base-4.17.2.1 base16-bytestring-1.0.2.0-C3cPjjLt0AO1rbHXbT6P0Z
    bytestring-0.11.5.3 containers-0.6.7
    cryptohash-sha256-0.11.102.1-qCC3j6usTK8QvKkToMNCt
    dhall-1.42.2-2XAWUPKXodiLiObtOtprtL directory-1.3.7.1
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    lucid-2.11.20230408-9XStOCn9r58DdHooc9ig19
    megaparsec-9.6.1-EEBj4pRLerNCeJDumClMn7
    mmark-0.0.7.6-8Y3j5PdHskF1qh2jn2f0k4 mtl-2.2.2
    optparse-applicative-0.18.1.0-HLRS0wxhkSb4kVPN7e82uH
    path-0.9.5-4DANHz7ihWnDB20rufz25Z
    path-io-1.8.2-JXzsnP5MRVLJ9a8xdsOurt
    prettyprinter-1.7.1-H0iQpJbBZ6k9IFy5REj5dh text-2.0.2
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/dhall-docs/html/dhall-docs.haddock
haddock-html:         /usr/share/doc/dhall-docs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

