complete -c import -o adjoin -d 'Join images into a single multi-image file'
complete -c import -o border -d 'Include window border in the output image'
complete -c import -o channel -d 'Apply option to select image channels [type]' -xa '(import -list channel)'
complete -c import -o colorspace -d 'Alternate image colorspace [type]' -xa '(import -list colorspace)'
complete -c import -o comment -d 'Annotate image with comment [string]'
complete -c import -o compress -d 'Type of pixel compression when writing the image [type]' -xa '(import -list compress)'
complete -c import -o define -d 'Define one or more image format options [format:option]'
complete -c import -o density -d 'Horizontal and vertical density of the image [geometry]'
complete -c import -o depth -d 'Image depth [value]'
complete -c import -o descend -d 'Obtain image by descending window hierarchy'
complete -c import -o display -d 'X server to contact [server]'
complete -c import -o dispose -d 'Layer disposal method [method]' -xa '(import -list dispose)'
complete -c import -o dither -d 'Apply error diffusion to image [method]' -xa '(import -list dither)'
complete -c import -o delay -d 'Display the next image after pausing [value]'
complete -c import -o encipher -d 'Convert plain pixels to cipher pixels [filename]' -r
complete -c import -o endian -d 'Endianness (MSB or LSB) of the image [type]' -xa '(import -list endian)'
complete -c import -o encoding -d 'Encoding type [type text]' -xa '(__fish_print_encodings)'
complete -c import -o filter -d 'Use this filter when resizing an image [type]' -xa '(import -list filter)'
complete -c import -o format -d 'Output formatted image characteristics ["string"]'
complete -c import -o frame -d 'Include window manager frame'
complete -c import -o gravity -d 'Direction which direction to gravitate towards'
complete -c import -o identify -d 'Identify the format and characteristics of the image'
complete -c import -o interlace -d 'None, Line, Plane, or Partition [type]' -xa '(import -list interlace)'
complete -c import -o interpolate -d 'Pixel color interpolation method [method]' -xa '(import -list interpolate)'
complete -c import -o label -d 'Assign a label to an image [string]'
complete -c import -o limit -d 'Area, Disk, Map, or Memory resource limit [type value]' -x
complete -c import -o monitor -d 'Monitor progress'
complete -c import -o page -d 'Size and location of an image canvas [geometry]'
complete -c import -o pause -d 'Seconds delay between snapshots [value]'
complete -c import -o pointsize -d 'Font point size [value]'
complete -c import -o quality -d 'JPEG/MIFF/PNG compression level [value]'
complete -c import -o quiet -d 'Suppress all warning messages'
complete -c import -o regard-warnings -d 'Pay attention to warning messages'
complete -c import -o respect-parentheses -d 'Settings remain in effect until parenthesis boundary'
complete -c import -o sampling-factor -d 'Horizontal and vertical sampling factor [geometry]'
complete -c import -o scene -d 'Image scene number [value]'
complete -c import -o screen -d 'Select image from root window'
complete -c import -o seed -d 'Seed a new sequence of pseudo-random numbers [value]'
complete -c import -o set -d 'Set an image property [property value]'
complete -c import -o silent -d 'Operate silently, i.e. don\'t ring any bells '
complete -c import -o snaps -d 'Number of screen snapshots [value]'
complete -c import -o synchronize -d 'Synchronize image to storage device'
complete -c import -o taint -d 'Declare the image as modified'
complete -c import -o transparent-color -d 'Transparent color [color]' -xa '(__fish_complete_convert_options color)'
complete -c import -o treedepth -d 'Color tree depth [value]'
complete -c import -o verbose -d 'Print detailed information about the image'
complete -c import -o virtual-pixel -d 'Constant, Edge, Mirror, or Tile [method]' -xa '(import -list virtual-pixel)'
complete -c import -o window -d 'Select window with this id or name [id]' -xa 'root (__fish_print_xwindows)'
complete -c import -o annotate -d 'Annotate the image with text [geometry text]'
complete -c import -o colors -d 'Preferred number of colors in the image [value]'
complete -c import -o crop -d 'Preferred size and location of the cropped image [geometry]'
complete -c import -o geometry -d 'Preferred size or location of the image [geometry]'
complete -c import -o help -d 'Print program options'
complete -c import -o monochrome -d 'Transform image to black and white'
complete -c import -o negate -d 'Replace every pixel with its complementary color '
complete -c import -o repage -d 'Size and location of an image canvas [geometry]'
complete -c import -o quantize -d 'Reduce colors in this colorspace [colorspace]' -xa '(import -list colorspace)'
complete -c import -o resize -d 'Resize the image [geometry]'
complete -c import -o rotate -d 'Apply Paeth rotation to the image [degrees]'
complete -c import -o strip -d 'Strip image of all profiles and comments'
complete -c import -o thumbnail -d 'Create a thumbnail of the image [geometry]'
complete -c import -o transparent -d 'Make this color transparent within the image [color]' -xa '(__fish_complete_convert_options color)'
complete -c import -o trim -d 'Trim image edges'
complete -c import -o type -d 'Image type [type]' -xa '(import -list type)'
complete -c import -o debug -d 'Display copious debugging information [events]' -xa '(import -list debug)'
complete -c import -o list -d 'Print a list of supported option arguments [type]' -xa '(import -list list)'
complete -c import -o log -d 'Format of debugging information [format]' -xa '(__fish_complete_convert_options format)'
complete -c import -o version -d 'Print version information'
complete -c import -o support -d 'Resize support: > 1.0 is blurry, < 1.0 is sharp [factor]'
