/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.util.Objects;
import org.freeplane.api.ConditionalStyle;
import org.freeplane.api.ConditionalStyleRO;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AConditionalStylesProxy;
import org.freeplane.plugin.script.proxy.NodeConditionalStyleProxy;

public class NodeConditionalStylesProxy
extends AConditionalStylesProxy<NodeModel> {
    NodeConditionalStylesProxy(NodeModel delegate, ScriptContext scriptContext) {
        super(delegate, scriptContext);
    }

    NodeConditionalStyleProxy createProxy(ConditionalStyleModel.Item item) {
        return new NodeConditionalStyleProxy((NodeModel)this.getDelegate(), item);
    }

    NodeConditionalStyleProxy createProxy(boolean isActive, String script, String styleName, boolean isLast) {
        return new NodeConditionalStyleProxy((NodeModel)this.getDelegate(), isActive, script, styleName, isLast);
    }

    @Override
    ConditionalStyleModel getConditionalStyleModel() {
        return ConditionalStyleModel.createConditionalStyleModel((NodeModel)((NodeModel)this.getDelegate()));
    }

    public void add(ConditionalStyleRO conditionalStyle) {
        NodeConditionalStyleProxy cs = (NodeConditionalStyleProxy)Objects.requireNonNull(conditionalStyle, "ConditionalStyle mustn't be null");
        MLogicalStyleController controller = (MLogicalStyleController)LogicalStyleController.getController();
        controller.addConditionalStyle(((NodeModel)this.getDelegate()).getMap(), this.getConditionalStyleModel(), cs.isActive(), cs.getCondition(), cs.getStyle(), cs.isLast());
        this.callDelayedRefresh((NodeModel)this.getDelegate());
    }

    public void insert(int index, ConditionalStyleRO conditionalStyle) {
        NodeConditionalStyleProxy cs = (NodeConditionalStyleProxy)Objects.requireNonNull(conditionalStyle, "ConditionalStyle mustn't be null");
        MLogicalStyleController controller = (MLogicalStyleController)LogicalStyleController.getController();
        controller.insertConditionalStyle(((NodeModel)this.getDelegate()).getMap(), this.getConditionalStyleModel(), index, cs.isActive(), cs.getCondition(), cs.getStyle(), cs.isLast());
        this.callDelayedRefresh((NodeModel)this.getDelegate());
    }

    public void move(int index, int toIndex) {
        MLogicalStyleController controller = (MLogicalStyleController)LogicalStyleController.getController();
        controller.moveConditionalStyle(((NodeModel)this.getDelegate()).getMap(), this.getConditionalStyleModel(), index, toIndex);
        this.callDelayedRefresh((NodeModel)this.getDelegate());
    }

    public ConditionalStyle remove(int index) {
        MLogicalStyleController controller = (MLogicalStyleController)LogicalStyleController.getController();
        ConditionalStyleModel.Item item = controller.removeConditionalStyle(((NodeModel)this.getDelegate()).getMap(), this.getConditionalStyleModel(), index);
        this.callDelayedRefresh((NodeModel)this.getDelegate());
        return new NodeConditionalStyleProxy((NodeModel)this.getDelegate(), item);
    }

    private void callDelayedRefresh(NodeModel nodeModel) {
        Controller.getCurrentModeController().getMapController().refreshNodeLaterUndoable(nodeModel, NodeModel.UNKNOWN_PROPERTY, null, null);
    }
}

